package io.ciera.tool.sql.ooaofooa.persistenceassociations.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.C_C;
import io.ciera.tool.sql.ooaofooa.component.Delegation;
import io.ciera.tool.sql.ooaofooa.component.impl.C_CImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.DelegationImpl;
import io.ciera.tool.sql.ooaofooa.persistenceassociations.DelegationInComponent;


public class DelegationInComponentImpl extends ModelInstance<DelegationInComponent,Sql> implements DelegationInComponent {

    public static final String KEY_LETTERS = "PA_DIC";
    public static final DelegationInComponent EMPTY_DELEGATIONINCOMPONENT = new EmptyDelegationInComponent();

    private Sql context;

    // constructors
    private DelegationInComponentImpl( Sql context ) {
        this.context = context;
        ref_Component_Id = UniqueId.random();
        ref_Delegation_Id = UniqueId.random();
        R9002_C_C_inst = C_CImpl.EMPTY_C_C;
        R9002_Delegation_inst = DelegationImpl.EMPTY_DELEGATION;
    }

    private DelegationInComponentImpl( Sql context, UniqueId instanceId, UniqueId ref_Component_Id, UniqueId ref_Delegation_Id ) {
        super(instanceId);
        this.context = context;
        this.ref_Component_Id = ref_Component_Id;
        this.ref_Delegation_Id = ref_Delegation_Id;
        R9002_C_C_inst = C_CImpl.EMPTY_C_C;
        R9002_Delegation_inst = DelegationImpl.EMPTY_DELEGATION;
    }

    public static DelegationInComponent create( Sql context ) throws XtumlException {
        DelegationInComponent newDelegationInComponent = new DelegationInComponentImpl( context );
        if ( context.addInstance( newDelegationInComponent ) ) {
            newDelegationInComponent.getRunContext().addChange(new InstanceCreatedDelta(newDelegationInComponent, KEY_LETTERS));
            return newDelegationInComponent;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static DelegationInComponent create( Sql context, UniqueId instanceId, UniqueId ref_Component_Id, UniqueId ref_Delegation_Id ) throws XtumlException {
        DelegationInComponent newDelegationInComponent = new DelegationInComponentImpl( context, instanceId, ref_Component_Id, ref_Delegation_Id );
        if ( context.addInstance( newDelegationInComponent ) ) {
            return newDelegationInComponent;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Component_Id;
    @Override
    public void setComponent_Id(UniqueId ref_Component_Id) throws XtumlException {
        checkLiving();
        if (ref_Component_Id.inequality( this.ref_Component_Id)) {
            final UniqueId oldValue = this.ref_Component_Id;
            this.ref_Component_Id = ref_Component_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Component_Id", oldValue, this.ref_Component_Id));
        }
    }
    @Override
    public UniqueId getComponent_Id() throws XtumlException {
        checkLiving();
        return ref_Component_Id;
    }
    private UniqueId ref_Delegation_Id;
    @Override
    public UniqueId getDelegation_Id() throws XtumlException {
        checkLiving();
        return ref_Delegation_Id;
    }
    @Override
    public void setDelegation_Id(UniqueId ref_Delegation_Id) throws XtumlException {
        checkLiving();
        if (ref_Delegation_Id.inequality( this.ref_Delegation_Id)) {
            final UniqueId oldValue = this.ref_Delegation_Id;
            this.ref_Delegation_Id = ref_Delegation_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Delegation_Id", oldValue, this.ref_Delegation_Id));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getComponent_Id(), getDelegation_Id());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private C_C R9002_C_C_inst;
    @Override
    public void setR9002_C_C( C_C inst ) {
        R9002_C_C_inst = inst;
    }
    @Override
    public C_C R9002_C_C() throws XtumlException {
        return R9002_C_C_inst;
    }
    private Delegation R9002_Delegation_inst;
    @Override
    public void setR9002_Delegation( Delegation inst ) {
        R9002_Delegation_inst = inst;
    }
    @Override
    public Delegation R9002_Delegation() throws XtumlException {
        return R9002_Delegation_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public DelegationInComponent self() {
        return this;
    }

    @Override
    public DelegationInComponent oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_DELEGATIONINCOMPONENT;
    }

}

class EmptyDelegationInComponent extends ModelInstance<DelegationInComponent,Sql> implements DelegationInComponent {

    // attributes
    public void setComponent_Id( UniqueId ref_Component_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getComponent_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getDelegation_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDelegation_Id( UniqueId ref_Delegation_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public C_C R9002_C_C() {
        return C_CImpl.EMPTY_C_C;
    }
    @Override
    public Delegation R9002_Delegation() {
        return DelegationImpl.EMPTY_DELEGATION;
    }


    @Override
    public String getKeyLetters() {
        return DelegationInComponentImpl.KEY_LETTERS;
    }

    @Override
    public DelegationInComponent self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public DelegationInComponent oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return DelegationInComponentImpl.EMPTY_DELEGATIONINCOMPONENT;
    }

}
