package io.ciera.tool.sql.ooaofooa.message.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.message.MessageArgument;
import io.ciera.tool.sql.ooaofooa.message.OperationArgument;
import io.ciera.tool.sql.ooaofooa.message.impl.MessageArgumentImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.OperationParameter;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.OperationParameterImpl;


public class OperationArgumentImpl extends ModelInstance<OperationArgument,Sql> implements OperationArgument {

    public static final String KEY_LETTERS = "MSG_OA";
    public static final OperationArgument EMPTY_OPERATIONARGUMENT = new EmptyOperationArgument();

    private Sql context;

    // constructors
    private OperationArgumentImpl( Sql context ) {
        this.context = context;
        ref_Arg_ID = UniqueId.random();
        ref_TParm_ID = UniqueId.random();
        R1013_is_a_MessageArgument_inst = MessageArgumentImpl.EMPTY_MESSAGEARGUMENT;
        R1015_is_represented_by_OperationParameter_inst = OperationParameterImpl.EMPTY_OPERATIONPARAMETER;
    }

    private OperationArgumentImpl( Sql context, UniqueId instanceId, UniqueId ref_Arg_ID, UniqueId ref_TParm_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Arg_ID = ref_Arg_ID;
        this.ref_TParm_ID = ref_TParm_ID;
        R1013_is_a_MessageArgument_inst = MessageArgumentImpl.EMPTY_MESSAGEARGUMENT;
        R1015_is_represented_by_OperationParameter_inst = OperationParameterImpl.EMPTY_OPERATIONPARAMETER;
    }

    public static OperationArgument create( Sql context ) throws XtumlException {
        OperationArgument newOperationArgument = new OperationArgumentImpl( context );
        if ( context.addInstance( newOperationArgument ) ) {
            newOperationArgument.getRunContext().addChange(new InstanceCreatedDelta(newOperationArgument, KEY_LETTERS));
            return newOperationArgument;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static OperationArgument create( Sql context, UniqueId instanceId, UniqueId ref_Arg_ID, UniqueId ref_TParm_ID ) throws XtumlException {
        OperationArgument newOperationArgument = new OperationArgumentImpl( context, instanceId, ref_Arg_ID, ref_TParm_ID );
        if ( context.addInstance( newOperationArgument ) ) {
            return newOperationArgument;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Arg_ID;
    @Override
    public void setArg_ID(UniqueId ref_Arg_ID) throws XtumlException {
        checkLiving();
        if (ref_Arg_ID.inequality( this.ref_Arg_ID)) {
            final UniqueId oldValue = this.ref_Arg_ID;
            this.ref_Arg_ID = ref_Arg_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Arg_ID", oldValue, this.ref_Arg_ID));
        }
    }
    @Override
    public UniqueId getArg_ID() throws XtumlException {
        checkLiving();
        return ref_Arg_ID;
    }
    private UniqueId ref_TParm_ID;
    @Override
    public UniqueId getTParm_ID() throws XtumlException {
        checkLiving();
        return ref_TParm_ID;
    }
    @Override
    public void setTParm_ID(UniqueId ref_TParm_ID) throws XtumlException {
        checkLiving();
        if (ref_TParm_ID.inequality( this.ref_TParm_ID)) {
            final UniqueId oldValue = this.ref_TParm_ID;
            this.ref_TParm_ID = ref_TParm_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_TParm_ID", oldValue, this.ref_TParm_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getArg_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private MessageArgument R1013_is_a_MessageArgument_inst;
    @Override
    public void setR1013_is_a_MessageArgument( MessageArgument inst ) {
        R1013_is_a_MessageArgument_inst = inst;
    }
    @Override
    public MessageArgument R1013_is_a_MessageArgument() throws XtumlException {
        return R1013_is_a_MessageArgument_inst;
    }
    private OperationParameter R1015_is_represented_by_OperationParameter_inst;
    @Override
    public void setR1015_is_represented_by_OperationParameter( OperationParameter inst ) {
        R1015_is_represented_by_OperationParameter_inst = inst;
    }
    @Override
    public OperationParameter R1015_is_represented_by_OperationParameter() throws XtumlException {
        return R1015_is_represented_by_OperationParameter_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public OperationArgument self() {
        return this;
    }

    @Override
    public OperationArgument oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_OPERATIONARGUMENT;
    }

}

class EmptyOperationArgument extends ModelInstance<OperationArgument,Sql> implements OperationArgument {

    // attributes
    public void setArg_ID( UniqueId ref_Arg_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getArg_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getTParm_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setTParm_ID( UniqueId ref_TParm_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public MessageArgument R1013_is_a_MessageArgument() {
        return MessageArgumentImpl.EMPTY_MESSAGEARGUMENT;
    }
    @Override
    public OperationParameter R1015_is_represented_by_OperationParameter() {
        return OperationParameterImpl.EMPTY_OPERATIONPARAMETER;
    }


    @Override
    public String getKeyLetters() {
        return OperationArgumentImpl.KEY_LETTERS;
    }

    @Override
    public OperationArgument self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public OperationArgument oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return OperationArgumentImpl.EMPTY_OPERATIONARGUMENT;
    }

}
