package io.ciera.tool.sql.ooaofooa.interaction.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.interaction.ClassParticipantAttribute;
import io.ciera.tool.sql.ooaofooa.interaction.InformalAttribute;
import io.ciera.tool.sql.ooaofooa.interaction.impl.ClassParticipantAttributeImpl;


public class InformalAttributeImpl extends ModelInstance<InformalAttribute,Sql> implements InformalAttribute {

    public static final String KEY_LETTERS = "SQ_IA";
    public static final InformalAttribute EMPTY_INFORMALATTRIBUTE = new EmptyInformalAttribute();

    private Sql context;

    // constructors
    private InformalAttributeImpl( Sql context ) {
        this.context = context;
        ref_Ia_ID = UniqueId.random();
        R947_is_a_ClassParticipantAttribute_inst = ClassParticipantAttributeImpl.EMPTY_CLASSPARTICIPANTATTRIBUTE;
    }

    private InformalAttributeImpl( Sql context, UniqueId instanceId, UniqueId ref_Ia_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Ia_ID = ref_Ia_ID;
        R947_is_a_ClassParticipantAttribute_inst = ClassParticipantAttributeImpl.EMPTY_CLASSPARTICIPANTATTRIBUTE;
    }

    public static InformalAttribute create( Sql context ) throws XtumlException {
        InformalAttribute newInformalAttribute = new InformalAttributeImpl( context );
        if ( context.addInstance( newInformalAttribute ) ) {
            newInformalAttribute.getRunContext().addChange(new InstanceCreatedDelta(newInformalAttribute, KEY_LETTERS));
            return newInformalAttribute;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static InformalAttribute create( Sql context, UniqueId instanceId, UniqueId ref_Ia_ID ) throws XtumlException {
        InformalAttribute newInformalAttribute = new InformalAttributeImpl( context, instanceId, ref_Ia_ID );
        if ( context.addInstance( newInformalAttribute ) ) {
            return newInformalAttribute;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Ia_ID;
    @Override
    public UniqueId getIa_ID() throws XtumlException {
        checkLiving();
        return ref_Ia_ID;
    }
    @Override
    public void setIa_ID(UniqueId ref_Ia_ID) throws XtumlException {
        checkLiving();
        if (ref_Ia_ID.inequality( this.ref_Ia_ID)) {
            final UniqueId oldValue = this.ref_Ia_ID;
            this.ref_Ia_ID = ref_Ia_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Ia_ID", oldValue, this.ref_Ia_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getIa_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ClassParticipantAttribute R947_is_a_ClassParticipantAttribute_inst;
    @Override
    public void setR947_is_a_ClassParticipantAttribute( ClassParticipantAttribute inst ) {
        R947_is_a_ClassParticipantAttribute_inst = inst;
    }
    @Override
    public ClassParticipantAttribute R947_is_a_ClassParticipantAttribute() throws XtumlException {
        return R947_is_a_ClassParticipantAttribute_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public InformalAttribute self() {
        return this;
    }

    @Override
    public InformalAttribute oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_INFORMALATTRIBUTE;
    }

}

class EmptyInformalAttribute extends ModelInstance<InformalAttribute,Sql> implements InformalAttribute {

    // attributes
    public UniqueId getIa_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIa_ID( UniqueId ref_Ia_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ClassParticipantAttribute R947_is_a_ClassParticipantAttribute() {
        return ClassParticipantAttributeImpl.EMPTY_CLASSPARTICIPANTATTRIBUTE;
    }


    @Override
    public String getKeyLetters() {
        return InformalAttributeImpl.KEY_LETTERS;
    }

    @Override
    public InformalAttribute self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public InformalAttribute oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return InformalAttributeImpl.EMPTY_INFORMALATTRIBUTE;
    }

}
