package io.ciera.tool.sql.ooaofooa.instance.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.association.Association;
import io.ciera.tool.sql.ooaofooa.association.impl.AssociationImpl;
import io.ciera.tool.sql.ooaofooa.instance.I_INS;
import io.ciera.tool.sql.ooaofooa.instance.Link;
import io.ciera.tool.sql.ooaofooa.instance.LinkParticipation;
import io.ciera.tool.sql.ooaofooa.instance.LinkSet;
import io.ciera.tool.sql.ooaofooa.instance.impl.I_INSImpl;
import io.ciera.tool.sql.ooaofooa.instance.impl.LinkSetImpl;


public class LinkParticipationImpl extends ModelInstance<LinkParticipation,Sql> implements LinkParticipation {

    public static final String KEY_LETTERS = "I_LIP";
    public static final LinkParticipation EMPTY_LINKPARTICIPATION = new EmptyLinkParticipation();

    private Sql context;

    // constructors
    private LinkParticipationImpl( Sql context ) {
        this.context = context;
        m_Participation_ID = UniqueId.random();
        ref_Rel_ID = UniqueId.random();
        ref_Inst_ID = UniqueId.random();
        m_Label = "";
        R2901_is_origin_of_Link_set = new LinkSetImpl();
        R2902_is_destination_of_Link_set = new LinkSetImpl();
        R2903_is_associator_for_Link_set = new LinkSetImpl();
        R2958_I_INS_inst = I_INSImpl.EMPTY_I_INS;
        R2959_Association_inst = AssociationImpl.EMPTY_ASSOCIATION;
    }

    private LinkParticipationImpl( Sql context, UniqueId instanceId, UniqueId m_Participation_ID, UniqueId ref_Rel_ID, UniqueId ref_Inst_ID, String m_Label ) {
        super(instanceId);
        this.context = context;
        this.m_Participation_ID = m_Participation_ID;
        this.ref_Rel_ID = ref_Rel_ID;
        this.ref_Inst_ID = ref_Inst_ID;
        this.m_Label = m_Label;
        R2901_is_origin_of_Link_set = new LinkSetImpl();
        R2902_is_destination_of_Link_set = new LinkSetImpl();
        R2903_is_associator_for_Link_set = new LinkSetImpl();
        R2958_I_INS_inst = I_INSImpl.EMPTY_I_INS;
        R2959_Association_inst = AssociationImpl.EMPTY_ASSOCIATION;
    }

    public static LinkParticipation create( Sql context ) throws XtumlException {
        LinkParticipation newLinkParticipation = new LinkParticipationImpl( context );
        if ( context.addInstance( newLinkParticipation ) ) {
            newLinkParticipation.getRunContext().addChange(new InstanceCreatedDelta(newLinkParticipation, KEY_LETTERS));
            return newLinkParticipation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static LinkParticipation create( Sql context, UniqueId instanceId, UniqueId m_Participation_ID, UniqueId ref_Rel_ID, UniqueId ref_Inst_ID, String m_Label ) throws XtumlException {
        LinkParticipation newLinkParticipation = new LinkParticipationImpl( context, instanceId, m_Participation_ID, ref_Rel_ID, ref_Inst_ID, m_Label );
        if ( context.addInstance( newLinkParticipation ) ) {
            return newLinkParticipation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Participation_ID;
    @Override
    public void setParticipation_ID(UniqueId m_Participation_ID) throws XtumlException {
        checkLiving();
        if (m_Participation_ID.inequality( this.m_Participation_ID)) {
            final UniqueId oldValue = this.m_Participation_ID;
            this.m_Participation_ID = m_Participation_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Participation_ID", oldValue, this.m_Participation_ID));
        }
    }
    @Override
    public UniqueId getParticipation_ID() throws XtumlException {
        checkLiving();
        return m_Participation_ID;
    }
    private UniqueId ref_Rel_ID;
    @Override
    public void setRel_ID(UniqueId ref_Rel_ID) throws XtumlException {
        checkLiving();
        if (ref_Rel_ID.inequality( this.ref_Rel_ID)) {
            final UniqueId oldValue = this.ref_Rel_ID;
            this.ref_Rel_ID = ref_Rel_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Rel_ID", oldValue, this.ref_Rel_ID));
            if ( !R2902_is_destination_of_Link().isEmpty() ) R2902_is_destination_of_Link().setRel_ID( ref_Rel_ID );
            if ( !R2901_is_origin_of_Link().isEmpty() ) R2901_is_origin_of_Link().setRel_ID( ref_Rel_ID );
            if ( !R2903_is_associator_for_Link().isEmpty() ) R2903_is_associator_for_Link().setRel_ID( ref_Rel_ID );
        }
    }
    @Override
    public UniqueId getRel_ID() throws XtumlException {
        checkLiving();
        return ref_Rel_ID;
    }
    private UniqueId ref_Inst_ID;
    @Override
    public UniqueId getInst_ID() throws XtumlException {
        checkLiving();
        return ref_Inst_ID;
    }
    @Override
    public void setInst_ID(UniqueId ref_Inst_ID) throws XtumlException {
        checkLiving();
        if (ref_Inst_ID.inequality( this.ref_Inst_ID)) {
            final UniqueId oldValue = this.ref_Inst_ID;
            this.ref_Inst_ID = ref_Inst_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Inst_ID", oldValue, this.ref_Inst_ID));
            if ( !R2902_is_destination_of_Link().isEmpty() ) R2902_is_destination_of_Link().setToInst_ID( ref_Inst_ID );
            if ( !R2903_is_associator_for_Link().isEmpty() ) R2903_is_associator_for_Link().setAssocInst_ID( ref_Inst_ID );
            if ( !R2901_is_origin_of_Link().isEmpty() ) R2901_is_origin_of_Link().setFromInst_ID( ref_Inst_ID );
        }
    }
    private String m_Label;
    @Override
    public void setLabel(String m_Label) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Label, this.m_Label)) {
            final String oldValue = this.m_Label;
            this.m_Label = m_Label;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Label", oldValue, this.m_Label));
        }
    }
    @Override
    public String getLabel() throws XtumlException {
        checkLiving();
        return m_Label;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getRel_ID(), getInst_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private LinkSet R2901_is_origin_of_Link_set;
    @Override
    public void addR2901_is_origin_of_Link( Link inst ) {
        R2901_is_origin_of_Link_set.add(inst);
    }
    @Override
    public void removeR2901_is_origin_of_Link( Link inst ) {
        R2901_is_origin_of_Link_set.remove(inst);
    }
    @Override
    public LinkSet R2901_is_origin_of_Link() throws XtumlException {
        return R2901_is_origin_of_Link_set;
    }
    private LinkSet R2902_is_destination_of_Link_set;
    @Override
    public void addR2902_is_destination_of_Link( Link inst ) {
        R2902_is_destination_of_Link_set.add(inst);
    }
    @Override
    public void removeR2902_is_destination_of_Link( Link inst ) {
        R2902_is_destination_of_Link_set.remove(inst);
    }
    @Override
    public LinkSet R2902_is_destination_of_Link() throws XtumlException {
        return R2902_is_destination_of_Link_set;
    }
    private LinkSet R2903_is_associator_for_Link_set;
    @Override
    public void addR2903_is_associator_for_Link( Link inst ) {
        R2903_is_associator_for_Link_set.add(inst);
    }
    @Override
    public void removeR2903_is_associator_for_Link( Link inst ) {
        R2903_is_associator_for_Link_set.remove(inst);
    }
    @Override
    public LinkSet R2903_is_associator_for_Link() throws XtumlException {
        return R2903_is_associator_for_Link_set;
    }
    private I_INS R2958_I_INS_inst;
    @Override
    public void setR2958_I_INS( I_INS inst ) {
        R2958_I_INS_inst = inst;
    }
    @Override
    public I_INS R2958_I_INS() throws XtumlException {
        return R2958_I_INS_inst;
    }
    private Association R2959_Association_inst;
    @Override
    public void setR2959_Association( Association inst ) {
        R2959_Association_inst = inst;
    }
    @Override
    public Association R2959_Association() throws XtumlException {
        return R2959_Association_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public LinkParticipation self() {
        return this;
    }

    @Override
    public LinkParticipation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_LINKPARTICIPATION;
    }

}

class EmptyLinkParticipation extends ModelInstance<LinkParticipation,Sql> implements LinkParticipation {

    // attributes
    public void setParticipation_ID( UniqueId m_Participation_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getParticipation_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRel_ID( UniqueId ref_Rel_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getRel_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getInst_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setInst_ID( UniqueId ref_Inst_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setLabel( String m_Label ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLabel() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public LinkSet R2901_is_origin_of_Link() {
        return (new LinkSetImpl());
    }
    @Override
    public LinkSet R2902_is_destination_of_Link() {
        return (new LinkSetImpl());
    }
    @Override
    public LinkSet R2903_is_associator_for_Link() {
        return (new LinkSetImpl());
    }
    @Override
    public I_INS R2958_I_INS() {
        return I_INSImpl.EMPTY_I_INS;
    }
    @Override
    public Association R2959_Association() {
        return AssociationImpl.EMPTY_ASSOCIATION;
    }


    @Override
    public String getKeyLetters() {
        return LinkParticipationImpl.KEY_LETTERS;
    }

    @Override
    public LinkParticipation self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public LinkParticipation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return LinkParticipationImpl.EMPTY_LINKPARTICIPATION;
    }

}
