package io.ciera.tool.sql.ooaofooa.instance.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.instance.ComponentInstance;
import io.ciera.tool.sql.ooaofooa.instance.ComponentInstanceContainer;
import io.ciera.tool.sql.ooaofooa.instance.ComponentInstanceSet;
import io.ciera.tool.sql.ooaofooa.instance.impl.ComponentInstanceImpl;
import io.ciera.tool.sql.ooaofooa.instance.impl.ComponentInstanceSetImpl;


public class ComponentInstanceContainerImpl extends ModelInstance<ComponentInstanceContainer,Sql> implements ComponentInstanceContainer {

    public static final String KEY_LETTERS = "I_CIN";
    public static final ComponentInstanceContainer EMPTY_COMPONENTINSTANCECONTAINER = new EmptyComponentInstanceContainer();

    private Sql context;

    // constructors
    private ComponentInstanceContainerImpl( Sql context ) {
        this.context = context;
        ref_Container_ID = UniqueId.random();
        R2974_ComponentInstance_inst = ComponentInstanceImpl.EMPTY_COMPONENTINSTANCE;
        R2975_ComponentInstance_set = new ComponentInstanceSetImpl();
    }

    private ComponentInstanceContainerImpl( Sql context, UniqueId instanceId, UniqueId ref_Container_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Container_ID = ref_Container_ID;
        R2974_ComponentInstance_inst = ComponentInstanceImpl.EMPTY_COMPONENTINSTANCE;
        R2975_ComponentInstance_set = new ComponentInstanceSetImpl();
    }

    public static ComponentInstanceContainer create( Sql context ) throws XtumlException {
        ComponentInstanceContainer newComponentInstanceContainer = new ComponentInstanceContainerImpl( context );
        if ( context.addInstance( newComponentInstanceContainer ) ) {
            newComponentInstanceContainer.getRunContext().addChange(new InstanceCreatedDelta(newComponentInstanceContainer, KEY_LETTERS));
            return newComponentInstanceContainer;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ComponentInstanceContainer create( Sql context, UniqueId instanceId, UniqueId ref_Container_ID ) throws XtumlException {
        ComponentInstanceContainer newComponentInstanceContainer = new ComponentInstanceContainerImpl( context, instanceId, ref_Container_ID );
        if ( context.addInstance( newComponentInstanceContainer ) ) {
            return newComponentInstanceContainer;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Container_ID;
    @Override
    public UniqueId getContainer_ID() throws XtumlException {
        checkLiving();
        return ref_Container_ID;
    }
    @Override
    public void setContainer_ID(UniqueId ref_Container_ID) throws XtumlException {
        checkLiving();
        if (ref_Container_ID.inequality( this.ref_Container_ID)) {
            final UniqueId oldValue = this.ref_Container_ID;
            this.ref_Container_ID = ref_Container_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Container_ID", oldValue, this.ref_Container_ID));
            if ( !R2975_ComponentInstance().isEmpty() ) R2975_ComponentInstance().setContainer_ID( ref_Container_ID );
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getContainer_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ComponentInstance R2974_ComponentInstance_inst;
    @Override
    public void setR2974_ComponentInstance( ComponentInstance inst ) {
        R2974_ComponentInstance_inst = inst;
    }
    @Override
    public ComponentInstance R2974_ComponentInstance() throws XtumlException {
        return R2974_ComponentInstance_inst;
    }
    private ComponentInstanceSet R2975_ComponentInstance_set;
    @Override
    public void addR2975_ComponentInstance( ComponentInstance inst ) {
        R2975_ComponentInstance_set.add(inst);
    }
    @Override
    public void removeR2975_ComponentInstance( ComponentInstance inst ) {
        R2975_ComponentInstance_set.remove(inst);
    }
    @Override
    public ComponentInstanceSet R2975_ComponentInstance() throws XtumlException {
        return R2975_ComponentInstance_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ComponentInstanceContainer self() {
        return this;
    }

    @Override
    public ComponentInstanceContainer oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_COMPONENTINSTANCECONTAINER;
    }

}

class EmptyComponentInstanceContainer extends ModelInstance<ComponentInstanceContainer,Sql> implements ComponentInstanceContainer {

    // attributes
    public UniqueId getContainer_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setContainer_ID( UniqueId ref_Container_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ComponentInstance R2974_ComponentInstance() {
        return ComponentInstanceImpl.EMPTY_COMPONENTINSTANCE;
    }
    @Override
    public ComponentInstanceSet R2975_ComponentInstance() {
        return (new ComponentInstanceSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return ComponentInstanceContainerImpl.KEY_LETTERS;
    }

    @Override
    public ComponentInstanceContainer self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ComponentInstanceContainer oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ComponentInstanceContainerImpl.EMPTY_COMPONENTINSTANCECONTAINER;
    }

}
