package io.ciera.tool.sql.ooaofooa.constants.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.constants.ConstantSpecification;
import io.ciera.tool.sql.ooaofooa.constants.LeafSymbolicConstant;
import io.ciera.tool.sql.ooaofooa.constants.SymbolicConstant;
import io.ciera.tool.sql.ooaofooa.constants.impl.ConstantSpecificationImpl;
import io.ciera.tool.sql.ooaofooa.constants.impl.LeafSymbolicConstantImpl;
import io.ciera.tool.sql.ooaofooa.constants.impl.SymbolicConstantImpl;
import io.ciera.tool.sql.ooaofooa.domain.DataType;
import io.ciera.tool.sql.ooaofooa.domain.impl.DataTypeImpl;
import io.ciera.tool.sql.ooaofooa.value.SymbolicConstantValue;
import io.ciera.tool.sql.ooaofooa.value.SymbolicConstantValueSet;
import io.ciera.tool.sql.ooaofooa.value.impl.SymbolicConstantValueSetImpl;


public class SymbolicConstantImpl extends ModelInstance<SymbolicConstant,Sql> implements SymbolicConstant {

    public static final String KEY_LETTERS = "CNST_SYC";
    public static final SymbolicConstant EMPTY_SYMBOLICCONSTANT = new EmptySymbolicConstant();

    private Sql context;

    // constructors
    private SymbolicConstantImpl( Sql context ) {
        this.context = context;
        m_Const_ID = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        ref_DT_ID = UniqueId.random();
        ref_Constant_Spec_ID = UniqueId.random();
        ref_Previous_Const_ID = UniqueId.random();
        m_Previous_DT_DT_ID_Deprecated = UniqueId.random();
        R1500_is_defined_by_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R1502_is_a_LeafSymbolicConstant_inst = LeafSymbolicConstantImpl.EMPTY_LEAFSYMBOLICCONSTANT;
        R1504_is_contained_by_ConstantSpecification_inst = ConstantSpecificationImpl.EMPTY_CONSTANTSPECIFICATION;
        R1505_precedes_SymbolicConstant_inst = SymbolicConstantImpl.EMPTY_SYMBOLICCONSTANT;
        R1505_succeeds_SymbolicConstant_inst = SymbolicConstantImpl.EMPTY_SYMBOLICCONSTANT;
        R850_SymbolicConstantValue_set = new SymbolicConstantValueSetImpl();
    }

    private SymbolicConstantImpl( Sql context, UniqueId instanceId, UniqueId m_Const_ID, String m_Name, String m_Descrip, UniqueId ref_DT_ID, UniqueId ref_Constant_Spec_ID, UniqueId ref_Previous_Const_ID, UniqueId m_Previous_DT_DT_ID_Deprecated ) {
        super(instanceId);
        this.context = context;
        this.m_Const_ID = m_Const_ID;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        this.ref_DT_ID = ref_DT_ID;
        this.ref_Constant_Spec_ID = ref_Constant_Spec_ID;
        this.ref_Previous_Const_ID = ref_Previous_Const_ID;
        this.m_Previous_DT_DT_ID_Deprecated = m_Previous_DT_DT_ID_Deprecated;
        R1500_is_defined_by_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R1502_is_a_LeafSymbolicConstant_inst = LeafSymbolicConstantImpl.EMPTY_LEAFSYMBOLICCONSTANT;
        R1504_is_contained_by_ConstantSpecification_inst = ConstantSpecificationImpl.EMPTY_CONSTANTSPECIFICATION;
        R1505_precedes_SymbolicConstant_inst = SymbolicConstantImpl.EMPTY_SYMBOLICCONSTANT;
        R1505_succeeds_SymbolicConstant_inst = SymbolicConstantImpl.EMPTY_SYMBOLICCONSTANT;
        R850_SymbolicConstantValue_set = new SymbolicConstantValueSetImpl();
    }

    public static SymbolicConstant create( Sql context ) throws XtumlException {
        SymbolicConstant newSymbolicConstant = new SymbolicConstantImpl( context );
        if ( context.addInstance( newSymbolicConstant ) ) {
            newSymbolicConstant.getRunContext().addChange(new InstanceCreatedDelta(newSymbolicConstant, KEY_LETTERS));
            return newSymbolicConstant;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static SymbolicConstant create( Sql context, UniqueId instanceId, UniqueId m_Const_ID, String m_Name, String m_Descrip, UniqueId ref_DT_ID, UniqueId ref_Constant_Spec_ID, UniqueId ref_Previous_Const_ID, UniqueId m_Previous_DT_DT_ID_Deprecated ) throws XtumlException {
        SymbolicConstant newSymbolicConstant = new SymbolicConstantImpl( context, instanceId, m_Const_ID, m_Name, m_Descrip, ref_DT_ID, ref_Constant_Spec_ID, ref_Previous_Const_ID, m_Previous_DT_DT_ID_Deprecated );
        if ( context.addInstance( newSymbolicConstant ) ) {
            return newSymbolicConstant;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Const_ID;
    @Override
    public void setConst_ID(UniqueId m_Const_ID) throws XtumlException {
        checkLiving();
        if (m_Const_ID.inequality( this.m_Const_ID)) {
            final UniqueId oldValue = this.m_Const_ID;
            this.m_Const_ID = m_Const_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Const_ID", oldValue, this.m_Const_ID));
            if ( !R1505_precedes_SymbolicConstant().isEmpty() ) R1505_precedes_SymbolicConstant().setPrevious_Const_ID( m_Const_ID );
            if ( !R850_SymbolicConstantValue().isEmpty() ) R850_SymbolicConstantValue().setConst_ID( m_Const_ID );
            if ( !R1502_is_a_LeafSymbolicConstant().isEmpty() ) R1502_is_a_LeafSymbolicConstant().setConst_ID( m_Const_ID );
        }
    }
    @Override
    public UniqueId getConst_ID() throws XtumlException {
        checkLiving();
        return m_Const_ID;
    }
    private String m_Name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    private String m_Descrip;
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    private UniqueId ref_DT_ID;
    @Override
    public UniqueId getDT_ID() throws XtumlException {
        checkLiving();
        return ref_DT_ID;
    }
    @Override
    public void setDT_ID(UniqueId ref_DT_ID) throws XtumlException {
        checkLiving();
        if (ref_DT_ID.inequality( this.ref_DT_ID)) {
            final UniqueId oldValue = this.ref_DT_ID;
            this.ref_DT_ID = ref_DT_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_DT_ID", oldValue, this.ref_DT_ID));
        }
    }
    private UniqueId ref_Constant_Spec_ID;
    @Override
    public UniqueId getConstant_Spec_ID() throws XtumlException {
        checkLiving();
        return ref_Constant_Spec_ID;
    }
    @Override
    public void setConstant_Spec_ID(UniqueId ref_Constant_Spec_ID) throws XtumlException {
        checkLiving();
        if (ref_Constant_Spec_ID.inequality( this.ref_Constant_Spec_ID)) {
            final UniqueId oldValue = this.ref_Constant_Spec_ID;
            this.ref_Constant_Spec_ID = ref_Constant_Spec_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Constant_Spec_ID", oldValue, this.ref_Constant_Spec_ID));
        }
    }
    private UniqueId ref_Previous_Const_ID;
    @Override
    public void setPrevious_Const_ID(UniqueId ref_Previous_Const_ID) throws XtumlException {
        checkLiving();
        if (ref_Previous_Const_ID.inequality( this.ref_Previous_Const_ID)) {
            final UniqueId oldValue = this.ref_Previous_Const_ID;
            this.ref_Previous_Const_ID = ref_Previous_Const_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Previous_Const_ID", oldValue, this.ref_Previous_Const_ID));
        }
    }
    @Override
    public UniqueId getPrevious_Const_ID() throws XtumlException {
        checkLiving();
        return ref_Previous_Const_ID;
    }
    private UniqueId m_Previous_DT_DT_ID_Deprecated;
    @Override
    public void setPrevious_DT_DT_ID_Deprecated(UniqueId m_Previous_DT_DT_ID_Deprecated) throws XtumlException {
        checkLiving();
        if (m_Previous_DT_DT_ID_Deprecated.inequality( this.m_Previous_DT_DT_ID_Deprecated)) {
            final UniqueId oldValue = this.m_Previous_DT_DT_ID_Deprecated;
            this.m_Previous_DT_DT_ID_Deprecated = m_Previous_DT_DT_ID_Deprecated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Previous_DT_DT_ID_Deprecated", oldValue, this.m_Previous_DT_DT_ID_Deprecated));
        }
    }
    @Override
    public UniqueId getPrevious_DT_DT_ID_Deprecated() throws XtumlException {
        checkLiving();
        return m_Previous_DT_DT_ID_Deprecated;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getConst_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private DataType R1500_is_defined_by_DataType_inst;
    @Override
    public void setR1500_is_defined_by_DataType( DataType inst ) {
        R1500_is_defined_by_DataType_inst = inst;
    }
    @Override
    public DataType R1500_is_defined_by_DataType() throws XtumlException {
        return R1500_is_defined_by_DataType_inst;
    }
    private LeafSymbolicConstant R1502_is_a_LeafSymbolicConstant_inst;
    @Override
    public void setR1502_is_a_LeafSymbolicConstant( LeafSymbolicConstant inst ) {
        R1502_is_a_LeafSymbolicConstant_inst = inst;
    }
    @Override
    public LeafSymbolicConstant R1502_is_a_LeafSymbolicConstant() throws XtumlException {
        return R1502_is_a_LeafSymbolicConstant_inst;
    }
    private ConstantSpecification R1504_is_contained_by_ConstantSpecification_inst;
    @Override
    public void setR1504_is_contained_by_ConstantSpecification( ConstantSpecification inst ) {
        R1504_is_contained_by_ConstantSpecification_inst = inst;
    }
    @Override
    public ConstantSpecification R1504_is_contained_by_ConstantSpecification() throws XtumlException {
        return R1504_is_contained_by_ConstantSpecification_inst;
    }
    private SymbolicConstant R1505_precedes_SymbolicConstant_inst;
    @Override
    public void setR1505_precedes_SymbolicConstant( SymbolicConstant inst ) {
        R1505_precedes_SymbolicConstant_inst = inst;
    }
    @Override
    public SymbolicConstant R1505_precedes_SymbolicConstant() throws XtumlException {
        return R1505_precedes_SymbolicConstant_inst;
    }
    private SymbolicConstant R1505_succeeds_SymbolicConstant_inst;
    @Override
    public void setR1505_succeeds_SymbolicConstant( SymbolicConstant inst ) {
        R1505_succeeds_SymbolicConstant_inst = inst;
    }
    @Override
    public SymbolicConstant R1505_succeeds_SymbolicConstant() throws XtumlException {
        return R1505_succeeds_SymbolicConstant_inst;
    }
    private SymbolicConstantValueSet R850_SymbolicConstantValue_set;
    @Override
    public void addR850_SymbolicConstantValue( SymbolicConstantValue inst ) {
        R850_SymbolicConstantValue_set.add(inst);
    }
    @Override
    public void removeR850_SymbolicConstantValue( SymbolicConstantValue inst ) {
        R850_SymbolicConstantValue_set.remove(inst);
    }
    @Override
    public SymbolicConstantValueSet R850_SymbolicConstantValue() throws XtumlException {
        return R850_SymbolicConstantValue_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public SymbolicConstant self() {
        return this;
    }

    @Override
    public SymbolicConstant oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_SYMBOLICCONSTANT;
    }

}

class EmptySymbolicConstant extends ModelInstance<SymbolicConstant,Sql> implements SymbolicConstant {

    // attributes
    public void setConst_ID( UniqueId m_Const_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getConst_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getDT_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getConstant_Spec_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setConstant_Spec_ID( UniqueId ref_Constant_Spec_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setPrevious_Const_ID( UniqueId ref_Previous_Const_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getPrevious_Const_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPrevious_DT_DT_ID_Deprecated( UniqueId m_Previous_DT_DT_ID_Deprecated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getPrevious_DT_DT_ID_Deprecated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public DataType R1500_is_defined_by_DataType() {
        return DataTypeImpl.EMPTY_DATATYPE;
    }
    @Override
    public LeafSymbolicConstant R1502_is_a_LeafSymbolicConstant() {
        return LeafSymbolicConstantImpl.EMPTY_LEAFSYMBOLICCONSTANT;
    }
    @Override
    public ConstantSpecification R1504_is_contained_by_ConstantSpecification() {
        return ConstantSpecificationImpl.EMPTY_CONSTANTSPECIFICATION;
    }
    @Override
    public SymbolicConstant R1505_precedes_SymbolicConstant() {
        return SymbolicConstantImpl.EMPTY_SYMBOLICCONSTANT;
    }
    @Override
    public SymbolicConstant R1505_succeeds_SymbolicConstant() {
        return SymbolicConstantImpl.EMPTY_SYMBOLICCONSTANT;
    }
    @Override
    public SymbolicConstantValueSet R850_SymbolicConstantValue() {
        return (new SymbolicConstantValueSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return SymbolicConstantImpl.KEY_LETTERS;
    }

    @Override
    public SymbolicConstant self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public SymbolicConstant oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return SymbolicConstantImpl.EMPTY_SYMBOLICCONSTANT;
    }

}
