package io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.RequiredSignalBody;
import io.ciera.tool.sql.ooaofooa.body.impl.RequiredSignalBodyImpl;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.RequiredExecutableProperty;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.RequiredSignal;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.impl.RequiredExecutablePropertyImpl;
import io.ciera.tool.sql.ooaofooa.invocation.SignalInvocation;
import io.ciera.tool.sql.ooaofooa.invocation.SignalInvocationSet;
import io.ciera.tool.sql.ooaofooa.invocation.impl.SignalInvocationSetImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.SignalEvent;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.SignalEventImpl;

import ooaofooa.datatypes.ActionDialect;
import ooaofooa.datatypes.ParseStatus;


public class RequiredSignalImpl extends ModelInstance<RequiredSignal,Sql> implements RequiredSignal {

    public static final String KEY_LETTERS = "SPR_RS";
    public static final RequiredSignal EMPTY_REQUIREDSIGNAL = new EmptyRequiredSignal();

    private Sql context;

    // constructors
    private RequiredSignalImpl( Sql context ) {
        this.context = context;
        ref_Id = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        m_Action_Semantics = "";
        m_Action_Semantics_internal = "";
        m_Suc_Pars = ParseStatus.UNINITIALIZED_ENUM;
        m_Dialect = ActionDialect.UNINITIALIZED_ENUM;
        m_Numb = 0;
        R4502_is_a_RequiredExecutableProperty_inst = RequiredExecutablePropertyImpl.EMPTY_REQUIREDEXECUTABLEPROPERTY;
        R529_SignalEvent_inst = SignalEventImpl.EMPTY_SIGNALEVENT;
        R660_SignalInvocation_set = new SignalInvocationSetImpl();
        R684_RequiredSignalBody_inst = RequiredSignalBodyImpl.EMPTY_REQUIREDSIGNALBODY;
    }

    private RequiredSignalImpl( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Name, String m_Descrip, String m_Action_Semantics, String m_Action_Semantics_internal, ParseStatus m_Suc_Pars, ActionDialect m_Dialect, int m_Numb ) {
        super(instanceId);
        this.context = context;
        this.ref_Id = ref_Id;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        this.m_Action_Semantics = m_Action_Semantics;
        this.m_Action_Semantics_internal = m_Action_Semantics_internal;
        this.m_Suc_Pars = m_Suc_Pars;
        this.m_Dialect = m_Dialect;
        this.m_Numb = m_Numb;
        R4502_is_a_RequiredExecutableProperty_inst = RequiredExecutablePropertyImpl.EMPTY_REQUIREDEXECUTABLEPROPERTY;
        R529_SignalEvent_inst = SignalEventImpl.EMPTY_SIGNALEVENT;
        R660_SignalInvocation_set = new SignalInvocationSetImpl();
        R684_RequiredSignalBody_inst = RequiredSignalBodyImpl.EMPTY_REQUIREDSIGNALBODY;
    }

    public static RequiredSignal create( Sql context ) throws XtumlException {
        RequiredSignal newRequiredSignal = new RequiredSignalImpl( context );
        if ( context.addInstance( newRequiredSignal ) ) {
            newRequiredSignal.getRunContext().addChange(new InstanceCreatedDelta(newRequiredSignal, KEY_LETTERS));
            return newRequiredSignal;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static RequiredSignal create( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Name, String m_Descrip, String m_Action_Semantics, String m_Action_Semantics_internal, ParseStatus m_Suc_Pars, ActionDialect m_Dialect, int m_Numb ) throws XtumlException {
        RequiredSignal newRequiredSignal = new RequiredSignalImpl( context, instanceId, ref_Id, m_Name, m_Descrip, m_Action_Semantics, m_Action_Semantics_internal, m_Suc_Pars, m_Dialect, m_Numb );
        if ( context.addInstance( newRequiredSignal ) ) {
            return newRequiredSignal;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Id;
    @Override
    public void setId(UniqueId ref_Id) throws XtumlException {
        checkLiving();
        if (ref_Id.inequality( this.ref_Id)) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
            if ( !R660_SignalInvocation().isEmpty() ) R660_SignalInvocation().setRequiredSig_Id( ref_Id );
            if ( !R684_RequiredSignalBody().isEmpty() ) R684_RequiredSignalBody().setId( ref_Id );
            if ( !R529_SignalEvent().isEmpty() ) R529_SignalEvent().setRequired_Signal_Id( ref_Id );
        }
    }
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
        return ref_Id;
    }
    private String m_Name;
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    private String m_Descrip;
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    private String m_Action_Semantics;
    @Override
    public void setAction_Semantics(String m_Action_Semantics) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Action_Semantics, this.m_Action_Semantics)) {
            final String oldValue = this.m_Action_Semantics;
            this.m_Action_Semantics = m_Action_Semantics;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Action_Semantics", oldValue, this.m_Action_Semantics));
        }
    }
    @Override
    public String getAction_Semantics() throws XtumlException {
        checkLiving();
        return m_Action_Semantics;
    }
    private String m_Action_Semantics_internal;
    @Override
    public void setAction_Semantics_internal(String m_Action_Semantics_internal) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Action_Semantics_internal, this.m_Action_Semantics_internal)) {
            final String oldValue = this.m_Action_Semantics_internal;
            this.m_Action_Semantics_internal = m_Action_Semantics_internal;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Action_Semantics_internal", oldValue, this.m_Action_Semantics_internal));
        }
    }
    @Override
    public String getAction_Semantics_internal() throws XtumlException {
        checkLiving();
        return m_Action_Semantics_internal;
    }
    private ParseStatus m_Suc_Pars;
    @Override
    public ParseStatus getSuc_Pars() throws XtumlException {
        checkLiving();
        return m_Suc_Pars;
    }
    @Override
    public void setSuc_Pars(ParseStatus m_Suc_Pars) throws XtumlException {
        checkLiving();
        if (m_Suc_Pars.inequality( this.m_Suc_Pars)) {
            final ParseStatus oldValue = this.m_Suc_Pars;
            this.m_Suc_Pars = m_Suc_Pars;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Suc_Pars", oldValue, this.m_Suc_Pars));
        }
    }
    private ActionDialect m_Dialect;
    @Override
    public ActionDialect getDialect() throws XtumlException {
        checkLiving();
        return m_Dialect;
    }
    @Override
    public void setDialect(ActionDialect m_Dialect) throws XtumlException {
        checkLiving();
        if (m_Dialect.inequality( this.m_Dialect)) {
            final ActionDialect oldValue = this.m_Dialect;
            this.m_Dialect = m_Dialect;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Dialect", oldValue, this.m_Dialect));
        }
    }
    private int m_Numb;
    @Override
    public int getNumb() throws XtumlException {
        checkLiving();
        return m_Numb;
    }
    @Override
    public void setNumb(int m_Numb) throws XtumlException {
        checkLiving();
        if (m_Numb != this.m_Numb) {
            final int oldValue = this.m_Numb;
            this.m_Numb = m_Numb;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Numb", oldValue, this.m_Numb));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private RequiredExecutableProperty R4502_is_a_RequiredExecutableProperty_inst;
    @Override
    public void setR4502_is_a_RequiredExecutableProperty( RequiredExecutableProperty inst ) {
        R4502_is_a_RequiredExecutableProperty_inst = inst;
    }
    @Override
    public RequiredExecutableProperty R4502_is_a_RequiredExecutableProperty() throws XtumlException {
        return R4502_is_a_RequiredExecutableProperty_inst;
    }
    private SignalEvent R529_SignalEvent_inst;
    @Override
    public void setR529_SignalEvent( SignalEvent inst ) {
        R529_SignalEvent_inst = inst;
    }
    @Override
    public SignalEvent R529_SignalEvent() throws XtumlException {
        return R529_SignalEvent_inst;
    }
    private SignalInvocationSet R660_SignalInvocation_set;
    @Override
    public void addR660_SignalInvocation( SignalInvocation inst ) {
        R660_SignalInvocation_set.add(inst);
    }
    @Override
    public void removeR660_SignalInvocation( SignalInvocation inst ) {
        R660_SignalInvocation_set.remove(inst);
    }
    @Override
    public SignalInvocationSet R660_SignalInvocation() throws XtumlException {
        return R660_SignalInvocation_set;
    }
    private RequiredSignalBody R684_RequiredSignalBody_inst;
    @Override
    public void setR684_RequiredSignalBody( RequiredSignalBody inst ) {
        R684_RequiredSignalBody_inst = inst;
    }
    @Override
    public RequiredSignalBody R684_RequiredSignalBody() throws XtumlException {
        return R684_RequiredSignalBody_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public RequiredSignal self() {
        return this;
    }

    @Override
    public RequiredSignal oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_REQUIREDSIGNAL;
    }

}

class EmptyRequiredSignal extends ModelInstance<RequiredSignal,Sql> implements RequiredSignal {

    // attributes
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setAction_Semantics( String m_Action_Semantics ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getAction_Semantics() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAction_Semantics_internal( String m_Action_Semantics_internal ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getAction_Semantics_internal() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public ParseStatus getSuc_Pars() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSuc_Pars( ParseStatus m_Suc_Pars ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public ActionDialect getDialect() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDialect( ActionDialect m_Dialect ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getNumb() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setNumb( int m_Numb ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public RequiredExecutableProperty R4502_is_a_RequiredExecutableProperty() {
        return RequiredExecutablePropertyImpl.EMPTY_REQUIREDEXECUTABLEPROPERTY;
    }
    @Override
    public SignalEvent R529_SignalEvent() {
        return SignalEventImpl.EMPTY_SIGNALEVENT;
    }
    @Override
    public SignalInvocationSet R660_SignalInvocation() {
        return (new SignalInvocationSetImpl());
    }
    @Override
    public RequiredSignalBody R684_RequiredSignalBody() {
        return RequiredSignalBodyImpl.EMPTY_REQUIREDSIGNALBODY;
    }


    @Override
    public String getKeyLetters() {
        return RequiredSignalImpl.KEY_LETTERS;
    }

    @Override
    public RequiredSignal self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public RequiredSignal oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return RequiredSignalImpl.EMPTY_REQUIREDSIGNAL;
    }

}
