package io.ciera.tool.sql.ooaofooa.component.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.Provision;
import io.ciera.tool.sql.ooaofooa.component.Requirement;
import io.ciera.tool.sql.ooaofooa.component.Satisfaction;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedProvisionInSatisfaction;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedRequirement;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.impl.ImportedProvisionInSatisfactionImpl;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.impl.ImportedRequirementImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.ProvisionImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.RequirementImpl;
import io.ciera.tool.sql.ooaofooa.instance.RuntimeChannel;
import io.ciera.tool.sql.ooaofooa.instance.RuntimeChannelSet;
import io.ciera.tool.sql.ooaofooa.instance.impl.RuntimeChannelSetImpl;
import io.ciera.tool.sql.ooaofooa.packageableelement.PackageableElement;
import io.ciera.tool.sql.ooaofooa.packageableelement.impl.PackageableElementImpl;
import io.ciera.tool.sql.ooaofooa.persistenceassociations.SatisfactionInComponent;
import io.ciera.tool.sql.ooaofooa.persistenceassociations.impl.SatisfactionInComponentImpl;


public class SatisfactionImpl extends ModelInstance<Satisfaction,Sql> implements Satisfaction {

    public static final String KEY_LETTERS = "C_SF";
    public static final Satisfaction EMPTY_SATISFACTION = new EmptySatisfaction();

    private Sql context;

    // constructors
    private SatisfactionImpl( Sql context ) {
        this.context = context;
        ref_Id = UniqueId.random();
        ref_Requirement_Id = UniqueId.random();
        ref_Provision_Id = UniqueId.random();
        m_Descrip = "";
        m_Label = "";
        R2969_is_implemented_at_runtime_by_RuntimeChannel_set = new RuntimeChannelSetImpl();
        R4002_defines_required_satisfication_Requirement_inst = RequirementImpl.EMPTY_REQUIREMENT;
        R4002_satisfies_Provision_inst = ProvisionImpl.EMPTY_PROVISION;
        R4705_satisfaction_made_with_ImportedProvisionInSatisfaction_inst = ImportedProvisionInSatisfactionImpl.EMPTY_IMPORTEDPROVISIONINSATISFACTION;
        R4706_satisfaction_made_with_ImportedRequirement_inst = ImportedRequirementImpl.EMPTY_IMPORTEDREQUIREMENT;
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
        R9000_SatisfactionInComponent_inst = SatisfactionInComponentImpl.EMPTY_SATISFACTIONINCOMPONENT;
    }

    private SatisfactionImpl( Sql context, UniqueId instanceId, UniqueId ref_Id, UniqueId ref_Requirement_Id, UniqueId ref_Provision_Id, String m_Descrip, String m_Label ) {
        super(instanceId);
        this.context = context;
        this.ref_Id = ref_Id;
        this.ref_Requirement_Id = ref_Requirement_Id;
        this.ref_Provision_Id = ref_Provision_Id;
        this.m_Descrip = m_Descrip;
        this.m_Label = m_Label;
        R2969_is_implemented_at_runtime_by_RuntimeChannel_set = new RuntimeChannelSetImpl();
        R4002_defines_required_satisfication_Requirement_inst = RequirementImpl.EMPTY_REQUIREMENT;
        R4002_satisfies_Provision_inst = ProvisionImpl.EMPTY_PROVISION;
        R4705_satisfaction_made_with_ImportedProvisionInSatisfaction_inst = ImportedProvisionInSatisfactionImpl.EMPTY_IMPORTEDPROVISIONINSATISFACTION;
        R4706_satisfaction_made_with_ImportedRequirement_inst = ImportedRequirementImpl.EMPTY_IMPORTEDREQUIREMENT;
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
        R9000_SatisfactionInComponent_inst = SatisfactionInComponentImpl.EMPTY_SATISFACTIONINCOMPONENT;
    }

    public static Satisfaction create( Sql context ) throws XtumlException {
        Satisfaction newSatisfaction = new SatisfactionImpl( context );
        if ( context.addInstance( newSatisfaction ) ) {
            newSatisfaction.getRunContext().addChange(new InstanceCreatedDelta(newSatisfaction, KEY_LETTERS));
            return newSatisfaction;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Satisfaction create( Sql context, UniqueId instanceId, UniqueId ref_Id, UniqueId ref_Requirement_Id, UniqueId ref_Provision_Id, String m_Descrip, String m_Label ) throws XtumlException {
        Satisfaction newSatisfaction = new SatisfactionImpl( context, instanceId, ref_Id, ref_Requirement_Id, ref_Provision_Id, m_Descrip, m_Label );
        if ( context.addInstance( newSatisfaction ) ) {
            return newSatisfaction;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Id;
    @Override
    public void setId(UniqueId ref_Id) throws XtumlException {
        checkLiving();
        if (ref_Id.inequality( this.ref_Id)) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
            if ( !R2969_is_implemented_at_runtime_by_RuntimeChannel().isEmpty() ) R2969_is_implemented_at_runtime_by_RuntimeChannel().setSatisfaction_Id( ref_Id );
            if ( !R9000_SatisfactionInComponent().isEmpty() ) R9000_SatisfactionInComponent().setSatisfaction_Id( ref_Id );
            if ( !R4706_satisfaction_made_with_ImportedRequirement().isEmpty() ) R4706_satisfaction_made_with_ImportedRequirement().setSatisfaction_Element_Id( ref_Id );
            if ( !R4705_satisfaction_made_with_ImportedProvisionInSatisfaction().isEmpty() ) R4705_satisfaction_made_with_ImportedProvisionInSatisfaction().setSatisfaction_Id( ref_Id );
        }
    }
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
        return ref_Id;
    }
    private UniqueId ref_Requirement_Id;
    @Override
    public void setRequirement_Id(UniqueId ref_Requirement_Id) throws XtumlException {
        checkLiving();
        if (ref_Requirement_Id.inequality( this.ref_Requirement_Id)) {
            final UniqueId oldValue = this.ref_Requirement_Id;
            this.ref_Requirement_Id = ref_Requirement_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Requirement_Id", oldValue, this.ref_Requirement_Id));
        }
    }
    @Override
    public UniqueId getRequirement_Id() throws XtumlException {
        checkLiving();
        return ref_Requirement_Id;
    }
    private UniqueId ref_Provision_Id;
    @Override
    public UniqueId getProvision_Id() throws XtumlException {
        checkLiving();
        return ref_Provision_Id;
    }
    @Override
    public void setProvision_Id(UniqueId ref_Provision_Id) throws XtumlException {
        checkLiving();
        if (ref_Provision_Id.inequality( this.ref_Provision_Id)) {
            final UniqueId oldValue = this.ref_Provision_Id;
            this.ref_Provision_Id = ref_Provision_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Provision_Id", oldValue, this.ref_Provision_Id));
        }
    }
    private String m_Descrip;
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    private String m_Label;
    @Override
    public void setLabel(String m_Label) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Label, this.m_Label)) {
            final String oldValue = this.m_Label;
            this.m_Label = m_Label;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Label", oldValue, this.m_Label));
        }
    }
    @Override
    public String getLabel() throws XtumlException {
        checkLiving();
        return m_Label;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private RuntimeChannelSet R2969_is_implemented_at_runtime_by_RuntimeChannel_set;
    @Override
    public void addR2969_is_implemented_at_runtime_by_RuntimeChannel( RuntimeChannel inst ) {
        R2969_is_implemented_at_runtime_by_RuntimeChannel_set.add(inst);
    }
    @Override
    public void removeR2969_is_implemented_at_runtime_by_RuntimeChannel( RuntimeChannel inst ) {
        R2969_is_implemented_at_runtime_by_RuntimeChannel_set.remove(inst);
    }
    @Override
    public RuntimeChannelSet R2969_is_implemented_at_runtime_by_RuntimeChannel() throws XtumlException {
        return R2969_is_implemented_at_runtime_by_RuntimeChannel_set;
    }
    private Requirement R4002_defines_required_satisfication_Requirement_inst;
    @Override
    public void setR4002_defines_required_satisfication_Requirement( Requirement inst ) {
        R4002_defines_required_satisfication_Requirement_inst = inst;
    }
    @Override
    public Requirement R4002_defines_required_satisfication_Requirement() throws XtumlException {
        return R4002_defines_required_satisfication_Requirement_inst;
    }
    private Provision R4002_satisfies_Provision_inst;
    @Override
    public void setR4002_satisfies_Provision( Provision inst ) {
        R4002_satisfies_Provision_inst = inst;
    }
    @Override
    public Provision R4002_satisfies_Provision() throws XtumlException {
        return R4002_satisfies_Provision_inst;
    }
    private ImportedProvisionInSatisfaction R4705_satisfaction_made_with_ImportedProvisionInSatisfaction_inst;
    @Override
    public void setR4705_satisfaction_made_with_ImportedProvisionInSatisfaction( ImportedProvisionInSatisfaction inst ) {
        R4705_satisfaction_made_with_ImportedProvisionInSatisfaction_inst = inst;
    }
    @Override
    public ImportedProvisionInSatisfaction R4705_satisfaction_made_with_ImportedProvisionInSatisfaction() throws XtumlException {
        return R4705_satisfaction_made_with_ImportedProvisionInSatisfaction_inst;
    }
    private ImportedRequirement R4706_satisfaction_made_with_ImportedRequirement_inst;
    @Override
    public void setR4706_satisfaction_made_with_ImportedRequirement( ImportedRequirement inst ) {
        R4706_satisfaction_made_with_ImportedRequirement_inst = inst;
    }
    @Override
    public ImportedRequirement R4706_satisfaction_made_with_ImportedRequirement() throws XtumlException {
        return R4706_satisfaction_made_with_ImportedRequirement_inst;
    }
    private PackageableElement R8001_is_a_PackageableElement_inst;
    @Override
    public void setR8001_is_a_PackageableElement( PackageableElement inst ) {
        R8001_is_a_PackageableElement_inst = inst;
    }
    @Override
    public PackageableElement R8001_is_a_PackageableElement() throws XtumlException {
        return R8001_is_a_PackageableElement_inst;
    }
    private SatisfactionInComponent R9000_SatisfactionInComponent_inst;
    @Override
    public void setR9000_SatisfactionInComponent( SatisfactionInComponent inst ) {
        R9000_SatisfactionInComponent_inst = inst;
    }
    @Override
    public SatisfactionInComponent R9000_SatisfactionInComponent() throws XtumlException {
        return R9000_SatisfactionInComponent_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Satisfaction self() {
        return this;
    }

    @Override
    public Satisfaction oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_SATISFACTION;
    }

}

class EmptySatisfaction extends ModelInstance<Satisfaction,Sql> implements Satisfaction {

    // attributes
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRequirement_Id( UniqueId ref_Requirement_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getRequirement_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getProvision_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setProvision_Id( UniqueId ref_Provision_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLabel( String m_Label ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLabel() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public RuntimeChannelSet R2969_is_implemented_at_runtime_by_RuntimeChannel() {
        return (new RuntimeChannelSetImpl());
    }
    @Override
    public Requirement R4002_defines_required_satisfication_Requirement() {
        return RequirementImpl.EMPTY_REQUIREMENT;
    }
    @Override
    public Provision R4002_satisfies_Provision() {
        return ProvisionImpl.EMPTY_PROVISION;
    }
    @Override
    public ImportedProvisionInSatisfaction R4705_satisfaction_made_with_ImportedProvisionInSatisfaction() {
        return ImportedProvisionInSatisfactionImpl.EMPTY_IMPORTEDPROVISIONINSATISFACTION;
    }
    @Override
    public ImportedRequirement R4706_satisfaction_made_with_ImportedRequirement() {
        return ImportedRequirementImpl.EMPTY_IMPORTEDREQUIREMENT;
    }
    @Override
    public PackageableElement R8001_is_a_PackageableElement() {
        return PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }
    @Override
    public SatisfactionInComponent R9000_SatisfactionInComponent() {
        return SatisfactionInComponentImpl.EMPTY_SATISFACTIONINCOMPONENT;
    }


    @Override
    public String getKeyLetters() {
        return SatisfactionImpl.KEY_LETTERS;
    }

    @Override
    public Satisfaction self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Satisfaction oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return SatisfactionImpl.EMPTY_SATISFACTION;
    }

}
