package io.ciera.tool.sql.ooaofooa.body.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.Body;
import io.ciera.tool.sql.ooaofooa.body.StateActionBody;
import io.ciera.tool.sql.ooaofooa.body.impl.BodyImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.Action;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.ActionImpl;


public class StateActionBodyImpl extends ModelInstance<StateActionBody,Sql> implements StateActionBody {

    public static final String KEY_LETTERS = "ACT_SAB";
    public static final StateActionBody EMPTY_STATEACTIONBODY = new EmptyStateActionBody();

    private Sql context;

    // constructors
    private StateActionBodyImpl( Sql context ) {
        this.context = context;
        ref_Action_ID = UniqueId.random();
        ref_SM_ID = UniqueId.random();
        ref_Act_ID = UniqueId.random();
        R691_specifies_processing_for_Action_inst = ActionImpl.EMPTY_ACTION;
        R698_is_a_Body_inst = BodyImpl.EMPTY_BODY;
    }

    private StateActionBodyImpl( Sql context, UniqueId instanceId, UniqueId ref_Action_ID, UniqueId ref_SM_ID, UniqueId ref_Act_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Action_ID = ref_Action_ID;
        this.ref_SM_ID = ref_SM_ID;
        this.ref_Act_ID = ref_Act_ID;
        R691_specifies_processing_for_Action_inst = ActionImpl.EMPTY_ACTION;
        R698_is_a_Body_inst = BodyImpl.EMPTY_BODY;
    }

    public static StateActionBody create( Sql context ) throws XtumlException {
        StateActionBody newStateActionBody = new StateActionBodyImpl( context );
        if ( context.addInstance( newStateActionBody ) ) {
            newStateActionBody.getRunContext().addChange(new InstanceCreatedDelta(newStateActionBody, KEY_LETTERS));
            return newStateActionBody;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static StateActionBody create( Sql context, UniqueId instanceId, UniqueId ref_Action_ID, UniqueId ref_SM_ID, UniqueId ref_Act_ID ) throws XtumlException {
        StateActionBody newStateActionBody = new StateActionBodyImpl( context, instanceId, ref_Action_ID, ref_SM_ID, ref_Act_ID );
        if ( context.addInstance( newStateActionBody ) ) {
            return newStateActionBody;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Action_ID;
    @Override
    public UniqueId getAction_ID() throws XtumlException {
        checkLiving();
        return ref_Action_ID;
    }
    @Override
    public void setAction_ID(UniqueId ref_Action_ID) throws XtumlException {
        checkLiving();
        if (ref_Action_ID.inequality( this.ref_Action_ID)) {
            final UniqueId oldValue = this.ref_Action_ID;
            this.ref_Action_ID = ref_Action_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Action_ID", oldValue, this.ref_Action_ID));
        }
    }
    private UniqueId ref_SM_ID;
    @Override
    public void setSM_ID(UniqueId ref_SM_ID) throws XtumlException {
        checkLiving();
        if (ref_SM_ID.inequality( this.ref_SM_ID)) {
            final UniqueId oldValue = this.ref_SM_ID;
            this.ref_SM_ID = ref_SM_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SM_ID", oldValue, this.ref_SM_ID));
        }
    }
    @Override
    public UniqueId getSM_ID() throws XtumlException {
        checkLiving();
        return ref_SM_ID;
    }
    private UniqueId ref_Act_ID;
    @Override
    public UniqueId getAct_ID() throws XtumlException {
        checkLiving();
        return ref_Act_ID;
    }
    @Override
    public void setAct_ID(UniqueId ref_Act_ID) throws XtumlException {
        checkLiving();
        if (ref_Act_ID.inequality( this.ref_Act_ID)) {
            final UniqueId oldValue = this.ref_Act_ID;
            this.ref_Act_ID = ref_Act_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Act_ID", oldValue, this.ref_Act_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getAction_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Action R691_specifies_processing_for_Action_inst;
    @Override
    public void setR691_specifies_processing_for_Action( Action inst ) {
        R691_specifies_processing_for_Action_inst = inst;
    }
    @Override
    public Action R691_specifies_processing_for_Action() throws XtumlException {
        return R691_specifies_processing_for_Action_inst;
    }
    private Body R698_is_a_Body_inst;
    @Override
    public void setR698_is_a_Body( Body inst ) {
        R698_is_a_Body_inst = inst;
    }
    @Override
    public Body R698_is_a_Body() throws XtumlException {
        return R698_is_a_Body_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public StateActionBody self() {
        return this;
    }

    @Override
    public StateActionBody oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_STATEACTIONBODY;
    }

}

class EmptyStateActionBody extends ModelInstance<StateActionBody,Sql> implements StateActionBody {

    // attributes
    public UniqueId getAction_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAction_ID( UniqueId ref_Action_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSM_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getAct_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAct_ID( UniqueId ref_Act_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Action R691_specifies_processing_for_Action() {
        return ActionImpl.EMPTY_ACTION;
    }
    @Override
    public Body R698_is_a_Body() {
        return BodyImpl.EMPTY_BODY;
    }


    @Override
    public String getKeyLetters() {
        return StateActionBodyImpl.KEY_LETTERS;
    }

    @Override
    public StateActionBody self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public StateActionBody oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return StateActionBodyImpl.EMPTY_STATEACTIONBODY;
    }

}
