package io.ciera.tool.sql.ooaofooa.activity.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.activity.ActivityPartition;
import io.ciera.tool.sql.ooaofooa.packageableelement.PackageableElement;
import io.ciera.tool.sql.ooaofooa.packageableelement.impl.PackageableElementImpl;


public class ActivityPartitionImpl extends ModelInstance<ActivityPartition,Sql> implements ActivityPartition {

    public static final String KEY_LETTERS = "A_AP";
    public static final ActivityPartition EMPTY_ACTIVITYPARTITION = new EmptyActivityPartition();

    private Sql context;

    // constructors
    private ActivityPartitionImpl( Sql context ) {
        this.context = context;
        ref_Id = UniqueId.random();
        m_Package_IDdeprecated = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }

    private ActivityPartitionImpl( Sql context, UniqueId instanceId, UniqueId ref_Id, UniqueId m_Package_IDdeprecated, String m_Name, String m_Descrip ) {
        super(instanceId);
        this.context = context;
        this.ref_Id = ref_Id;
        this.m_Package_IDdeprecated = m_Package_IDdeprecated;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }

    public static ActivityPartition create( Sql context ) throws XtumlException {
        ActivityPartition newActivityPartition = new ActivityPartitionImpl( context );
        if ( context.addInstance( newActivityPartition ) ) {
            newActivityPartition.getRunContext().addChange(new InstanceCreatedDelta(newActivityPartition, KEY_LETTERS));
            return newActivityPartition;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ActivityPartition create( Sql context, UniqueId instanceId, UniqueId ref_Id, UniqueId m_Package_IDdeprecated, String m_Name, String m_Descrip ) throws XtumlException {
        ActivityPartition newActivityPartition = new ActivityPartitionImpl( context, instanceId, ref_Id, m_Package_IDdeprecated, m_Name, m_Descrip );
        if ( context.addInstance( newActivityPartition ) ) {
            return newActivityPartition;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Id;
    @Override
    public void setId(UniqueId ref_Id) throws XtumlException {
        checkLiving();
        if (ref_Id.inequality( this.ref_Id)) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
        }
    }
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
        return ref_Id;
    }
    private UniqueId m_Package_IDdeprecated;
    @Override
    public UniqueId getPackage_IDdeprecated() throws XtumlException {
        checkLiving();
        return m_Package_IDdeprecated;
    }
    @Override
    public void setPackage_IDdeprecated(UniqueId m_Package_IDdeprecated) throws XtumlException {
        checkLiving();
        if (m_Package_IDdeprecated.inequality( this.m_Package_IDdeprecated)) {
            final UniqueId oldValue = this.m_Package_IDdeprecated;
            this.m_Package_IDdeprecated = m_Package_IDdeprecated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Package_IDdeprecated", oldValue, this.m_Package_IDdeprecated));
        }
    }
    private String m_Name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    private String m_Descrip;
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private PackageableElement R8001_is_a_PackageableElement_inst;
    @Override
    public void setR8001_is_a_PackageableElement( PackageableElement inst ) {
        R8001_is_a_PackageableElement_inst = inst;
    }
    @Override
    public PackageableElement R8001_is_a_PackageableElement() throws XtumlException {
        return R8001_is_a_PackageableElement_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ActivityPartition self() {
        return this;
    }

    @Override
    public ActivityPartition oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_ACTIVITYPARTITION;
    }

}

class EmptyActivityPartition extends ModelInstance<ActivityPartition,Sql> implements ActivityPartition {

    // attributes
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getPackage_IDdeprecated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPackage_IDdeprecated( UniqueId m_Package_IDdeprecated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public PackageableElement R8001_is_a_PackageableElement() {
        return PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }


    @Override
    public String getKeyLetters() {
        return ActivityPartitionImpl.KEY_LETTERS;
    }

    @Override
    public ActivityPartition self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ActivityPartition oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ActivityPartitionImpl.EMPTY_ACTIVITYPARTITION;
    }

}
