package io.ciera.tool.sql.ooaofooa.activity.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.activity.ActivityEdge;
import io.ciera.tool.sql.ooaofooa.activity.ActivityNode;
import io.ciera.tool.sql.ooaofooa.activity.impl.ActivityNodeImpl;
import io.ciera.tool.sql.ooaofooa.packageableelement.PackageableElement;
import io.ciera.tool.sql.ooaofooa.packageableelement.impl.PackageableElementImpl;


public class ActivityEdgeImpl extends ModelInstance<ActivityEdge,Sql> implements ActivityEdge {

    public static final String KEY_LETTERS = "A_E";
    public static final ActivityEdge EMPTY_ACTIVITYEDGE = new EmptyActivityEdge();

    private Sql context;

    // constructors
    private ActivityEdgeImpl( Sql context ) {
        this.context = context;
        ref_Id = UniqueId.random();
        m_Package_IDdeprecated = UniqueId.random();
        m_Guard = "";
        m_Descrip = "";
        ref_TargetId = UniqueId.random();
        ref_SourceId = UniqueId.random();
        R1103_target_ActivityNode_inst = ActivityNodeImpl.EMPTY_ACTIVITYNODE;
        R1104_source_ActivityNode_inst = ActivityNodeImpl.EMPTY_ACTIVITYNODE;
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }

    private ActivityEdgeImpl( Sql context, UniqueId instanceId, UniqueId ref_Id, UniqueId m_Package_IDdeprecated, String m_Guard, String m_Descrip, UniqueId ref_TargetId, UniqueId ref_SourceId ) {
        super(instanceId);
        this.context = context;
        this.ref_Id = ref_Id;
        this.m_Package_IDdeprecated = m_Package_IDdeprecated;
        this.m_Guard = m_Guard;
        this.m_Descrip = m_Descrip;
        this.ref_TargetId = ref_TargetId;
        this.ref_SourceId = ref_SourceId;
        R1103_target_ActivityNode_inst = ActivityNodeImpl.EMPTY_ACTIVITYNODE;
        R1104_source_ActivityNode_inst = ActivityNodeImpl.EMPTY_ACTIVITYNODE;
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }

    public static ActivityEdge create( Sql context ) throws XtumlException {
        ActivityEdge newActivityEdge = new ActivityEdgeImpl( context );
        if ( context.addInstance( newActivityEdge ) ) {
            newActivityEdge.getRunContext().addChange(new InstanceCreatedDelta(newActivityEdge, KEY_LETTERS));
            return newActivityEdge;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ActivityEdge create( Sql context, UniqueId instanceId, UniqueId ref_Id, UniqueId m_Package_IDdeprecated, String m_Guard, String m_Descrip, UniqueId ref_TargetId, UniqueId ref_SourceId ) throws XtumlException {
        ActivityEdge newActivityEdge = new ActivityEdgeImpl( context, instanceId, ref_Id, m_Package_IDdeprecated, m_Guard, m_Descrip, ref_TargetId, ref_SourceId );
        if ( context.addInstance( newActivityEdge ) ) {
            return newActivityEdge;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Id;
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
        return ref_Id;
    }
    @Override
    public void setId(UniqueId ref_Id) throws XtumlException {
        checkLiving();
        if (ref_Id.inequality( this.ref_Id)) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
        }
    }
    private UniqueId m_Package_IDdeprecated;
    @Override
    public void setPackage_IDdeprecated(UniqueId m_Package_IDdeprecated) throws XtumlException {
        checkLiving();
        if (m_Package_IDdeprecated.inequality( this.m_Package_IDdeprecated)) {
            final UniqueId oldValue = this.m_Package_IDdeprecated;
            this.m_Package_IDdeprecated = m_Package_IDdeprecated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Package_IDdeprecated", oldValue, this.m_Package_IDdeprecated));
        }
    }
    @Override
    public UniqueId getPackage_IDdeprecated() throws XtumlException {
        checkLiving();
        return m_Package_IDdeprecated;
    }
    private String m_Guard;
    @Override
    public void setGuard(String m_Guard) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Guard, this.m_Guard)) {
            final String oldValue = this.m_Guard;
            this.m_Guard = m_Guard;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Guard", oldValue, this.m_Guard));
        }
    }
    @Override
    public String getGuard() throws XtumlException {
        checkLiving();
        return m_Guard;
    }
    private String m_Descrip;
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    private UniqueId ref_TargetId;
    @Override
    public void setTargetId(UniqueId ref_TargetId) throws XtumlException {
        checkLiving();
        if (ref_TargetId.inequality( this.ref_TargetId)) {
            final UniqueId oldValue = this.ref_TargetId;
            this.ref_TargetId = ref_TargetId;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_TargetId", oldValue, this.ref_TargetId));
        }
    }
    @Override
    public UniqueId getTargetId() throws XtumlException {
        checkLiving();
        return ref_TargetId;
    }
    private UniqueId ref_SourceId;
    @Override
    public UniqueId getSourceId() throws XtumlException {
        checkLiving();
        return ref_SourceId;
    }
    @Override
    public void setSourceId(UniqueId ref_SourceId) throws XtumlException {
        checkLiving();
        if (ref_SourceId.inequality( this.ref_SourceId)) {
            final UniqueId oldValue = this.ref_SourceId;
            this.ref_SourceId = ref_SourceId;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SourceId", oldValue, this.ref_SourceId));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ActivityNode R1103_target_ActivityNode_inst;
    @Override
    public void setR1103_target_ActivityNode( ActivityNode inst ) {
        R1103_target_ActivityNode_inst = inst;
    }
    @Override
    public ActivityNode R1103_target_ActivityNode() throws XtumlException {
        return R1103_target_ActivityNode_inst;
    }
    private ActivityNode R1104_source_ActivityNode_inst;
    @Override
    public void setR1104_source_ActivityNode( ActivityNode inst ) {
        R1104_source_ActivityNode_inst = inst;
    }
    @Override
    public ActivityNode R1104_source_ActivityNode() throws XtumlException {
        return R1104_source_ActivityNode_inst;
    }
    private PackageableElement R8001_is_a_PackageableElement_inst;
    @Override
    public void setR8001_is_a_PackageableElement( PackageableElement inst ) {
        R8001_is_a_PackageableElement_inst = inst;
    }
    @Override
    public PackageableElement R8001_is_a_PackageableElement() throws XtumlException {
        return R8001_is_a_PackageableElement_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ActivityEdge self() {
        return this;
    }

    @Override
    public ActivityEdge oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_ACTIVITYEDGE;
    }

}

class EmptyActivityEdge extends ModelInstance<ActivityEdge,Sql> implements ActivityEdge {

    // attributes
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setPackage_IDdeprecated( UniqueId m_Package_IDdeprecated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getPackage_IDdeprecated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setGuard( String m_Guard ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getGuard() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setTargetId( UniqueId ref_TargetId ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getTargetId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getSourceId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSourceId( UniqueId ref_SourceId ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ActivityNode R1103_target_ActivityNode() {
        return ActivityNodeImpl.EMPTY_ACTIVITYNODE;
    }
    @Override
    public ActivityNode R1104_source_ActivityNode() {
        return ActivityNodeImpl.EMPTY_ACTIVITYNODE;
    }
    @Override
    public PackageableElement R8001_is_a_PackageableElement() {
        return PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }


    @Override
    public String getKeyLetters() {
        return ActivityEdgeImpl.KEY_LETTERS;
    }

    @Override
    public ActivityEdge self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ActivityEdge oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ActivityEdgeImpl.EMPTY_ACTIVITYEDGE;
    }

}
