package io.ciera.tool.sql.ooaofooa.activity.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.activity.AcceptEvent;
import io.ciera.tool.sql.ooaofooa.activity.AcceptEventAction;
import io.ciera.tool.sql.ooaofooa.activity.impl.AcceptEventImpl;


public class AcceptEventActionImpl extends ModelInstance<AcceptEventAction,Sql> implements AcceptEventAction {

    public static final String KEY_LETTERS = "A_AEA";
    public static final AcceptEventAction EMPTY_ACCEPTEVENTACTION = new EmptyAcceptEventAction();

    private Sql context;

    // constructors
    private AcceptEventActionImpl( Sql context ) {
        this.context = context;
        ref_Id = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        R1112_is_a_AcceptEvent_inst = AcceptEventImpl.EMPTY_ACCEPTEVENT;
    }

    private AcceptEventActionImpl( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Name, String m_Descrip ) {
        super(instanceId);
        this.context = context;
        this.ref_Id = ref_Id;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        R1112_is_a_AcceptEvent_inst = AcceptEventImpl.EMPTY_ACCEPTEVENT;
    }

    public static AcceptEventAction create( Sql context ) throws XtumlException {
        AcceptEventAction newAcceptEventAction = new AcceptEventActionImpl( context );
        if ( context.addInstance( newAcceptEventAction ) ) {
            newAcceptEventAction.getRunContext().addChange(new InstanceCreatedDelta(newAcceptEventAction, KEY_LETTERS));
            return newAcceptEventAction;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static AcceptEventAction create( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Name, String m_Descrip ) throws XtumlException {
        AcceptEventAction newAcceptEventAction = new AcceptEventActionImpl( context, instanceId, ref_Id, m_Name, m_Descrip );
        if ( context.addInstance( newAcceptEventAction ) ) {
            return newAcceptEventAction;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Id;
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
        return ref_Id;
    }
    @Override
    public void setId(UniqueId ref_Id) throws XtumlException {
        checkLiving();
        if (ref_Id.inequality( this.ref_Id)) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
        }
    }
    private String m_Name;
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    private String m_Descrip;
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private AcceptEvent R1112_is_a_AcceptEvent_inst;
    @Override
    public void setR1112_is_a_AcceptEvent( AcceptEvent inst ) {
        R1112_is_a_AcceptEvent_inst = inst;
    }
    @Override
    public AcceptEvent R1112_is_a_AcceptEvent() throws XtumlException {
        return R1112_is_a_AcceptEvent_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public AcceptEventAction self() {
        return this;
    }

    @Override
    public AcceptEventAction oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_ACCEPTEVENTACTION;
    }

}

class EmptyAcceptEventAction extends ModelInstance<AcceptEventAction,Sql> implements AcceptEventAction {

    // attributes
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public AcceptEvent R1112_is_a_AcceptEvent() {
        return AcceptEventImpl.EMPTY_ACCEPTEVENT;
    }


    @Override
    public String getKeyLetters() {
        return AcceptEventActionImpl.KEY_LETTERS;
    }

    @Override
    public AcceptEventAction self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public AcceptEventAction oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return AcceptEventActionImpl.EMPTY_ACCEPTEVENTACTION;
    }

}
