package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.loader.AttributeSerializerSet;
import io.ciera.tool.sql.loader.IntegerSerializer;
import io.ciera.tool.sql.loader.IntegerSerializerSet;
import io.ciera.tool.sql.loader.impl.AttributeSerializerSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class IntegerSerializerSetImpl extends InstanceSet<IntegerSerializerSet,IntegerSerializer> implements IntegerSerializerSet {

    public IntegerSerializerSetImpl() {
    }

    public IntegerSerializerSetImpl(Comparator<? super IntegerSerializer> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setValue( String m_value ) throws XtumlException {
        for ( IntegerSerializer integerserializer : this ) integerserializer.setValue( m_value );
    }
    @Override
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        for ( IntegerSerializer integerserializer : this ) integerserializer.setLoader_name( ref_loader_name );
    }
    @Override
    public void setValue2( String m_value2 ) throws XtumlException {
        for ( IntegerSerializer integerserializer : this ) integerserializer.setValue2( m_value2 );
    }
    @Override
    public void setClass_name( String ref_class_name ) throws XtumlException {
        for ( IntegerSerializer integerserializer : this ) integerserializer.setClass_name( ref_class_name );
    }
    @Override
    public void setAttr_name( String ref_attr_name ) throws XtumlException {
        for ( IntegerSerializer integerserializer : this ) integerserializer.setAttr_name( ref_attr_name );
    }
    @Override
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        for ( IntegerSerializer integerserializer : this ) integerserializer.setLoader_package( ref_loader_package );
    }


    // selections
    @Override
    public AttributeSerializerSet R3004_is_a_AttributeSerializer() throws XtumlException {
        AttributeSerializerSet attributeserializerset = new AttributeSerializerSetImpl();
        for ( IntegerSerializer integerserializer : this ) attributeserializerset.add( integerserializer.R3004_is_a_AttributeSerializer() );
        return attributeserializerset;
    }


    @Override
    public IntegerSerializer nullElement() {
        return IntegerSerializerImpl.EMPTY_INTEGERSERIALIZER;
    }

    @Override
    public IntegerSerializerSet emptySet() {
      return new IntegerSerializerSetImpl();
    }

    @Override
    public IntegerSerializerSet emptySet(Comparator<? super IntegerSerializer> comp) {
      return new IntegerSerializerSetImpl(comp);
    }

    @Override
    public List<IntegerSerializer> elements() {
        return Arrays.asList(toArray(new IntegerSerializer[0]));
    }

}
