package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.loader.AttributeLoader;
import io.ciera.tool.sql.loader.BooleanLoader;
import io.ciera.tool.sql.loader.impl.AttributeLoaderImpl;


public class BooleanLoaderImpl extends ModelInstance<BooleanLoader,Sql> implements BooleanLoader {

    public static final String KEY_LETTERS = "Z_BooleanLoader";
    public static final BooleanLoader EMPTY_BOOLEANLOADER = new EmptyBooleanLoader();

    private Sql context;

    // constructors
    private BooleanLoaderImpl( Sql context ) {
        this.context = context;
        ref_loader_name = "";
        ref_loader_package = "";
        ref_class_name = "";
        ref_index = 0;
        ref_attr_name = "";
        R3008_is_a_AttributeLoader_inst = AttributeLoaderImpl.EMPTY_ATTRIBUTELOADER;
    }

    private BooleanLoaderImpl( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, String ref_class_name, int ref_index, String ref_attr_name ) {
        super(instanceId);
        this.context = context;
        this.ref_loader_name = ref_loader_name;
        this.ref_loader_package = ref_loader_package;
        this.ref_class_name = ref_class_name;
        this.ref_index = ref_index;
        this.ref_attr_name = ref_attr_name;
        R3008_is_a_AttributeLoader_inst = AttributeLoaderImpl.EMPTY_ATTRIBUTELOADER;
    }

    public static BooleanLoader create( Sql context ) throws XtumlException {
        BooleanLoader newBooleanLoader = new BooleanLoaderImpl( context );
        if ( context.addInstance( newBooleanLoader ) ) {
            newBooleanLoader.getRunContext().addChange(new InstanceCreatedDelta(newBooleanLoader, KEY_LETTERS));
            return newBooleanLoader;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static BooleanLoader create( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, String ref_class_name, int ref_index, String ref_attr_name ) throws XtumlException {
        BooleanLoader newBooleanLoader = new BooleanLoaderImpl( context, instanceId, ref_loader_name, ref_loader_package, ref_class_name, ref_index, ref_attr_name );
        if ( context.addInstance( newBooleanLoader ) ) {
            return newBooleanLoader;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_loader_name;
    @Override
    public void setLoader_name(String ref_loader_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_loader_name, this.ref_loader_name)) {
            final String oldValue = this.ref_loader_name;
            this.ref_loader_name = ref_loader_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_name", oldValue, this.ref_loader_name));
        }
    }
    @Override
    public String getLoader_name() throws XtumlException {
        checkLiving();
        return ref_loader_name;
    }
    private String ref_loader_package;
    @Override
    public String getLoader_package() throws XtumlException {
        checkLiving();
        return ref_loader_package;
    }
    @Override
    public void setLoader_package(String ref_loader_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_loader_package, this.ref_loader_package)) {
            final String oldValue = this.ref_loader_package;
            this.ref_loader_package = ref_loader_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_package", oldValue, this.ref_loader_package));
        }
    }
    private String ref_class_name;
    @Override
    public void setClass_name(String ref_class_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_class_name, this.ref_class_name)) {
            final String oldValue = this.ref_class_name;
            this.ref_class_name = ref_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_class_name", oldValue, this.ref_class_name));
        }
    }
    @Override
    public String getClass_name() throws XtumlException {
        checkLiving();
        return ref_class_name;
    }
    private int ref_index;
    @Override
    public void setIndex(int ref_index) throws XtumlException {
        checkLiving();
        if (ref_index != this.ref_index) {
            final int oldValue = this.ref_index;
            this.ref_index = ref_index;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_index", oldValue, this.ref_index));
        }
    }
    @Override
    public int getIndex() throws XtumlException {
        checkLiving();
        return ref_index;
    }
    private String ref_attr_name;
    @Override
    public String getAttr_name() throws XtumlException {
        checkLiving();
        return ref_attr_name;
    }
    @Override
    public void setAttr_name(String ref_attr_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_attr_name, this.ref_attr_name)) {
            final String oldValue = this.ref_attr_name;
            this.ref_attr_name = ref_attr_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_attr_name", oldValue, this.ref_attr_name));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getLoader_name(), getLoader_package(), getClass_name(), getIndex(), getAttr_name());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        AttributeLoader attr_loader = self().R3008_is_a_AttributeLoader();
        int value_index = attr_loader.getValue_index();
        context().T().include( "loader/t.booleanloader.java", value_index );
    }



    // static operations


    // events


    // selections
    private AttributeLoader R3008_is_a_AttributeLoader_inst;
    @Override
    public void setR3008_is_a_AttributeLoader( AttributeLoader inst ) {
        R3008_is_a_AttributeLoader_inst = inst;
    }
    @Override
    public AttributeLoader R3008_is_a_AttributeLoader() throws XtumlException {
        return R3008_is_a_AttributeLoader_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public BooleanLoader self() {
        return this;
    }

    @Override
    public BooleanLoader oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_BOOLEANLOADER;
    }

}

class EmptyBooleanLoader extends ModelInstance<BooleanLoader,Sql> implements BooleanLoader {

    // attributes
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLoader_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getLoader_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setClass_name( String ref_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getClass_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIndex( int ref_index ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getIndex() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getAttr_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAttr_name( String ref_attr_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public AttributeLoader R3008_is_a_AttributeLoader() {
        return AttributeLoaderImpl.EMPTY_ATTRIBUTELOADER;
    }


    @Override
    public String getKeyLetters() {
        return BooleanLoaderImpl.KEY_LETTERS;
    }

    @Override
    public BooleanLoader self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public BooleanLoader oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return BooleanLoaderImpl.EMPTY_BOOLEANLOADER;
    }

}
