package io.ciera.tool.sql.associationserializerloader.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.ActionHome;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.associationserializerloader.AssociationSerializerLoader;
import io.ciera.tool.sql.associationserializerloader.ReferredToClassProxy;
import io.ciera.tool.sql.associationserializerloader.SingleReferrerAssoc;
import io.ciera.tool.sql.associationserializerloader.impl.AssociationSerializerLoaderImpl;
import io.ciera.tool.sql.associationserializerloader.impl.ReferredToClassProxyImpl;
import io.ciera.tool.sql.associationserializerloader.impl.SingleReferrerAssocImpl;
import io.ciera.tool.sql.loader.PopulationLoader;
import io.ciera.tool.sql.loader.impl.UniqueIDSerializerImpl;


public class SingleReferrerAssocImpl extends ModelInstance<SingleReferrerAssoc,Sql> implements SingleReferrerAssoc {

    public static final String KEY_LETTERS = "SingleReferrerAssoc";
    public static final SingleReferrerAssoc EMPTY_SINGLEREFERRERASSOC = new EmptySingleReferrerAssoc();

    private Sql context;

    // constructors
    private SingleReferrerAssocImpl( Sql context ) {
        this.context = context;
        ref_rel_num = 0;
        m_referring_class_name = "";
        R3029_is_a_AssociationSerializerLoader_inst = AssociationSerializerLoaderImpl.EMPTY_ASSOCIATIONSERIALIZERLOADER;
        R3030_renders_code_for_2nd_ID_position_using_ReferredToClassProxy_inst = ReferredToClassProxyImpl.EMPTY_REFERREDTOCLASSPROXY;
        R3035_renders_code_for_3rd_ID_position_using_ReferredToClassProxy_inst = ReferredToClassProxyImpl.EMPTY_REFERREDTOCLASSPROXY;
    }

    private SingleReferrerAssocImpl( Sql context, UniqueId instanceId, int ref_rel_num, String m_referring_class_name ) {
        super(instanceId);
        this.context = context;
        this.ref_rel_num = ref_rel_num;
        this.m_referring_class_name = m_referring_class_name;
        R3029_is_a_AssociationSerializerLoader_inst = AssociationSerializerLoaderImpl.EMPTY_ASSOCIATIONSERIALIZERLOADER;
        R3030_renders_code_for_2nd_ID_position_using_ReferredToClassProxy_inst = ReferredToClassProxyImpl.EMPTY_REFERREDTOCLASSPROXY;
        R3035_renders_code_for_3rd_ID_position_using_ReferredToClassProxy_inst = ReferredToClassProxyImpl.EMPTY_REFERREDTOCLASSPROXY;
    }

    public static SingleReferrerAssoc create( Sql context ) throws XtumlException {
        SingleReferrerAssoc newSingleReferrerAssoc = new SingleReferrerAssocImpl( context );
        if ( context.addInstance( newSingleReferrerAssoc ) ) {
            newSingleReferrerAssoc.getRunContext().addChange(new InstanceCreatedDelta(newSingleReferrerAssoc, KEY_LETTERS));
            return newSingleReferrerAssoc;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static SingleReferrerAssoc create( Sql context, UniqueId instanceId, int ref_rel_num, String m_referring_class_name ) throws XtumlException {
        SingleReferrerAssoc newSingleReferrerAssoc = new SingleReferrerAssocImpl( context, instanceId, ref_rel_num, m_referring_class_name );
        if ( context.addInstance( newSingleReferrerAssoc ) ) {
            return newSingleReferrerAssoc;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private int ref_rel_num;
    @Override
    public void setRel_num(int ref_rel_num) throws XtumlException {
        checkLiving();
        if (ref_rel_num != this.ref_rel_num) {
            final int oldValue = this.ref_rel_num;
            this.ref_rel_num = ref_rel_num;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_rel_num", oldValue, this.ref_rel_num));
            if ( !R3030_renders_code_for_2nd_ID_position_using_ReferredToClassProxy().isEmpty() ) R3030_renders_code_for_2nd_ID_position_using_ReferredToClassProxy().setRel_num( ref_rel_num );
            if ( !R3035_renders_code_for_3rd_ID_position_using_ReferredToClassProxy().isEmpty() ) R3035_renders_code_for_3rd_ID_position_using_ReferredToClassProxy().setRel_num( ref_rel_num );
        }
    }
    @Override
    public int getRel_num() throws XtumlException {
        checkLiving();
        return ref_rel_num;
    }
    private String m_referring_class_name;
    @Override
    public void setReferring_class_name(String m_referring_class_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_referring_class_name, this.m_referring_class_name)) {
            final String oldValue = this.m_referring_class_name;
            this.m_referring_class_name = m_referring_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_referring_class_name", oldValue, this.m_referring_class_name));
        }
    }
    @Override
    public String getReferring_class_name() throws XtumlException {
        checkLiving();
        return m_referring_class_name;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getRel_num());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render_relate() throws XtumlException {
        ReferredToClassProxy ref2 = self().R3030_renders_code_for_2nd_ID_position_using_ReferredToClassProxy();
        context().T().push_buffer();
        ref2.render_relate( 1, true );
        ReferredToClassProxy ref3 = self().R3035_renders_code_for_3rd_ID_position_using_ReferredToClassProxy();
        if ( !ref3.isEmpty() ) {
            boolean declare = true;
            if ( StringUtil.equality(ref3.getReferred_to_class_name(), ref2.getReferred_to_class_name()) ) {
                declare = false;
            }
            ref3.render_relate( 2, declare );
        }
        String relates = context().T().body();
        context().T().pop_buffer();
        String rnum_str = context().STRING().itoa( self().getRel_num() );
        context().T().include( "loader/t.linkloader.relate.java", relates, rnum_str );
    }

    @Override
    public void render_serialize() throws XtumlException {
        String link_statement = "LINK2 ";
        ReferredToClassProxy ref2 = self().R3030_renders_code_for_2nd_ID_position_using_ReferredToClassProxy();
        ReferredToClassProxy ref3 = self().R3035_renders_code_for_3rd_ID_position_using_ReferredToClassProxy();
        if ( !ref3.isEmpty() ) {
            link_statement = "LINK3 ";
        }
        AssociationSerializerLoader serializer = self().R3029_is_a_AssociationSerializerLoader();
        String rnum_str = context().STRING().itoa( self().getRel_num() );
        context().T().push_buffer();
        ref2.render_init( link_statement );
        String init = context().T().body();
        context().T().pop_buffer();
        context().T().push_buffer();
        new UniqueIDSerializerImpl.CLASS(context()).do_render( self().getReferring_class_name(), "getInstanceId()" );
        String self_serialize = context().T().body();
        context().T().pop_buffer();
        context().T().push_buffer();
        ref2.render_serialization();
        if ( !ref3.isEmpty() ) {
            ref3.render_serialization();
        }
        String referred_ids = context().T().body();
        context().T().pop_buffer();
        String class_name = self().getReferring_class_name();
        context().T().include( "loader/t.linkserializer.method.java", class_name, init, referred_ids, rnum_str, self_serialize );
    }



    // static operations
    public static class CLASS extends ActionHome<Sql> {

        public CLASS( Sql context ) {
            super( context );
        }

        public SingleReferrerAssoc create( final int p_rel_num,  final String p_ref_class,  final PopulationLoader p_addto ) throws XtumlException {
            AssociationSerializerLoader serializer = new AssociationSerializerLoaderImpl.CLASS(context()).create( p_rel_num, p_addto );
            SingleReferrerAssoc ref = SingleReferrerAssocImpl.create( context() );
            context().relate_R3029_SingleReferrerAssoc_is_a_AssociationSerializerLoader( ref, serializer );
            ref.setReferring_class_name(p_ref_class);
            return ref;
        }



    }


    // events


    // selections
    private AssociationSerializerLoader R3029_is_a_AssociationSerializerLoader_inst;
    @Override
    public void setR3029_is_a_AssociationSerializerLoader( AssociationSerializerLoader inst ) {
        R3029_is_a_AssociationSerializerLoader_inst = inst;
    }
    @Override
    public AssociationSerializerLoader R3029_is_a_AssociationSerializerLoader() throws XtumlException {
        return R3029_is_a_AssociationSerializerLoader_inst;
    }
    private ReferredToClassProxy R3030_renders_code_for_2nd_ID_position_using_ReferredToClassProxy_inst;
    @Override
    public void setR3030_renders_code_for_2nd_ID_position_using_ReferredToClassProxy( ReferredToClassProxy inst ) {
        R3030_renders_code_for_2nd_ID_position_using_ReferredToClassProxy_inst = inst;
    }
    @Override
    public ReferredToClassProxy R3030_renders_code_for_2nd_ID_position_using_ReferredToClassProxy() throws XtumlException {
        return R3030_renders_code_for_2nd_ID_position_using_ReferredToClassProxy_inst;
    }
    private ReferredToClassProxy R3035_renders_code_for_3rd_ID_position_using_ReferredToClassProxy_inst;
    @Override
    public void setR3035_renders_code_for_3rd_ID_position_using_ReferredToClassProxy( ReferredToClassProxy inst ) {
        R3035_renders_code_for_3rd_ID_position_using_ReferredToClassProxy_inst = inst;
    }
    @Override
    public ReferredToClassProxy R3035_renders_code_for_3rd_ID_position_using_ReferredToClassProxy() throws XtumlException {
        return R3035_renders_code_for_3rd_ID_position_using_ReferredToClassProxy_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public SingleReferrerAssoc self() {
        return this;
    }

    @Override
    public SingleReferrerAssoc oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_SINGLEREFERRERASSOC;
    }

}

class EmptySingleReferrerAssoc extends ModelInstance<SingleReferrerAssoc,Sql> implements SingleReferrerAssoc {

    // attributes
    public void setRel_num( int ref_rel_num ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getRel_num() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setReferring_class_name( String m_referring_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getReferring_class_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render_relate() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_serialize() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public AssociationSerializerLoader R3029_is_a_AssociationSerializerLoader() {
        return AssociationSerializerLoaderImpl.EMPTY_ASSOCIATIONSERIALIZERLOADER;
    }
    @Override
    public ReferredToClassProxy R3030_renders_code_for_2nd_ID_position_using_ReferredToClassProxy() {
        return ReferredToClassProxyImpl.EMPTY_REFERREDTOCLASSPROXY;
    }
    @Override
    public ReferredToClassProxy R3035_renders_code_for_3rd_ID_position_using_ReferredToClassProxy() {
        return ReferredToClassProxyImpl.EMPTY_REFERREDTOCLASSPROXY;
    }


    @Override
    public String getKeyLetters() {
        return SingleReferrerAssocImpl.KEY_LETTERS;
    }

    @Override
    public SingleReferrerAssoc self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public SingleReferrerAssoc oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return SingleReferrerAssocImpl.EMPTY_SINGLEREFERRERASSOC;
    }

}
