package io.ciera.tool.sql.associationserializerloader.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.associationserializerloader.AssociationSerializerLoader;
import io.ciera.tool.sql.associationserializerloader.MultipleReferrerAssoc;
import io.ciera.tool.sql.associationserializerloader.ReferringClassProxy;
import io.ciera.tool.sql.associationserializerloader.ReferringClassProxySet;
import io.ciera.tool.sql.associationserializerloader.impl.AssociationSerializerLoaderImpl;
import io.ciera.tool.sql.associationserializerloader.impl.ReferringClassProxySetImpl;
import io.ciera.tool.sql.loader.impl.UniqueIDSerializerImpl;

import java.util.Iterator;


public class MultipleReferrerAssocImpl extends ModelInstance<MultipleReferrerAssoc,Sql> implements MultipleReferrerAssoc {

    public static final String KEY_LETTERS = "MultipleReferrerAssoc";
    public static final MultipleReferrerAssoc EMPTY_MULTIPLEREFERRERASSOC = new EmptyMultipleReferrerAssoc();

    private Sql context;

    // constructors
    private MultipleReferrerAssocImpl( Sql context ) {
        this.context = context;
        ref_rel_num = 0;
        m_referred_to_class_name = "";
        R3029_is_a_AssociationSerializerLoader_inst = AssociationSerializerLoaderImpl.EMPTY_ASSOCIATIONSERIALIZERLOADER;
        R3036_holds_referring_data_for_ReferringClassProxy_set = new ReferringClassProxySetImpl();
    }

    private MultipleReferrerAssocImpl( Sql context, UniqueId instanceId, int ref_rel_num, String m_referred_to_class_name ) {
        super(instanceId);
        this.context = context;
        this.ref_rel_num = ref_rel_num;
        this.m_referred_to_class_name = m_referred_to_class_name;
        R3029_is_a_AssociationSerializerLoader_inst = AssociationSerializerLoaderImpl.EMPTY_ASSOCIATIONSERIALIZERLOADER;
        R3036_holds_referring_data_for_ReferringClassProxy_set = new ReferringClassProxySetImpl();
    }

    public static MultipleReferrerAssoc create( Sql context ) throws XtumlException {
        MultipleReferrerAssoc newMultipleReferrerAssoc = new MultipleReferrerAssocImpl( context );
        if ( context.addInstance( newMultipleReferrerAssoc ) ) {
            newMultipleReferrerAssoc.getRunContext().addChange(new InstanceCreatedDelta(newMultipleReferrerAssoc, KEY_LETTERS));
            return newMultipleReferrerAssoc;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static MultipleReferrerAssoc create( Sql context, UniqueId instanceId, int ref_rel_num, String m_referred_to_class_name ) throws XtumlException {
        MultipleReferrerAssoc newMultipleReferrerAssoc = new MultipleReferrerAssocImpl( context, instanceId, ref_rel_num, m_referred_to_class_name );
        if ( context.addInstance( newMultipleReferrerAssoc ) ) {
            return newMultipleReferrerAssoc;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private int ref_rel_num;
    @Override
    public void setRel_num(int ref_rel_num) throws XtumlException {
        checkLiving();
        if (ref_rel_num != this.ref_rel_num) {
            final int oldValue = this.ref_rel_num;
            this.ref_rel_num = ref_rel_num;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_rel_num", oldValue, this.ref_rel_num));
            if ( !R3036_holds_referring_data_for_ReferringClassProxy().isEmpty() ) R3036_holds_referring_data_for_ReferringClassProxy().setRel_num( ref_rel_num );
        }
    }
    @Override
    public int getRel_num() throws XtumlException {
        checkLiving();
        return ref_rel_num;
    }
    private String m_referred_to_class_name;
    @Override
    public String getReferred_to_class_name() throws XtumlException {
        checkLiving();
        return m_referred_to_class_name;
    }
    @Override
    public void setReferred_to_class_name(String m_referred_to_class_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_referred_to_class_name, this.m_referred_to_class_name)) {
            final String oldValue = this.m_referred_to_class_name;
            this.m_referred_to_class_name = m_referred_to_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_referred_to_class_name", oldValue, this.m_referred_to_class_name));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getRel_num());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render_relate() throws XtumlException {
        String rnum_str = context().STRING().itoa( self().getRel_num() );
        AssociationSerializerLoader deserializer = self().R3029_is_a_AssociationSerializerLoader();
        boolean declare = true;
        context().T().push_buffer();
        ReferringClassProxySet refs = self().R3036_holds_referring_data_for_ReferringClassProxy();
        ReferringClassProxy ref;
        for ( Iterator<ReferringClassProxy> _ref_iter = refs.elements().iterator(); _ref_iter.hasNext(); ) {
            ref = _ref_iter.next();
            String form_class = ref.getReferring_class_name();
            String formvar = form_class + context().STRING().itoa( self().getRel_num() );
            String part_class = self().getReferred_to_class_name();
            String partvar = ( part_class + rnum_str ) + "_p";
            String rel_name = ref.getRel_name();
            context().T().include( "loader/t.linkloader.multi.relate.java", declare, form_class, formvar, part_class, partvar, rel_name );
            declare = false;
        }
        String relates = context().T().body();
        context().T().pop_buffer();
        context().T().include( "loader/t.linkloader.relate.java", relates, rnum_str );
    }

    @Override
    public void render_serialize() throws XtumlException {
        String link_type = "LINK2 ";
        String rnum_str = context().STRING().itoa( self().getRel_num() );
        AssociationSerializerLoader serializer = self().R3029_is_a_AssociationSerializerLoader();
        ReferringClassProxySet refs = self().R3036_holds_referring_data_for_ReferringClassProxy();
        ReferringClassProxy ref;
        for ( Iterator<ReferringClassProxy> _ref_iter = refs.elements().iterator(); _ref_iter.hasNext(); ) {
            ref = _ref_iter.next();
            context().T().push_buffer();
            String class_name = ref.getReferring_class_name();
            String selector_name = ref.getReference_name();
            context().T().include( "loader/t.singlelinkserializer.init.java", class_name, link_type, rnum_str, selector_name );
            String init = context().T().body();
            context().T().pop_buffer();
            context().T().push_buffer();
            new UniqueIDSerializerImpl.CLASS(context()).do_render( ref.getReferring_class_name(), "getInstanceId()" );
            String self_serialize = context().T().body();
            context().T().pop_buffer();
            context().T().push_buffer();
            String selector = ref.getReference_name() + "().";
            context().T().push_buffer();
            new UniqueIDSerializerImpl.CLASS(context()).do_render( ref.getReferring_class_name(), selector + "getInstanceId()" );
            String ref_out = context().T().body();
            context().T().pop_buffer();
            context().T().include( "loader/t.linkserializer.reference.java", ref_out );
            String referred_ids = context().T().body();
            context().T().pop_buffer();
            class_name = ref.getReferring_class_name();
            context().T().include( "loader/t.linkserializer.method.java", class_name, init, referred_ids, rnum_str, self_serialize );
        }
    }



    // static operations


    // events


    // selections
    private AssociationSerializerLoader R3029_is_a_AssociationSerializerLoader_inst;
    @Override
    public void setR3029_is_a_AssociationSerializerLoader( AssociationSerializerLoader inst ) {
        R3029_is_a_AssociationSerializerLoader_inst = inst;
    }
    @Override
    public AssociationSerializerLoader R3029_is_a_AssociationSerializerLoader() throws XtumlException {
        return R3029_is_a_AssociationSerializerLoader_inst;
    }
    private ReferringClassProxySet R3036_holds_referring_data_for_ReferringClassProxy_set;
    @Override
    public void addR3036_holds_referring_data_for_ReferringClassProxy( ReferringClassProxy inst ) {
        R3036_holds_referring_data_for_ReferringClassProxy_set.add(inst);
    }
    @Override
    public void removeR3036_holds_referring_data_for_ReferringClassProxy( ReferringClassProxy inst ) {
        R3036_holds_referring_data_for_ReferringClassProxy_set.remove(inst);
    }
    @Override
    public ReferringClassProxySet R3036_holds_referring_data_for_ReferringClassProxy() throws XtumlException {
        return R3036_holds_referring_data_for_ReferringClassProxy_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public MultipleReferrerAssoc self() {
        return this;
    }

    @Override
    public MultipleReferrerAssoc oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_MULTIPLEREFERRERASSOC;
    }

}

class EmptyMultipleReferrerAssoc extends ModelInstance<MultipleReferrerAssoc,Sql> implements MultipleReferrerAssoc {

    // attributes
    public void setRel_num( int ref_rel_num ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getRel_num() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getReferred_to_class_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setReferred_to_class_name( String m_referred_to_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render_relate() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_serialize() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public AssociationSerializerLoader R3029_is_a_AssociationSerializerLoader() {
        return AssociationSerializerLoaderImpl.EMPTY_ASSOCIATIONSERIALIZERLOADER;
    }
    @Override
    public ReferringClassProxySet R3036_holds_referring_data_for_ReferringClassProxy() {
        return (new ReferringClassProxySetImpl());
    }


    @Override
    public String getKeyLetters() {
        return MultipleReferrerAssocImpl.KEY_LETTERS;
    }

    @Override
    public MultipleReferrerAssoc self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public MultipleReferrerAssoc oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return MultipleReferrerAssocImpl.EMPTY_MULTIPLEREFERRERASSOC;
    }

}
