package io.ciera.tool.sql.architecture.type.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.type.BuiltInType;
import io.ciera.tool.sql.architecture.type.BuiltInTypeSet;
import io.ciera.tool.sql.architecture.type.TypeSet;
import io.ciera.tool.sql.architecture.type.impl.TypeSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class BuiltInTypeSetImpl extends InstanceSet<BuiltInTypeSet,BuiltInType> implements BuiltInTypeSet {

    public BuiltInTypeSetImpl() {
    }

    public BuiltInTypeSetImpl(Comparator<? super BuiltInType> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setName( String ref_name ) throws XtumlException {
        for ( BuiltInType builtintype : this ) builtintype.setName( ref_name );
    }
    @Override
    public void setInst( boolean m_inst ) throws XtumlException {
        for ( BuiltInType builtintype : this ) builtintype.setInst( m_inst );
    }
    @Override
    public void setPrimitive( boolean m_primitive ) throws XtumlException {
        for ( BuiltInType builtintype : this ) builtintype.setPrimitive( m_primitive );
    }
    @Override
    public void setPackage( String ref_package ) throws XtumlException {
        for ( BuiltInType builtintype : this ) builtintype.setPackage( ref_package );
    }
    @Override
    public void setInstset( boolean m_instset ) throws XtumlException {
        for ( BuiltInType builtintype : this ) builtintype.setInstset( m_instset );
    }
    @Override
    public void setUnique( boolean m_unique ) throws XtumlException {
        for ( BuiltInType builtintype : this ) builtintype.setUnique( m_unique );
    }


    // selections
    @Override
    public TypeSet R407_is_a_Type() throws XtumlException {
        TypeSet typeset = new TypeSetImpl();
        for ( BuiltInType builtintype : this ) typeset.add( builtintype.R407_is_a_Type() );
        return typeset;
    }


    @Override
    public BuiltInType nullElement() {
        return BuiltInTypeImpl.EMPTY_BUILTINTYPE;
    }

    @Override
    public BuiltInTypeSet emptySet() {
      return new BuiltInTypeSetImpl();
    }

    @Override
    public BuiltInTypeSet emptySet(Comparator<? super BuiltInType> comp) {
      return new BuiltInTypeSetImpl(comp);
    }

    @Override
    public List<BuiltInType> elements() {
        BuiltInType[] elements = toArray(new BuiltInType[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
