package io.ciera.tool.sql.architecture.statement.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.invocable.CodeBlock;
import io.ciera.tool.sql.architecture.invocable.impl.CodeBlockImpl;
import io.ciera.tool.sql.architecture.statement.Variable;
import io.ciera.tool.sql.architecture.statement.VariableInScope;
import io.ciera.tool.sql.architecture.statement.impl.VariableImpl;


public class VariableInScopeImpl extends ModelInstance<VariableInScope,Sql> implements VariableInScope {

    public static final String KEY_LETTERS = "VariableInScope";
    public static final VariableInScope EMPTY_VARIABLEINSCOPE = new EmptyVariableInScope();

    private Sql context;

    // constructors
    private VariableInScopeImpl( Sql context ) {
        this.context = context;
        ref_parent_name = "";
        ref_parent_package = "";
        ref_body_name = "";
        ref_block_number = "";
        ref_var_block_number = "";
        ref_var_name = "";
        R458_has_in_scope_Variable_inst = VariableImpl.EMPTY_VARIABLE;
        R458_is_in_scope_for_CodeBlock_inst = CodeBlockImpl.EMPTY_CODEBLOCK;
    }

    private VariableInScopeImpl( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_var_block_number, String ref_var_name ) {
        super(instanceId);
        this.context = context;
        this.ref_parent_name = ref_parent_name;
        this.ref_parent_package = ref_parent_package;
        this.ref_body_name = ref_body_name;
        this.ref_block_number = ref_block_number;
        this.ref_var_block_number = ref_var_block_number;
        this.ref_var_name = ref_var_name;
        R458_has_in_scope_Variable_inst = VariableImpl.EMPTY_VARIABLE;
        R458_is_in_scope_for_CodeBlock_inst = CodeBlockImpl.EMPTY_CODEBLOCK;
    }

    public static VariableInScope create( Sql context ) throws XtumlException {
        VariableInScope newVariableInScope = new VariableInScopeImpl( context );
        if ( context.addInstance( newVariableInScope ) ) {
            newVariableInScope.getRunContext().addChange(new InstanceCreatedDelta(newVariableInScope, KEY_LETTERS));
            return newVariableInScope;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static VariableInScope create( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_var_block_number, String ref_var_name ) throws XtumlException {
        VariableInScope newVariableInScope = new VariableInScopeImpl( context, instanceId, ref_parent_name, ref_parent_package, ref_body_name, ref_block_number, ref_var_block_number, ref_var_name );
        if ( context.addInstance( newVariableInScope ) ) {
            return newVariableInScope;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_parent_name;
    @Override
    public void setParent_name(String ref_parent_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_name, this.ref_parent_name)) {
            final String oldValue = this.ref_parent_name;
            this.ref_parent_name = ref_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_name", oldValue, this.ref_parent_name));
        }
    }
    @Override
    public String getParent_name() throws XtumlException {
        checkLiving();
        return ref_parent_name;
    }
    private String ref_parent_package;
    @Override
    public void setParent_package(String ref_parent_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_package, this.ref_parent_package)) {
            final String oldValue = this.ref_parent_package;
            this.ref_parent_package = ref_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_package", oldValue, this.ref_parent_package));
        }
    }
    @Override
    public String getParent_package() throws XtumlException {
        checkLiving();
        return ref_parent_package;
    }
    private String ref_body_name;
    @Override
    public String getBody_name() throws XtumlException {
        checkLiving();
        return ref_body_name;
    }
    @Override
    public void setBody_name(String ref_body_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_body_name, this.ref_body_name)) {
            final String oldValue = this.ref_body_name;
            this.ref_body_name = ref_body_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_body_name", oldValue, this.ref_body_name));
        }
    }
    private String ref_block_number;
    @Override
    public String getBlock_number() throws XtumlException {
        checkLiving();
        return ref_block_number;
    }
    @Override
    public void setBlock_number(String ref_block_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_block_number, this.ref_block_number)) {
            final String oldValue = this.ref_block_number;
            this.ref_block_number = ref_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_block_number", oldValue, this.ref_block_number));
        }
    }
    private String ref_var_block_number;
    @Override
    public void setVar_block_number(String ref_var_block_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_var_block_number, this.ref_var_block_number)) {
            final String oldValue = this.ref_var_block_number;
            this.ref_var_block_number = ref_var_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_var_block_number", oldValue, this.ref_var_block_number));
        }
    }
    @Override
    public String getVar_block_number() throws XtumlException {
        checkLiving();
        return ref_var_block_number;
    }
    private String ref_var_name;
    @Override
    public void setVar_name(String ref_var_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_var_name, this.ref_var_name)) {
            final String oldValue = this.ref_var_name;
            this.ref_var_name = ref_var_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_var_name", oldValue, this.ref_var_name));
        }
    }
    @Override
    public String getVar_name() throws XtumlException {
        checkLiving();
        return ref_var_name;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getParent_name(), getParent_package(), getBody_name(), getBlock_number(), getVar_block_number(), getVar_name());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Variable R458_has_in_scope_Variable_inst;
    @Override
    public void setR458_has_in_scope_Variable( Variable inst ) {
        R458_has_in_scope_Variable_inst = inst;
    }
    @Override
    public Variable R458_has_in_scope_Variable() throws XtumlException {
        return R458_has_in_scope_Variable_inst;
    }
    private CodeBlock R458_is_in_scope_for_CodeBlock_inst;
    @Override
    public void setR458_is_in_scope_for_CodeBlock( CodeBlock inst ) {
        R458_is_in_scope_for_CodeBlock_inst = inst;
    }
    @Override
    public CodeBlock R458_is_in_scope_for_CodeBlock() throws XtumlException {
        return R458_is_in_scope_for_CodeBlock_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public VariableInScope self() {
        return this;
    }

    @Override
    public VariableInScope oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_VARIABLEINSCOPE;
    }

}

class EmptyVariableInScope extends ModelInstance<VariableInScope,Sql> implements VariableInScope {

    // attributes
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getBody_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBody_name( String ref_body_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBlock_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setVar_block_number( String ref_var_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getVar_block_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setVar_name( String ref_var_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getVar_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Variable R458_has_in_scope_Variable() {
        return VariableImpl.EMPTY_VARIABLE;
    }
    @Override
    public CodeBlock R458_is_in_scope_for_CodeBlock() {
        return CodeBlockImpl.EMPTY_CODEBLOCK;
    }


    @Override
    public String getKeyLetters() {
        return VariableInScopeImpl.KEY_LETTERS;
    }

    @Override
    public VariableInScope self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public VariableInScope oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return VariableInScopeImpl.EMPTY_VARIABLEINSCOPE;
    }

}
