package io.ciera.tool.sql.architecture.statement.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.expression.ExpressionSet;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionSetImpl;
import io.ciera.tool.sql.architecture.invocable.CodeBlockSet;
import io.ciera.tool.sql.architecture.invocable.impl.CodeBlockSetImpl;
import io.ciera.tool.sql.architecture.statement.ForSmt;
import io.ciera.tool.sql.architecture.statement.ForSmtSet;
import io.ciera.tool.sql.architecture.statement.StatementSet;
import io.ciera.tool.sql.architecture.statement.VariableSet;
import io.ciera.tool.sql.architecture.statement.impl.StatementSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.VariableSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class ForSmtSetImpl extends InstanceSet<ForSmtSet,ForSmt> implements ForSmtSet {

    public ForSmtSetImpl() {
    }

    public ForSmtSetImpl(Comparator<? super ForSmt> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( ForSmt forsmt : this ) forsmt.setParent_package( ref_parent_package );
    }
    @Override
    public void setIterator_block_number( String ref_iterator_block_number ) throws XtumlException {
        for ( ForSmt forsmt : this ) forsmt.setIterator_block_number( ref_iterator_block_number );
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( ForSmt forsmt : this ) forsmt.setBlock_number( ref_block_number );
    }
    @Override
    public void setIterator_name( String ref_iterator_name ) throws XtumlException {
        for ( ForSmt forsmt : this ) forsmt.setIterator_name( ref_iterator_name );
    }
    @Override
    public void setIterable_expression_number( String ref_iterable_expression_number ) throws XtumlException {
        for ( ForSmt forsmt : this ) forsmt.setIterable_expression_number( ref_iterable_expression_number );
    }
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        for ( ForSmt forsmt : this ) forsmt.setStatement_number( ref_statement_number );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( ForSmt forsmt : this ) forsmt.setParent_name( ref_parent_name );
    }
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        for ( ForSmt forsmt : this ) forsmt.setBody_name( ref_body_name );
    }
    @Override
    public void setControl_block_number( String ref_control_block_number ) throws XtumlException {
        for ( ForSmt forsmt : this ) forsmt.setControl_block_number( ref_control_block_number );
    }


    // selections
    @Override
    public StatementSet R451_is_a_Statement() throws XtumlException {
        StatementSet statementset = new StatementSetImpl();
        for ( ForSmt forsmt : this ) statementset.add( forsmt.R451_is_a_Statement() );
        return statementset;
    }
    @Override
    public CodeBlockSet R455_has_control_CodeBlock() throws XtumlException {
        CodeBlockSet codeblockset = new CodeBlockSetImpl();
        for ( ForSmt forsmt : this ) codeblockset.add( forsmt.R455_has_control_CodeBlock() );
        return codeblockset;
    }
    @Override
    public VariableSet R459_declares_as_iterator_Variable() throws XtumlException {
        VariableSet variableset = new VariableSetImpl();
        for ( ForSmt forsmt : this ) variableset.add( forsmt.R459_declares_as_iterator_Variable() );
        return variableset;
    }
    @Override
    public ExpressionSet R478_iterates_over_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( ForSmt forsmt : this ) expressionset.add( forsmt.R478_iterates_over_Expression() );
        return expressionset;
    }


    @Override
    public ForSmt nullElement() {
        return ForSmtImpl.EMPTY_FORSMT;
    }

    @Override
    public ForSmtSet emptySet() {
      return new ForSmtSetImpl();
    }

    @Override
    public ForSmtSet emptySet(Comparator<? super ForSmt> comp) {
      return new ForSmtSetImpl(comp);
    }

    @Override
    public List<ForSmt> elements() {
        return Arrays.asList(toArray(new ForSmt[0]));
    }

}
