package io.ciera.tool.sql.architecture.statement;


import io.ciera.runtime.summit.classes.IModelInstance;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.expression.Expression;
import io.ciera.tool.sql.architecture.invocable.CodeBlock;
import io.ciera.tool.sql.architecture.statement.Statement;
import io.ciera.tool.sql.architecture.statement.Variable;


public interface ForSmt extends IModelInstance<ForSmt,Sql> {

    // attributes
    public void setParent_name( String ref_parent_name ) throws XtumlException;
    public String getParent_name() throws XtumlException;
    public String getParent_package() throws XtumlException;
    public void setParent_package( String ref_parent_package ) throws XtumlException;
    public void setBody_name( String ref_body_name ) throws XtumlException;
    public String getBody_name() throws XtumlException;
    public void setBlock_number( String ref_block_number ) throws XtumlException;
    public String getBlock_number() throws XtumlException;
    public String getStatement_number() throws XtumlException;
    public void setStatement_number( String ref_statement_number ) throws XtumlException;
    public void setControl_block_number( String ref_control_block_number ) throws XtumlException;
    public String getControl_block_number() throws XtumlException;
    public String getIterator_name() throws XtumlException;
    public void setIterator_name( String ref_iterator_name ) throws XtumlException;
    public void setIterator_block_number( String ref_iterator_block_number ) throws XtumlException;
    public String getIterator_block_number() throws XtumlException;
    public String getIterable_expression_number() throws XtumlException;
    public void setIterable_expression_number( String ref_iterable_expression_number ) throws XtumlException;


    // operations
    public void initializeIterator() throws XtumlException;
    public void render() throws XtumlException;


    // selections
    default public void setR451_is_a_Statement( Statement inst ) {}
    public Statement R451_is_a_Statement() throws XtumlException;
    default public void setR455_has_control_CodeBlock( CodeBlock inst ) {}
    public CodeBlock R455_has_control_CodeBlock() throws XtumlException;
    default public void setR459_declares_as_iterator_Variable( Variable inst ) {}
    public Variable R459_declares_as_iterator_Variable() throws XtumlException;
    default public void setR478_iterates_over_Expression( Expression inst ) {}
    public Expression R478_iterates_over_Expression() throws XtumlException;


}
