package io.ciera.tool.sql.architecture.statemachine.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.classes.ModelInstSet;
import io.ciera.tool.sql.architecture.classes.impl.ModelInstSetImpl;
import io.ciera.tool.sql.architecture.file.FileSet;
import io.ciera.tool.sql.architecture.file.impl.FileSetImpl;
import io.ciera.tool.sql.architecture.statemachine.EventSet;
import io.ciera.tool.sql.architecture.statemachine.StateMachine;
import io.ciera.tool.sql.architecture.statemachine.StateMachineSet;
import io.ciera.tool.sql.architecture.statemachine.StateSet;
import io.ciera.tool.sql.architecture.statemachine.TransitionTableRowSet;
import io.ciera.tool.sql.architecture.statemachine.impl.EventSetImpl;
import io.ciera.tool.sql.architecture.statemachine.impl.StateSetImpl;
import io.ciera.tool.sql.architecture.statemachine.impl.TransitionTableRowSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class StateMachineSetImpl extends InstanceSet<StateMachineSet,StateMachine> implements StateMachineSet {

    public StateMachineSetImpl() {
    }

    public StateMachineSetImpl(Comparator<? super StateMachine> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setPackage( String ref_package ) throws XtumlException {
        for ( StateMachine statemachine : this ) statemachine.setPackage( ref_package );
    }
    @Override
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        for ( StateMachine statemachine : this ) statemachine.setComp_package( ref_comp_package );
    }
    @Override
    public void setName( String ref_name ) throws XtumlException {
        for ( StateMachine statemachine : this ) statemachine.setName( ref_name );
    }
    @Override
    public void setClass_name( String ref_class_name ) throws XtumlException {
        for ( StateMachine statemachine : this ) statemachine.setClass_name( ref_class_name );
    }
    @Override
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        for ( StateMachine statemachine : this ) statemachine.setComp_name( ref_comp_name );
    }


    // selections
    @Override
    public FileSet R401_is_a_File() throws XtumlException {
        FileSet fileset = new FileSetImpl();
        for ( StateMachine statemachine : this ) fileset.add( statemachine.R401_is_a_File() );
        return fileset;
    }
    @Override
    public ModelInstSet R4750_models_behavior_of_ModelInst() throws XtumlException {
        ModelInstSet modelinstset = new ModelInstSetImpl();
        for ( StateMachine statemachine : this ) modelinstset.add( statemachine.R4750_models_behavior_of_ModelInst() );
        return modelinstset;
    }
    @Override
    public StateSet R4751_declares_State() throws XtumlException {
        StateSet stateset = new StateSetImpl();
        for ( StateMachine statemachine : this ) stateset.addAll( statemachine.R4751_declares_State() );
        return stateset;
    }
    @Override
    public EventSet R4752_declares_Event() throws XtumlException {
        EventSet eventset = new EventSetImpl();
        for ( StateMachine statemachine : this ) eventset.addAll( statemachine.R4752_declares_Event() );
        return eventset;
    }
    @Override
    public TransitionTableRowSet R4753_transitions_defined_by_TransitionTableRow() throws XtumlException {
        TransitionTableRowSet transitiontablerowset = new TransitionTableRowSetImpl();
        for ( StateMachine statemachine : this ) transitiontablerowset.addAll( statemachine.R4753_transitions_defined_by_TransitionTableRow() );
        return transitiontablerowset;
    }


    @Override
    public StateMachine nullElement() {
        return StateMachineImpl.EMPTY_STATEMACHINE;
    }

    @Override
    public StateMachineSet emptySet() {
      return new StateMachineSetImpl();
    }

    @Override
    public StateMachineSet emptySet(Comparator<? super StateMachine> comp) {
      return new StateMachineSetImpl(comp);
    }

    @Override
    public List<StateMachine> elements() {
        StateMachine[] elements = toArray(new StateMachine[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
