package io.ciera.tool.sql.architecture.file.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.application.ApplicationSet;
import io.ciera.tool.sql.architecture.application.impl.ApplicationSetImpl;
import io.ciera.tool.sql.architecture.classes.InstSetSet;
import io.ciera.tool.sql.architecture.classes.ModelInstSet;
import io.ciera.tool.sql.architecture.classes.impl.InstSetSetImpl;
import io.ciera.tool.sql.architecture.classes.impl.ModelInstSetImpl;
import io.ciera.tool.sql.architecture.component.ComponentDefinitionSet;
import io.ciera.tool.sql.architecture.component.UtilitySet;
import io.ciera.tool.sql.architecture.component.impl.ComponentDefinitionSetImpl;
import io.ciera.tool.sql.architecture.component.impl.UtilitySetImpl;
import io.ciera.tool.sql.architecture.file.File;
import io.ciera.tool.sql.architecture.file.FileSet;
import io.ciera.tool.sql.architecture.file.GeneralFileSet;
import io.ciera.tool.sql.architecture.file.TypeImportReferenceSet;
import io.ciera.tool.sql.architecture.file.impl.GeneralFileSetImpl;
import io.ciera.tool.sql.architecture.file.impl.TypeImportReferenceSetImpl;
import io.ciera.tool.sql.architecture.interfaces.IfaceSet;
import io.ciera.tool.sql.architecture.interfaces.PortSet;
import io.ciera.tool.sql.architecture.interfaces.impl.IfaceSetImpl;
import io.ciera.tool.sql.architecture.interfaces.impl.PortSetImpl;
import io.ciera.tool.sql.architecture.statemachine.StateMachineSet;
import io.ciera.tool.sql.architecture.statemachine.impl.StateMachineSetImpl;
import io.ciera.tool.sql.architecture.type.EnumeratedTypeSet;
import io.ciera.tool.sql.architecture.type.UserDefinedTypeSet;
import io.ciera.tool.sql.architecture.type.impl.EnumeratedTypeSetImpl;
import io.ciera.tool.sql.architecture.type.impl.UserDefinedTypeSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class FileSetImpl extends InstanceSet<FileSet,File> implements FileSet {

    public FileSetImpl() {
    }

    public FileSetImpl(Comparator<? super File> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setPath( String m_path ) throws XtumlException {
        for ( File file : this ) file.setPath( m_path );
    }
    @Override
    public void setExtension( String m_extension ) throws XtumlException {
        for ( File file : this ) file.setExtension( m_extension );
    }
    @Override
    public void setPackage( String m_package ) throws XtumlException {
        for ( File file : this ) file.setPackage( m_package );
    }
    @Override
    public void setName( String m_name ) throws XtumlException {
        for ( File file : this ) file.setName( m_name );
    }
    @Override
    public void setExclude( boolean m_exclude ) throws XtumlException {
        for ( File file : this ) file.setExclude( m_exclude );
    }


    // selections
    @Override
    public ApplicationSet R401_is_a_Application() throws XtumlException {
        ApplicationSet applicationset = new ApplicationSetImpl();
        for ( File file : this ) applicationset.add( file.R401_is_a_Application() );
        return applicationset;
    }
    @Override
    public ComponentDefinitionSet R401_is_a_ComponentDefinition() throws XtumlException {
        ComponentDefinitionSet componentdefinitionset = new ComponentDefinitionSetImpl();
        for ( File file : this ) componentdefinitionset.add( file.R401_is_a_ComponentDefinition() );
        return componentdefinitionset;
    }
    @Override
    public EnumeratedTypeSet R401_is_a_EnumeratedType() throws XtumlException {
        EnumeratedTypeSet enumeratedtypeset = new EnumeratedTypeSetImpl();
        for ( File file : this ) enumeratedtypeset.add( file.R401_is_a_EnumeratedType() );
        return enumeratedtypeset;
    }
    @Override
    public GeneralFileSet R401_is_a_GeneralFile() throws XtumlException {
        GeneralFileSet generalfileset = new GeneralFileSetImpl();
        for ( File file : this ) generalfileset.add( file.R401_is_a_GeneralFile() );
        return generalfileset;
    }
    @Override
    public IfaceSet R401_is_a_Iface() throws XtumlException {
        IfaceSet ifaceset = new IfaceSetImpl();
        for ( File file : this ) ifaceset.add( file.R401_is_a_Iface() );
        return ifaceset;
    }
    @Override
    public InstSetSet R401_is_a_InstSet() throws XtumlException {
        InstSetSet instsetset = new InstSetSetImpl();
        for ( File file : this ) instsetset.add( file.R401_is_a_InstSet() );
        return instsetset;
    }
    @Override
    public ModelInstSet R401_is_a_ModelInst() throws XtumlException {
        ModelInstSet modelinstset = new ModelInstSetImpl();
        for ( File file : this ) modelinstset.add( file.R401_is_a_ModelInst() );
        return modelinstset;
    }
    @Override
    public PortSet R401_is_a_Port() throws XtumlException {
        PortSet portset = new PortSetImpl();
        for ( File file : this ) portset.add( file.R401_is_a_Port() );
        return portset;
    }
    @Override
    public StateMachineSet R401_is_a_StateMachine() throws XtumlException {
        StateMachineSet statemachineset = new StateMachineSetImpl();
        for ( File file : this ) statemachineset.add( file.R401_is_a_StateMachine() );
        return statemachineset;
    }
    @Override
    public UserDefinedTypeSet R401_is_a_UserDefinedType() throws XtumlException {
        UserDefinedTypeSet userdefinedtypeset = new UserDefinedTypeSetImpl();
        for ( File file : this ) userdefinedtypeset.add( file.R401_is_a_UserDefinedType() );
        return userdefinedtypeset;
    }
    @Override
    public UtilitySet R401_is_a_Utility() throws XtumlException {
        UtilitySet utilityset = new UtilitySetImpl();
        for ( File file : this ) utilityset.add( file.R401_is_a_Utility() );
        return utilityset;
    }
    @Override
    public TypeImportReferenceSet R402_imports_type_via_TypeImportReference() throws XtumlException {
        TypeImportReferenceSet typeimportreferenceset = new TypeImportReferenceSetImpl();
        for ( File file : this ) typeimportreferenceset.addAll( file.R402_imports_type_via_TypeImportReference() );
        return typeimportreferenceset;
    }


    @Override
    public File nullElement() {
        return FileImpl.EMPTY_FILE;
    }

    @Override
    public FileSet emptySet() {
      return new FileSetImpl();
    }

    @Override
    public FileSet emptySet(Comparator<? super File> comp) {
      return new FileSetImpl(comp);
    }

    @Override
    public List<File> elements() {
        File[] elements = toArray(new File[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
