package io.ciera.tool.sql.architecture.component.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.application.ComponentInstantiation;
import io.ciera.tool.sql.architecture.application.ComponentInstantiationSet;
import io.ciera.tool.sql.architecture.application.impl.ComponentInstantiationSetImpl;
import io.ciera.tool.sql.architecture.classes.ClassRelationship;
import io.ciera.tool.sql.architecture.classes.ClassRelationshipSet;
import io.ciera.tool.sql.architecture.classes.InstSet;
import io.ciera.tool.sql.architecture.classes.ModelInst;
import io.ciera.tool.sql.architecture.classes.ModelInstSet;
import io.ciera.tool.sql.architecture.classes.impl.ClassRelationshipSetImpl;
import io.ciera.tool.sql.architecture.classes.impl.ModelInstSetImpl;
import io.ciera.tool.sql.architecture.component.ComponentDefinition;
import io.ciera.tool.sql.architecture.component.Function;
import io.ciera.tool.sql.architecture.component.FunctionSet;
import io.ciera.tool.sql.architecture.component.InstancePopulationSelector;
import io.ciera.tool.sql.architecture.component.InstancePopulationSelectorSet;
import io.ciera.tool.sql.architecture.component.RelationshipPopulationSelector;
import io.ciera.tool.sql.architecture.component.RelationshipPopulationSelectorSet;
import io.ciera.tool.sql.architecture.component.UtilityReference;
import io.ciera.tool.sql.architecture.component.UtilityReferenceSet;
import io.ciera.tool.sql.architecture.component.impl.FunctionImpl;
import io.ciera.tool.sql.architecture.component.impl.FunctionSetImpl;
import io.ciera.tool.sql.architecture.component.impl.InstancePopulationSelectorSetImpl;
import io.ciera.tool.sql.architecture.component.impl.RelationshipPopulationSelectorSetImpl;
import io.ciera.tool.sql.architecture.component.impl.UtilityReferenceSetImpl;
import io.ciera.tool.sql.architecture.file.File;
import io.ciera.tool.sql.architecture.file.impl.FileImpl;
import io.ciera.tool.sql.architecture.interfaces.Port;
import io.ciera.tool.sql.architecture.interfaces.PortSet;
import io.ciera.tool.sql.architecture.interfaces.impl.PortSetImpl;
import io.ciera.tool.sql.ooaofooa.component.C_C;
import io.ciera.tool.sql.ooaofooa.component.impl.C_CImpl;

import java.util.Iterator;

import types.ImportType;


public class ComponentDefinitionImpl extends ModelInstance<ComponentDefinition,Sql> implements ComponentDefinition {

    public static final String KEY_LETTERS = "ComponentDefinition";
    public static final ComponentDefinition EMPTY_COMPONENTDEFINITION = new EmptyComponentDefinition();

    private Sql context;

    // constructors
    private ComponentDefinitionImpl( Sql context ) {
        this.context = context;
        ref_name = "";
        ref_package = "";
        ref_init_function_name = "";
        m_extends = "";
        ref_c_c_Id = UniqueId.random();
        m_version = "";
        m_version_date = "";
        R401_is_a_File_inst = FileImpl.EMPTY_FILE;
        R405_provides_synchronous_Function_set = new FunctionSetImpl();
        R408_maintains_instances_of_ModelInst_set = new ModelInstSetImpl();
        R417_communicates_through_Port_set = new PortSetImpl();
        R426_is_instantiated_by_ComponentInstantiation_set = new ComponentInstantiationSetImpl();
        R447_selects_instances_through_InstancePopulationSelector_set = new InstancePopulationSelectorSetImpl();
        R448_maintains_instances_of_ClassRelationship_set = new ClassRelationshipSetImpl();
        R4558_contains_UtilityReference_set = new UtilityReferenceSetImpl();
        R4561_initialized_by_Function_inst = FunctionImpl.EMPTY_FUNCTION;
        R4571_selects_relationships_through_RelationshipPopulationSelector_set = new RelationshipPopulationSelectorSetImpl();
        R4573_is_transformed_from_C_C_inst = C_CImpl.EMPTY_C_C;
    }

    private ComponentDefinitionImpl( Sql context, UniqueId instanceId, String ref_name, String ref_package, String ref_init_function_name, String m_extends, UniqueId ref_c_c_Id, String m_version, String m_version_date ) {
        super(instanceId);
        this.context = context;
        this.ref_name = ref_name;
        this.ref_package = ref_package;
        this.ref_init_function_name = ref_init_function_name;
        this.m_extends = m_extends;
        this.ref_c_c_Id = ref_c_c_Id;
        this.m_version = m_version;
        this.m_version_date = m_version_date;
        R401_is_a_File_inst = FileImpl.EMPTY_FILE;
        R405_provides_synchronous_Function_set = new FunctionSetImpl();
        R408_maintains_instances_of_ModelInst_set = new ModelInstSetImpl();
        R417_communicates_through_Port_set = new PortSetImpl();
        R426_is_instantiated_by_ComponentInstantiation_set = new ComponentInstantiationSetImpl();
        R447_selects_instances_through_InstancePopulationSelector_set = new InstancePopulationSelectorSetImpl();
        R448_maintains_instances_of_ClassRelationship_set = new ClassRelationshipSetImpl();
        R4558_contains_UtilityReference_set = new UtilityReferenceSetImpl();
        R4561_initialized_by_Function_inst = FunctionImpl.EMPTY_FUNCTION;
        R4571_selects_relationships_through_RelationshipPopulationSelector_set = new RelationshipPopulationSelectorSetImpl();
        R4573_is_transformed_from_C_C_inst = C_CImpl.EMPTY_C_C;
    }

    public static ComponentDefinition create( Sql context ) throws XtumlException {
        ComponentDefinition newComponentDefinition = new ComponentDefinitionImpl( context );
        if ( context.addInstance( newComponentDefinition ) ) {
            newComponentDefinition.getRunContext().addChange(new InstanceCreatedDelta(newComponentDefinition, KEY_LETTERS));
            return newComponentDefinition;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ComponentDefinition create( Sql context, UniqueId instanceId, String ref_name, String ref_package, String ref_init_function_name, String m_extends, UniqueId ref_c_c_Id, String m_version, String m_version_date ) throws XtumlException {
        ComponentDefinition newComponentDefinition = new ComponentDefinitionImpl( context, instanceId, ref_name, ref_package, ref_init_function_name, m_extends, ref_c_c_Id, m_version, m_version_date );
        if ( context.addInstance( newComponentDefinition ) ) {
            return newComponentDefinition;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_name;
    @Override
    public void setName(String ref_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_name, this.ref_name)) {
            final String oldValue = this.ref_name;
            this.ref_name = ref_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_name", oldValue, this.ref_name));
            if ( !R4571_selects_relationships_through_RelationshipPopulationSelector().isEmpty() ) R4571_selects_relationships_through_RelationshipPopulationSelector().setComp_name( ref_name );
            if ( !R447_selects_instances_through_InstancePopulationSelector().isEmpty() ) R447_selects_instances_through_InstancePopulationSelector().setComp_name( ref_name );
            if ( !R408_maintains_instances_of_ModelInst().isEmpty() ) R408_maintains_instances_of_ModelInst().setComp_name( ref_name );
            if ( !R417_communicates_through_Port().isEmpty() ) R417_communicates_through_Port().setComp_name( ref_name );
            if ( !R405_provides_synchronous_Function().isEmpty() ) R405_provides_synchronous_Function().setComp_name( ref_name );
            if ( !R426_is_instantiated_by_ComponentInstantiation().isEmpty() ) R426_is_instantiated_by_ComponentInstantiation().setComp_name( ref_name );
            if ( !R448_maintains_instances_of_ClassRelationship().isEmpty() ) R448_maintains_instances_of_ClassRelationship().setComp_name( ref_name );
            if ( !R4558_contains_UtilityReference().isEmpty() ) R4558_contains_UtilityReference().setComp_name( ref_name );
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return ref_name;
    }
    private String ref_package;
    @Override
    public String getPackage() throws XtumlException {
        checkLiving();
        return ref_package;
    }
    @Override
    public void setPackage(String ref_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_package, this.ref_package)) {
            final String oldValue = this.ref_package;
            this.ref_package = ref_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_package", oldValue, this.ref_package));
            if ( !R426_is_instantiated_by_ComponentInstantiation().isEmpty() ) R426_is_instantiated_by_ComponentInstantiation().setComp_package( ref_package );
            if ( !R4558_contains_UtilityReference().isEmpty() ) R4558_contains_UtilityReference().setComp_package( ref_package );
            if ( !R447_selects_instances_through_InstancePopulationSelector().isEmpty() ) R447_selects_instances_through_InstancePopulationSelector().setComp_package( ref_package );
            if ( !R405_provides_synchronous_Function().isEmpty() ) R405_provides_synchronous_Function().setComp_package( ref_package );
            if ( !R417_communicates_through_Port().isEmpty() ) R417_communicates_through_Port().setComp_package( ref_package );
            if ( !R448_maintains_instances_of_ClassRelationship().isEmpty() ) R448_maintains_instances_of_ClassRelationship().setComp_package( ref_package );
            if ( !R408_maintains_instances_of_ModelInst().isEmpty() ) R408_maintains_instances_of_ModelInst().setComp_package( ref_package );
            if ( !R4571_selects_relationships_through_RelationshipPopulationSelector().isEmpty() ) R4571_selects_relationships_through_RelationshipPopulationSelector().setComp_package( ref_package );
        }
    }
    private String ref_init_function_name;
    @Override
    public void setInit_function_name(String ref_init_function_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_init_function_name, this.ref_init_function_name)) {
            final String oldValue = this.ref_init_function_name;
            this.ref_init_function_name = ref_init_function_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_init_function_name", oldValue, this.ref_init_function_name));
        }
    }
    @Override
    public String getInit_function_name() throws XtumlException {
        checkLiving();
        return ref_init_function_name;
    }
    private String m_extends;
    @Override
    public String getExtends() throws XtumlException {
        checkLiving();
        return m_extends;
    }
    @Override
    public void setExtends(String m_extends) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_extends, this.m_extends)) {
            final String oldValue = this.m_extends;
            this.m_extends = m_extends;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_extends", oldValue, this.m_extends));
        }
    }
    private UniqueId ref_c_c_Id;
    @Override
    public void setC_c_Id(UniqueId ref_c_c_Id) throws XtumlException {
        checkLiving();
        if (ref_c_c_Id.inequality( this.ref_c_c_Id)) {
            final UniqueId oldValue = this.ref_c_c_Id;
            this.ref_c_c_Id = ref_c_c_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_c_c_Id", oldValue, this.ref_c_c_Id));
        }
    }
    @Override
    public UniqueId getC_c_Id() throws XtumlException {
        checkLiving();
        return ref_c_c_Id;
    }
    private String m_version;
    @Override
    public String getVersion() throws XtumlException {
        checkLiving();
        return m_version;
    }
    @Override
    public void setVersion(String m_version) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_version, this.m_version)) {
            final String oldValue = this.m_version;
            this.m_version = m_version;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_version", oldValue, this.m_version));
        }
    }
    private String m_version_date;
    @Override
    public String getVersion_date() throws XtumlException {
        checkLiving();
        return m_version_date;
    }
    @Override
    public void setVersion_date(String m_version_date) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_version_date, this.m_version_date)) {
            final String oldValue = this.m_version_date;
            this.m_version_date = m_version_date;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_version_date", oldValue, this.m_version_date));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getName(), getPackage());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        File file = self().R401_is_a_File();
        String imports = file.getFormattedImports( ImportType.IMPL );
        String instance_extent_initializers = "";
        String instance_adds = "";
        String instance_removes = "";
        String class_directory = "";
        String separator = "";
        String test = "if";
        ModelInstSet classes = self().R408_maintains_instances_of_ModelInst();
        ModelInst class_in_comp;
        for ( Iterator<ModelInst> _class_in_comp_iter = classes.elements().iterator(); _class_in_comp_iter.hasNext(); ) {
            class_in_comp = _class_in_comp_iter.next();
            InstSet class_set = class_in_comp.R406_is_type_of_single_element_in_InstSet();
            instance_extent_initializers = ( ( ( ( ( instance_extent_initializers + separator ) + "        " ) + class_in_comp.getName() ) + "_extent = new " ) + class_set.getName() ) + "Impl();";
            instance_adds = ( ( ( ( ( ( ( ( ( instance_adds + separator ) + "        " ) + test ) + " ( instance instanceof " ) + class_in_comp.getName() ) + " ) return " ) + class_in_comp.getName() ) + "_extent.add( (" ) + class_in_comp.getName() ) + ")instance );";
            instance_removes = ( ( ( ( ( ( ( ( ( instance_removes + separator ) + "        " ) + test ) + " ( instance instanceof " ) + class_in_comp.getName() ) + " ) return " ) + class_in_comp.getName() ) + "_extent.remove( (" ) + class_in_comp.getName() ) + ")instance );";
            class_directory = ( ( ( ( ( ( ( class_directory + separator ) + "        classDirectory.put(" ) + context().STRING().quote() ) + class_in_comp.getKey_letters() ) + context().STRING().quote() ) + ", " ) + class_in_comp.getName() ) + "Impl.class);";
            test = "else if";
            separator = "\n";
        }
        String relationship_extent_initializers = "";
        separator = "";
        test = "if";
        ClassRelationshipSet relationships = self().R448_maintains_instances_of_ClassRelationship();
        ClassRelationship rel;
        for ( Iterator<ClassRelationship> _rel_iter = relationships.elements().iterator(); _rel_iter.hasNext(); ) {
            rel = _rel_iter.next();
            relationship_extent_initializers = ( ( ( relationship_extent_initializers + separator ) + "        " ) + rel.getName() ) + "_extent = new RelationshipSet();";
            separator = "\n";
        }
        FunctionSet funcs = self().R405_provides_synchronous_Function();
        Function function;
        for ( Iterator<Function> _function_iter = funcs.elements().iterator(); _function_iter.hasNext(); ) {
            function = _function_iter.next();
            function.render();
        }
        String functions = context().T().body();
        context().T().clear();
        for ( Iterator<ClassRelationship> _rel_iter = relationships.elements().iterator(); _rel_iter.hasNext(); ) {
            rel = _rel_iter.next();
            rel.render_modifiers();
        }
        String relationship_modifiers = context().T().body();
        context().T().clear();
        InstancePopulationSelectorSet instance_selects = self().R447_selects_instances_through_InstancePopulationSelector();
        InstancePopulationSelector instance_selector;
        for ( Iterator<InstancePopulationSelector> _instance_selector_iter = instance_selects.elements().iterator(); _instance_selector_iter.hasNext(); ) {
            instance_selector = _instance_selector_iter.next();
            instance_selector.render();
        }
        String instance_selectors = context().T().body();
        context().T().clear();
        RelationshipPopulationSelectorSet relationship_selects = self().R4571_selects_relationships_through_RelationshipPopulationSelector();
        RelationshipPopulationSelector relationship_selector;
        for ( Iterator<RelationshipPopulationSelector> _relationship_selector_iter = relationship_selects.elements().iterator(); _relationship_selector_iter.hasNext(); ) {
            relationship_selector = _relationship_selector_iter.next();
            relationship_selector.render();
        }
        String relationship_selectors = context().T().body();
        context().T().clear();
        PortSet comp_ports = self().R417_communicates_through_Port();
        Port port;
        for ( Iterator<Port> _port_iter = comp_ports.elements().iterator(); _port_iter.hasNext(); ) {
            port = _port_iter.next();
            port.render_acccessor();
        }
        String ports = context().T().body();
        context().T().clear();
        String utility_initializers = "";
        separator = "";
        UtilityReferenceSet util_refs = self().R4558_contains_UtilityReference();
        UtilityReference util_ref;
        for ( Iterator<UtilityReference> _util_ref_iter = util_refs.elements().iterator(); _util_ref_iter.hasNext(); ) {
            util_ref = _util_ref_iter.next();
            util_ref.render();
            utility_initializers = ( ( ( utility_initializers + separator ) + "        " ) + util_ref.getUtility_name() ) + " = null;";
            separator = "\n";
        }
        String utilities = context().T().body();
        context().T().clear();
        String init = "";
        Function init_function = self().R4561_initialized_by_Function();
        if ( !init_function.isEmpty() ) {
            init = ( "        " + init_function.getName() ) + "();";
        }
        context().T().include( "component/t.componentdefinition.java", class_directory, functions, imports, init, instance_adds, instance_extent_initializers, instance_removes, instance_selectors, ports, relationship_extent_initializers, relationship_modifiers, relationship_selectors, self(), utilities, utility_initializers );
        context().T().emit( ( ( file.getPath() + "/" ) + self().getName() ) + file.getExtension() );
        context().T().clear();
    }

    @Override
    public void render_version() throws XtumlException {
        context().T().include( "component/t.version.properties", self() );
    }



    // static operations


    // events


    // selections
    private File R401_is_a_File_inst;
    @Override
    public void setR401_is_a_File( File inst ) {
        R401_is_a_File_inst = inst;
    }
    @Override
    public File R401_is_a_File() throws XtumlException {
        return R401_is_a_File_inst;
    }
    private FunctionSet R405_provides_synchronous_Function_set;
    @Override
    public void addR405_provides_synchronous_Function( Function inst ) {
        R405_provides_synchronous_Function_set.add(inst);
    }
    @Override
    public void removeR405_provides_synchronous_Function( Function inst ) {
        R405_provides_synchronous_Function_set.remove(inst);
    }
    @Override
    public FunctionSet R405_provides_synchronous_Function() throws XtumlException {
        return R405_provides_synchronous_Function_set;
    }
    private ModelInstSet R408_maintains_instances_of_ModelInst_set;
    @Override
    public void addR408_maintains_instances_of_ModelInst( ModelInst inst ) {
        R408_maintains_instances_of_ModelInst_set.add(inst);
    }
    @Override
    public void removeR408_maintains_instances_of_ModelInst( ModelInst inst ) {
        R408_maintains_instances_of_ModelInst_set.remove(inst);
    }
    @Override
    public ModelInstSet R408_maintains_instances_of_ModelInst() throws XtumlException {
        return R408_maintains_instances_of_ModelInst_set;
    }
    private PortSet R417_communicates_through_Port_set;
    @Override
    public void addR417_communicates_through_Port( Port inst ) {
        R417_communicates_through_Port_set.add(inst);
    }
    @Override
    public void removeR417_communicates_through_Port( Port inst ) {
        R417_communicates_through_Port_set.remove(inst);
    }
    @Override
    public PortSet R417_communicates_through_Port() throws XtumlException {
        return R417_communicates_through_Port_set;
    }
    private ComponentInstantiationSet R426_is_instantiated_by_ComponentInstantiation_set;
    @Override
    public void addR426_is_instantiated_by_ComponentInstantiation( ComponentInstantiation inst ) {
        R426_is_instantiated_by_ComponentInstantiation_set.add(inst);
    }
    @Override
    public void removeR426_is_instantiated_by_ComponentInstantiation( ComponentInstantiation inst ) {
        R426_is_instantiated_by_ComponentInstantiation_set.remove(inst);
    }
    @Override
    public ComponentInstantiationSet R426_is_instantiated_by_ComponentInstantiation() throws XtumlException {
        return R426_is_instantiated_by_ComponentInstantiation_set;
    }
    private InstancePopulationSelectorSet R447_selects_instances_through_InstancePopulationSelector_set;
    @Override
    public void addR447_selects_instances_through_InstancePopulationSelector( InstancePopulationSelector inst ) {
        R447_selects_instances_through_InstancePopulationSelector_set.add(inst);
    }
    @Override
    public void removeR447_selects_instances_through_InstancePopulationSelector( InstancePopulationSelector inst ) {
        R447_selects_instances_through_InstancePopulationSelector_set.remove(inst);
    }
    @Override
    public InstancePopulationSelectorSet R447_selects_instances_through_InstancePopulationSelector() throws XtumlException {
        return R447_selects_instances_through_InstancePopulationSelector_set;
    }
    private ClassRelationshipSet R448_maintains_instances_of_ClassRelationship_set;
    @Override
    public void addR448_maintains_instances_of_ClassRelationship( ClassRelationship inst ) {
        R448_maintains_instances_of_ClassRelationship_set.add(inst);
    }
    @Override
    public void removeR448_maintains_instances_of_ClassRelationship( ClassRelationship inst ) {
        R448_maintains_instances_of_ClassRelationship_set.remove(inst);
    }
    @Override
    public ClassRelationshipSet R448_maintains_instances_of_ClassRelationship() throws XtumlException {
        return R448_maintains_instances_of_ClassRelationship_set;
    }
    private UtilityReferenceSet R4558_contains_UtilityReference_set;
    @Override
    public void addR4558_contains_UtilityReference( UtilityReference inst ) {
        R4558_contains_UtilityReference_set.add(inst);
    }
    @Override
    public void removeR4558_contains_UtilityReference( UtilityReference inst ) {
        R4558_contains_UtilityReference_set.remove(inst);
    }
    @Override
    public UtilityReferenceSet R4558_contains_UtilityReference() throws XtumlException {
        return R4558_contains_UtilityReference_set;
    }
    private Function R4561_initialized_by_Function_inst;
    @Override
    public void setR4561_initialized_by_Function( Function inst ) {
        R4561_initialized_by_Function_inst = inst;
    }
    @Override
    public Function R4561_initialized_by_Function() throws XtumlException {
        return R4561_initialized_by_Function_inst;
    }
    private RelationshipPopulationSelectorSet R4571_selects_relationships_through_RelationshipPopulationSelector_set;
    @Override
    public void addR4571_selects_relationships_through_RelationshipPopulationSelector( RelationshipPopulationSelector inst ) {
        R4571_selects_relationships_through_RelationshipPopulationSelector_set.add(inst);
    }
    @Override
    public void removeR4571_selects_relationships_through_RelationshipPopulationSelector( RelationshipPopulationSelector inst ) {
        R4571_selects_relationships_through_RelationshipPopulationSelector_set.remove(inst);
    }
    @Override
    public RelationshipPopulationSelectorSet R4571_selects_relationships_through_RelationshipPopulationSelector() throws XtumlException {
        return R4571_selects_relationships_through_RelationshipPopulationSelector_set;
    }
    private C_C R4573_is_transformed_from_C_C_inst;
    @Override
    public void setR4573_is_transformed_from_C_C( C_C inst ) {
        R4573_is_transformed_from_C_C_inst = inst;
    }
    @Override
    public C_C R4573_is_transformed_from_C_C() throws XtumlException {
        return R4573_is_transformed_from_C_C_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ComponentDefinition self() {
        return this;
    }

    @Override
    public ComponentDefinition oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_COMPONENTDEFINITION;
    }

}

class EmptyComponentDefinition extends ModelInstance<ComponentDefinition,Sql> implements ComponentDefinition {

    // attributes
    public void setName( String ref_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getPackage() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPackage( String ref_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setInit_function_name( String ref_init_function_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getInit_function_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getExtends() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setExtends( String m_extends ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setC_c_Id( UniqueId ref_c_c_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getC_c_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getVersion() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setVersion( String m_version ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getVersion_date() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setVersion_date( String m_version_date ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_version() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public File R401_is_a_File() {
        return FileImpl.EMPTY_FILE;
    }
    @Override
    public FunctionSet R405_provides_synchronous_Function() {
        return (new FunctionSetImpl());
    }
    @Override
    public ModelInstSet R408_maintains_instances_of_ModelInst() {
        return (new ModelInstSetImpl());
    }
    @Override
    public PortSet R417_communicates_through_Port() {
        return (new PortSetImpl());
    }
    @Override
    public ComponentInstantiationSet R426_is_instantiated_by_ComponentInstantiation() {
        return (new ComponentInstantiationSetImpl());
    }
    @Override
    public InstancePopulationSelectorSet R447_selects_instances_through_InstancePopulationSelector() {
        return (new InstancePopulationSelectorSetImpl());
    }
    @Override
    public ClassRelationshipSet R448_maintains_instances_of_ClassRelationship() {
        return (new ClassRelationshipSetImpl());
    }
    @Override
    public UtilityReferenceSet R4558_contains_UtilityReference() {
        return (new UtilityReferenceSetImpl());
    }
    @Override
    public Function R4561_initialized_by_Function() {
        return FunctionImpl.EMPTY_FUNCTION;
    }
    @Override
    public RelationshipPopulationSelectorSet R4571_selects_relationships_through_RelationshipPopulationSelector() {
        return (new RelationshipPopulationSelectorSetImpl());
    }
    @Override
    public C_C R4573_is_transformed_from_C_C() {
        return C_CImpl.EMPTY_C_C;
    }


    @Override
    public String getKeyLetters() {
        return ComponentDefinitionImpl.KEY_LETTERS;
    }

    @Override
    public ComponentDefinition self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ComponentDefinition oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ComponentDefinitionImpl.EMPTY_COMPONENTDEFINITION;
    }

}
