package types;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;

import java.util.regex.Matcher;
import java.util.regex.Pattern;


public enum AttributeAccessorType implements IXtumlType {

    UNINITIALIZED_ENUM( -1 ),
    GETTER( 0 ),
    SETTER( 1 );

    private final int value;

    AttributeAccessorType() {
        value = -1;
    }

    AttributeAccessorType( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( IXtumlType value ) throws XtumlException {
        if (value instanceof AttributeAccessorType) {
            return null != value && this.value == ((AttributeAccessorType)value).getValue();
        }
        else return false;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static AttributeAccessorType deserialize(Object o) throws XtumlException {
        if (o instanceof AttributeAccessorType) {
            return (AttributeAccessorType)o;
        }
        else if (o instanceof Integer) {
            return valueOf((int)o);
        }
        else if (o instanceof String) {
            try {
                return valueOf(Integer.parseInt((String)o));
            }
            catch (NumberFormatException e1) {
                Matcher m = Pattern.compile("([A-Za-z_]+)::([A-Za-z_]+)").matcher((String)o);
                if (m.matches() && "attributeaccessortype".equals(m.group(1).toLowerCase())) {
                    try {
                        return Enum.valueOf(AttributeAccessorType.class, m.group(2).toUpperCase());
                    } catch (IllegalArgumentException e2) {/* do nothing */}
                }
            }
        }
        throw new XtumlException("Cannot deserialize value");
    }

    public static AttributeAccessorType valueOf(int value) {
        switch( value ) {
        case 0:
            return GETTER;
        case 1:
            return SETTER;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
