package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;

import java.util.regex.Matcher;
import java.util.regex.Pattern;


public enum Visibility implements IXtumlType {

    UNINITIALIZED_ENUM( -1 ),
    PRIVATE( 0 ),
    PROTECTED( 2 ),
    PUBLIC( 1 );

    private final int value;

    Visibility() {
        value = -1;
    }

    Visibility( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( IXtumlType value ) throws XtumlException {
        if (value instanceof Visibility) {
            return null != value && this.value == ((Visibility)value).getValue();
        }
        else return false;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static Visibility deserialize(Object o) throws XtumlException {
        if (o instanceof Visibility) {
            return (Visibility)o;
        }
        else if (o instanceof Integer) {
            return valueOf((int)o);
        }
        else if (o instanceof String) {
            try {
                return valueOf(Integer.parseInt((String)o));
            }
            catch (NumberFormatException e1) {
                Matcher m = Pattern.compile("([A-Za-z_]+)::([A-Za-z_]+)").matcher((String)o);
                if (m.matches() && "visibility".equals(m.group(1).toLowerCase())) {
                    try {
                        return Enum.valueOf(Visibility.class, m.group(2).toUpperCase());
                    } catch (IllegalArgumentException e2) {/* do nothing */}
                }
            }
        }
        throw new XtumlException("Cannot deserialize value");
    }

    public static Visibility valueOf(int value) {
        switch( value ) {
        case 0:
            return PRIVATE;
        case 2:
            return PROTECTED;
        case 1:
            return PUBLIC;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
