package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;

import java.util.regex.Matcher;
import java.util.regex.Pattern;


public enum IFDirectionType implements IXtumlType {

    UNINITIALIZED_ENUM( -1 ),
    CLIENTSERVER( 0 ),
    SERVERCLIENT( 1 );

    private final int value;

    IFDirectionType() {
        value = -1;
    }

    IFDirectionType( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( IXtumlType value ) throws XtumlException {
        if (value instanceof IFDirectionType) {
            return null != value && this.value == ((IFDirectionType)value).getValue();
        }
        else return false;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static IFDirectionType deserialize(Object o) throws XtumlException {
        if (o instanceof IFDirectionType) {
            return (IFDirectionType)o;
        }
        else if (o instanceof Integer) {
            return valueOf((int)o);
        }
        else if (o instanceof String) {
            try {
                return valueOf(Integer.parseInt((String)o));
            }
            catch (NumberFormatException e1) {
                Matcher m = Pattern.compile("([A-Za-z_]+)::([A-Za-z_]+)").matcher((String)o);
                if (m.matches() && "ifdirectiontype".equals(m.group(1).toLowerCase())) {
                    try {
                        return Enum.valueOf(IFDirectionType.class, m.group(2).toUpperCase());
                    } catch (IllegalArgumentException e2) {/* do nothing */}
                }
            }
        }
        throw new XtumlException("Cannot deserialize value");
    }

    public static IFDirectionType valueOf(int value) {
        switch( value ) {
        case 0:
            return CLIENTSERVER;
        case 1:
            return SERVERCLIENT;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
