package io.ciera.tool.sql.ooaofooa.statemachine.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.statemachine.State;
import io.ciera.tool.sql.architecture.statemachine.impl.StateImpl;
import io.ciera.tool.sql.ooaofooa.instance.I_INS;
import io.ciera.tool.sql.ooaofooa.instance.I_INSSet;
import io.ciera.tool.sql.ooaofooa.instance.impl.I_INSSetImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.MooreActionHome;
import io.ciera.tool.sql.ooaofooa.statemachine.NoEventTransition;
import io.ciera.tool.sql.ooaofooa.statemachine.NoEventTransitionSet;
import io.ciera.tool.sql.ooaofooa.statemachine.SM_SM;
import io.ciera.tool.sql.ooaofooa.statemachine.StateEventMatrixEntry;
import io.ciera.tool.sql.ooaofooa.statemachine.StateEventMatrixEntrySet;
import io.ciera.tool.sql.ooaofooa.statemachine.StateMachineState;
import io.ciera.tool.sql.ooaofooa.statemachine.Transition;
import io.ciera.tool.sql.ooaofooa.statemachine.TransitionSet;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.MooreActionHomeImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.NoEventTransitionSetImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.SM_SMImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.StateEventMatrixEntrySetImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.TransitionSetImpl;


public class StateMachineStateImpl extends ModelInstance<StateMachineState,Sql> implements StateMachineState {

    public static final String KEY_LETTERS = "SM_STATE";
    public static final StateMachineState EMPTY_STATEMACHINESTATE = new EmptyStateMachineState();

    private Sql context;

    // constructors
    private StateMachineStateImpl( Sql context ) {
        this.context = context;
        m_SMstt_ID = UniqueId.random();
        ref_SM_ID = UniqueId.random();
        m_SMspd_IDdeprecated = UniqueId.random();
        m_Name = "";
        m_Numb = 0;
        m_Final = 0;
        R2915_defines_state_of_I_INS_set = new I_INSSetImpl();
        R4758_is_transformed_from_State_inst = StateImpl.EMPTY_STATE;
        R501_SM_SM_inst = SM_SMImpl.EMPTY_SM_SM;
        R503_receives_StateEventMatrixEntry_set = new StateEventMatrixEntrySetImpl();
        R506_is_destination_of_Transition_set = new TransitionSetImpl();
        R508_is_origination_of_NoEventTransition_set = new NoEventTransitionSetImpl();
        R511_MooreActionHome_inst = MooreActionHomeImpl.EMPTY_MOOREACTIONHOME;
    }

    private StateMachineStateImpl( Sql context, UniqueId instanceId, UniqueId m_SMstt_ID, UniqueId ref_SM_ID, UniqueId m_SMspd_IDdeprecated, String m_Name, int m_Numb, int m_Final ) {
        super(instanceId);
        this.context = context;
        this.m_SMstt_ID = m_SMstt_ID;
        this.ref_SM_ID = ref_SM_ID;
        this.m_SMspd_IDdeprecated = m_SMspd_IDdeprecated;
        this.m_Name = m_Name;
        this.m_Numb = m_Numb;
        this.m_Final = m_Final;
        R2915_defines_state_of_I_INS_set = new I_INSSetImpl();
        R4758_is_transformed_from_State_inst = StateImpl.EMPTY_STATE;
        R501_SM_SM_inst = SM_SMImpl.EMPTY_SM_SM;
        R503_receives_StateEventMatrixEntry_set = new StateEventMatrixEntrySetImpl();
        R506_is_destination_of_Transition_set = new TransitionSetImpl();
        R508_is_origination_of_NoEventTransition_set = new NoEventTransitionSetImpl();
        R511_MooreActionHome_inst = MooreActionHomeImpl.EMPTY_MOOREACTIONHOME;
    }

    public static StateMachineState create( Sql context ) throws XtumlException {
        StateMachineState newStateMachineState = new StateMachineStateImpl( context );
        if ( context.addInstance( newStateMachineState ) ) {
            newStateMachineState.getRunContext().addChange(new InstanceCreatedDelta(newStateMachineState, KEY_LETTERS));
            return newStateMachineState;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static StateMachineState create( Sql context, UniqueId instanceId, UniqueId m_SMstt_ID, UniqueId ref_SM_ID, UniqueId m_SMspd_IDdeprecated, String m_Name, int m_Numb, int m_Final ) throws XtumlException {
        StateMachineState newStateMachineState = new StateMachineStateImpl( context, instanceId, m_SMstt_ID, ref_SM_ID, m_SMspd_IDdeprecated, m_Name, m_Numb, m_Final );
        if ( context.addInstance( newStateMachineState ) ) {
            return newStateMachineState;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_SMstt_ID;
    @Override
    public UniqueId getSMstt_ID() throws XtumlException {
        checkLiving();
        return m_SMstt_ID;
    }
    @Override
    public void setSMstt_ID(UniqueId m_SMstt_ID) throws XtumlException {
        checkLiving();
        if (m_SMstt_ID.inequality( this.m_SMstt_ID)) {
            final UniqueId oldValue = this.m_SMstt_ID;
            this.m_SMstt_ID = m_SMstt_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_SMstt_ID", oldValue, this.m_SMstt_ID));
            if ( !R2915_defines_state_of_I_INS().isEmpty() ) R2915_defines_state_of_I_INS().setSMstt_ID( m_SMstt_ID );
            if ( !R503_receives_StateEventMatrixEntry().isEmpty() ) R503_receives_StateEventMatrixEntry().setSMstt_ID( m_SMstt_ID );
            if ( !R4758_is_transformed_from_State().isEmpty() ) R4758_is_transformed_from_State().setSMstt_ID( m_SMstt_ID );
            if ( !R511_MooreActionHome().isEmpty() ) R511_MooreActionHome().setSMstt_ID( m_SMstt_ID );
            if ( !R506_is_destination_of_Transition().isEmpty() ) R506_is_destination_of_Transition().setSMstt_ID( m_SMstt_ID );
            if ( !R508_is_origination_of_NoEventTransition().isEmpty() ) R508_is_origination_of_NoEventTransition().setSMstt_ID( m_SMstt_ID );
        }
    }
    private UniqueId ref_SM_ID;
    @Override
    public UniqueId getSM_ID() throws XtumlException {
        checkLiving();
        return ref_SM_ID;
    }
    @Override
    public void setSM_ID(UniqueId ref_SM_ID) throws XtumlException {
        checkLiving();
        if (ref_SM_ID.inequality( this.ref_SM_ID)) {
            final UniqueId oldValue = this.ref_SM_ID;
            this.ref_SM_ID = ref_SM_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SM_ID", oldValue, this.ref_SM_ID));
            if ( !R508_is_origination_of_NoEventTransition().isEmpty() ) R508_is_origination_of_NoEventTransition().setSM_ID( ref_SM_ID );
            if ( !R506_is_destination_of_Transition().isEmpty() ) R506_is_destination_of_Transition().setSM_ID( ref_SM_ID );
            if ( !R511_MooreActionHome().isEmpty() ) R511_MooreActionHome().setSM_ID( ref_SM_ID );
            if ( !R4758_is_transformed_from_State().isEmpty() ) R4758_is_transformed_from_State().setSM_ID( ref_SM_ID );
            if ( !R2915_defines_state_of_I_INS().isEmpty() ) R2915_defines_state_of_I_INS().setSM_ID( ref_SM_ID );
            if ( !R503_receives_StateEventMatrixEntry().isEmpty() ) R503_receives_StateEventMatrixEntry().setSM_ID( ref_SM_ID );
        }
    }
    private UniqueId m_SMspd_IDdeprecated;
    @Override
    public void setSMspd_IDdeprecated(UniqueId m_SMspd_IDdeprecated) throws XtumlException {
        checkLiving();
        if (m_SMspd_IDdeprecated.inequality( this.m_SMspd_IDdeprecated)) {
            final UniqueId oldValue = this.m_SMspd_IDdeprecated;
            this.m_SMspd_IDdeprecated = m_SMspd_IDdeprecated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_SMspd_IDdeprecated", oldValue, this.m_SMspd_IDdeprecated));
        }
    }
    @Override
    public UniqueId getSMspd_IDdeprecated() throws XtumlException {
        checkLiving();
        return m_SMspd_IDdeprecated;
    }
    private String m_Name;
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    private int m_Numb;
    @Override
    public void setNumb(int m_Numb) throws XtumlException {
        checkLiving();
        if (m_Numb != this.m_Numb) {
            final int oldValue = this.m_Numb;
            this.m_Numb = m_Numb;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Numb", oldValue, this.m_Numb));
        }
    }
    @Override
    public int getNumb() throws XtumlException {
        checkLiving();
        return m_Numb;
    }
    private int m_Final;
    @Override
    public void setFinal(int m_Final) throws XtumlException {
        checkLiving();
        if (m_Final != this.m_Final) {
            final int oldValue = this.m_Final;
            this.m_Final = m_Final;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Final", oldValue, this.m_Final));
        }
    }
    @Override
    public int getFinal() throws XtumlException {
        checkLiving();
        return m_Final;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSMstt_ID(), getSM_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }
    @Override
    public IInstanceIdentifier getId2() {
        try {
            return new InstanceIdentifier(getSMstt_ID(), getSM_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private I_INSSet R2915_defines_state_of_I_INS_set;
    @Override
    public void addR2915_defines_state_of_I_INS( I_INS inst ) {
        R2915_defines_state_of_I_INS_set.add(inst);
    }
    @Override
    public void removeR2915_defines_state_of_I_INS( I_INS inst ) {
        R2915_defines_state_of_I_INS_set.remove(inst);
    }
    @Override
    public I_INSSet R2915_defines_state_of_I_INS() throws XtumlException {
        return R2915_defines_state_of_I_INS_set;
    }
    private State R4758_is_transformed_from_State_inst;
    @Override
    public void setR4758_is_transformed_from_State( State inst ) {
        R4758_is_transformed_from_State_inst = inst;
    }
    @Override
    public State R4758_is_transformed_from_State() throws XtumlException {
        return R4758_is_transformed_from_State_inst;
    }
    private SM_SM R501_SM_SM_inst;
    @Override
    public void setR501_SM_SM( SM_SM inst ) {
        R501_SM_SM_inst = inst;
    }
    @Override
    public SM_SM R501_SM_SM() throws XtumlException {
        return R501_SM_SM_inst;
    }
    private StateEventMatrixEntrySet R503_receives_StateEventMatrixEntry_set;
    @Override
    public void addR503_receives_StateEventMatrixEntry( StateEventMatrixEntry inst ) {
        R503_receives_StateEventMatrixEntry_set.add(inst);
    }
    @Override
    public void removeR503_receives_StateEventMatrixEntry( StateEventMatrixEntry inst ) {
        R503_receives_StateEventMatrixEntry_set.remove(inst);
    }
    @Override
    public StateEventMatrixEntrySet R503_receives_StateEventMatrixEntry() throws XtumlException {
        return R503_receives_StateEventMatrixEntry_set;
    }
    private TransitionSet R506_is_destination_of_Transition_set;
    @Override
    public void addR506_is_destination_of_Transition( Transition inst ) {
        R506_is_destination_of_Transition_set.add(inst);
    }
    @Override
    public void removeR506_is_destination_of_Transition( Transition inst ) {
        R506_is_destination_of_Transition_set.remove(inst);
    }
    @Override
    public TransitionSet R506_is_destination_of_Transition() throws XtumlException {
        return R506_is_destination_of_Transition_set;
    }
    private NoEventTransitionSet R508_is_origination_of_NoEventTransition_set;
    @Override
    public void addR508_is_origination_of_NoEventTransition( NoEventTransition inst ) {
        R508_is_origination_of_NoEventTransition_set.add(inst);
    }
    @Override
    public void removeR508_is_origination_of_NoEventTransition( NoEventTransition inst ) {
        R508_is_origination_of_NoEventTransition_set.remove(inst);
    }
    @Override
    public NoEventTransitionSet R508_is_origination_of_NoEventTransition() throws XtumlException {
        return R508_is_origination_of_NoEventTransition_set;
    }
    private MooreActionHome R511_MooreActionHome_inst;
    @Override
    public void setR511_MooreActionHome( MooreActionHome inst ) {
        R511_MooreActionHome_inst = inst;
    }
    @Override
    public MooreActionHome R511_MooreActionHome() throws XtumlException {
        return R511_MooreActionHome_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public StateMachineState self() {
        return this;
    }

    @Override
    public StateMachineState oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_STATEMACHINESTATE;
    }

}

class EmptyStateMachineState extends ModelInstance<StateMachineState,Sql> implements StateMachineState {

    // attributes
    public UniqueId getSMstt_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSMstt_ID( UniqueId m_SMstt_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSM_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSMspd_IDdeprecated( UniqueId m_SMspd_IDdeprecated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSMspd_IDdeprecated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setNumb( int m_Numb ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getNumb() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setFinal( int m_Final ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getFinal() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public I_INSSet R2915_defines_state_of_I_INS() {
        return (new I_INSSetImpl());
    }
    @Override
    public State R4758_is_transformed_from_State() {
        return StateImpl.EMPTY_STATE;
    }
    @Override
    public SM_SM R501_SM_SM() {
        return SM_SMImpl.EMPTY_SM_SM;
    }
    @Override
    public StateEventMatrixEntrySet R503_receives_StateEventMatrixEntry() {
        return (new StateEventMatrixEntrySetImpl());
    }
    @Override
    public TransitionSet R506_is_destination_of_Transition() {
        return (new TransitionSetImpl());
    }
    @Override
    public NoEventTransitionSet R508_is_origination_of_NoEventTransition() {
        return (new NoEventTransitionSetImpl());
    }
    @Override
    public MooreActionHome R511_MooreActionHome() {
        return MooreActionHomeImpl.EMPTY_MOOREACTIONHOME;
    }


    @Override
    public String getKeyLetters() {
        return StateMachineStateImpl.KEY_LETTERS;
    }

    @Override
    public StateMachineState self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public StateMachineState oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return StateMachineStateImpl.EMPTY_STATEMACHINESTATE;
    }

}
