package io.ciera.tool.sql.ooaofooa.statemachine.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.statemachine.LocalEvent;
import io.ciera.tool.sql.ooaofooa.statemachine.NonLocalEvent;
import io.ciera.tool.sql.ooaofooa.statemachine.SEMEvent;
import io.ciera.tool.sql.ooaofooa.statemachine.SignalEvent;
import io.ciera.tool.sql.ooaofooa.statemachine.StateEventMatrixEntry;
import io.ciera.tool.sql.ooaofooa.statemachine.StateEventMatrixEntrySet;
import io.ciera.tool.sql.ooaofooa.statemachine.StateMachineEvent;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.LocalEventImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.NonLocalEventImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.SignalEventImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.StateEventMatrixEntrySetImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.StateMachineEventImpl;


public class SEMEventImpl extends ModelInstance<SEMEvent,Sql> implements SEMEvent {

    public static final String KEY_LETTERS = "SM_SEVT";
    public static final SEMEvent EMPTY_SEMEVENT = new EmptySEMEvent();

    private Sql context;

    // constructors
    private SEMEventImpl( Sql context ) {
        this.context = context;
        ref_SMevt_ID = UniqueId.random();
        ref_SM_ID = UniqueId.random();
        m_SMspd_IDdeprecated = UniqueId.random();
        R503_is_received_by_StateEventMatrixEntry_set = new StateEventMatrixEntrySetImpl();
        R525_is_a_StateMachineEvent_inst = StateMachineEventImpl.EMPTY_STATEMACHINEEVENT;
        R526_is_a_LocalEvent_inst = LocalEventImpl.EMPTY_LOCALEVENT;
        R526_is_a_NonLocalEvent_inst = NonLocalEventImpl.EMPTY_NONLOCALEVENT;
        R526_is_a_SignalEvent_inst = SignalEventImpl.EMPTY_SIGNALEVENT;
    }

    private SEMEventImpl( Sql context, UniqueId instanceId, UniqueId ref_SMevt_ID, UniqueId ref_SM_ID, UniqueId m_SMspd_IDdeprecated ) {
        super(instanceId);
        this.context = context;
        this.ref_SMevt_ID = ref_SMevt_ID;
        this.ref_SM_ID = ref_SM_ID;
        this.m_SMspd_IDdeprecated = m_SMspd_IDdeprecated;
        R503_is_received_by_StateEventMatrixEntry_set = new StateEventMatrixEntrySetImpl();
        R525_is_a_StateMachineEvent_inst = StateMachineEventImpl.EMPTY_STATEMACHINEEVENT;
        R526_is_a_LocalEvent_inst = LocalEventImpl.EMPTY_LOCALEVENT;
        R526_is_a_NonLocalEvent_inst = NonLocalEventImpl.EMPTY_NONLOCALEVENT;
        R526_is_a_SignalEvent_inst = SignalEventImpl.EMPTY_SIGNALEVENT;
    }

    public static SEMEvent create( Sql context ) throws XtumlException {
        SEMEvent newSEMEvent = new SEMEventImpl( context );
        if ( context.addInstance( newSEMEvent ) ) {
            newSEMEvent.getRunContext().addChange(new InstanceCreatedDelta(newSEMEvent, KEY_LETTERS));
            return newSEMEvent;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static SEMEvent create( Sql context, UniqueId instanceId, UniqueId ref_SMevt_ID, UniqueId ref_SM_ID, UniqueId m_SMspd_IDdeprecated ) throws XtumlException {
        SEMEvent newSEMEvent = new SEMEventImpl( context, instanceId, ref_SMevt_ID, ref_SM_ID, m_SMspd_IDdeprecated );
        if ( context.addInstance( newSEMEvent ) ) {
            return newSEMEvent;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_SMevt_ID;
    @Override
    public UniqueId getSMevt_ID() throws XtumlException {
        checkLiving();
        return ref_SMevt_ID;
    }
    @Override
    public void setSMevt_ID(UniqueId ref_SMevt_ID) throws XtumlException {
        checkLiving();
        if (ref_SMevt_ID.inequality( this.ref_SMevt_ID)) {
            final UniqueId oldValue = this.ref_SMevt_ID;
            this.ref_SMevt_ID = ref_SMevt_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SMevt_ID", oldValue, this.ref_SMevt_ID));
            if ( !R526_is_a_SignalEvent().isEmpty() ) R526_is_a_SignalEvent().setSMevt_ID( ref_SMevt_ID );
            if ( !R526_is_a_LocalEvent().isEmpty() ) R526_is_a_LocalEvent().setSMevt_ID( ref_SMevt_ID );
            if ( !R503_is_received_by_StateEventMatrixEntry().isEmpty() ) R503_is_received_by_StateEventMatrixEntry().setSMevt_ID( ref_SMevt_ID );
            if ( !R526_is_a_NonLocalEvent().isEmpty() ) R526_is_a_NonLocalEvent().setSMevt_ID( ref_SMevt_ID );
        }
    }
    private UniqueId ref_SM_ID;
    @Override
    public void setSM_ID(UniqueId ref_SM_ID) throws XtumlException {
        checkLiving();
        if (ref_SM_ID.inequality( this.ref_SM_ID)) {
            final UniqueId oldValue = this.ref_SM_ID;
            this.ref_SM_ID = ref_SM_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SM_ID", oldValue, this.ref_SM_ID));
            if ( !R526_is_a_SignalEvent().isEmpty() ) R526_is_a_SignalEvent().setSM_ID( ref_SM_ID );
            if ( !R526_is_a_NonLocalEvent().isEmpty() ) R526_is_a_NonLocalEvent().setSM_ID( ref_SM_ID );
            if ( !R526_is_a_LocalEvent().isEmpty() ) R526_is_a_LocalEvent().setSM_ID( ref_SM_ID );
            if ( !R503_is_received_by_StateEventMatrixEntry().isEmpty() ) R503_is_received_by_StateEventMatrixEntry().setSM_ID( ref_SM_ID );
        }
    }
    @Override
    public UniqueId getSM_ID() throws XtumlException {
        checkLiving();
        return ref_SM_ID;
    }
    private UniqueId m_SMspd_IDdeprecated;
    @Override
    public UniqueId getSMspd_IDdeprecated() throws XtumlException {
        checkLiving();
        return m_SMspd_IDdeprecated;
    }
    @Override
    public void setSMspd_IDdeprecated(UniqueId m_SMspd_IDdeprecated) throws XtumlException {
        checkLiving();
        if (m_SMspd_IDdeprecated.inequality( this.m_SMspd_IDdeprecated)) {
            final UniqueId oldValue = this.m_SMspd_IDdeprecated;
            this.m_SMspd_IDdeprecated = m_SMspd_IDdeprecated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_SMspd_IDdeprecated", oldValue, this.m_SMspd_IDdeprecated));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSMevt_ID(), getSM_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private StateEventMatrixEntrySet R503_is_received_by_StateEventMatrixEntry_set;
    @Override
    public void addR503_is_received_by_StateEventMatrixEntry( StateEventMatrixEntry inst ) {
        R503_is_received_by_StateEventMatrixEntry_set.add(inst);
    }
    @Override
    public void removeR503_is_received_by_StateEventMatrixEntry( StateEventMatrixEntry inst ) {
        R503_is_received_by_StateEventMatrixEntry_set.remove(inst);
    }
    @Override
    public StateEventMatrixEntrySet R503_is_received_by_StateEventMatrixEntry() throws XtumlException {
        return R503_is_received_by_StateEventMatrixEntry_set;
    }
    private StateMachineEvent R525_is_a_StateMachineEvent_inst;
    @Override
    public void setR525_is_a_StateMachineEvent( StateMachineEvent inst ) {
        R525_is_a_StateMachineEvent_inst = inst;
    }
    @Override
    public StateMachineEvent R525_is_a_StateMachineEvent() throws XtumlException {
        return R525_is_a_StateMachineEvent_inst;
    }
    private LocalEvent R526_is_a_LocalEvent_inst;
    @Override
    public void setR526_is_a_LocalEvent( LocalEvent inst ) {
        R526_is_a_LocalEvent_inst = inst;
    }
    @Override
    public LocalEvent R526_is_a_LocalEvent() throws XtumlException {
        return R526_is_a_LocalEvent_inst;
    }
    private NonLocalEvent R526_is_a_NonLocalEvent_inst;
    @Override
    public void setR526_is_a_NonLocalEvent( NonLocalEvent inst ) {
        R526_is_a_NonLocalEvent_inst = inst;
    }
    @Override
    public NonLocalEvent R526_is_a_NonLocalEvent() throws XtumlException {
        return R526_is_a_NonLocalEvent_inst;
    }
    private SignalEvent R526_is_a_SignalEvent_inst;
    @Override
    public void setR526_is_a_SignalEvent( SignalEvent inst ) {
        R526_is_a_SignalEvent_inst = inst;
    }
    @Override
    public SignalEvent R526_is_a_SignalEvent() throws XtumlException {
        return R526_is_a_SignalEvent_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public SEMEvent self() {
        return this;
    }

    @Override
    public SEMEvent oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_SEMEVENT;
    }

}

class EmptySEMEvent extends ModelInstance<SEMEvent,Sql> implements SEMEvent {

    // attributes
    public UniqueId getSMevt_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSMevt_ID( UniqueId ref_SMevt_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSM_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getSMspd_IDdeprecated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSMspd_IDdeprecated( UniqueId m_SMspd_IDdeprecated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public StateEventMatrixEntrySet R503_is_received_by_StateEventMatrixEntry() {
        return (new StateEventMatrixEntrySetImpl());
    }
    @Override
    public StateMachineEvent R525_is_a_StateMachineEvent() {
        return StateMachineEventImpl.EMPTY_STATEMACHINEEVENT;
    }
    @Override
    public LocalEvent R526_is_a_LocalEvent() {
        return LocalEventImpl.EMPTY_LOCALEVENT;
    }
    @Override
    public NonLocalEvent R526_is_a_NonLocalEvent() {
        return NonLocalEventImpl.EMPTY_NONLOCALEVENT;
    }
    @Override
    public SignalEvent R526_is_a_SignalEvent() {
        return SignalEventImpl.EMPTY_SIGNALEVENT;
    }


    @Override
    public String getKeyLetters() {
        return SEMEventImpl.KEY_LETTERS;
    }

    @Override
    public SEMEvent self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public SEMEvent oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return SEMEventImpl.EMPTY_SEMEVENT;
    }

}
