package io.ciera.tool.sql.ooaofooa.statemachine.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.statemachine.MooreActionHome;
import io.ciera.tool.sql.ooaofooa.statemachine.MooreActionHomeSet;
import io.ciera.tool.sql.ooaofooa.statemachine.MooreStateMachine;
import io.ciera.tool.sql.ooaofooa.statemachine.SM_SM;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.MooreActionHomeSetImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.SM_SMImpl;


public class MooreStateMachineImpl extends ModelInstance<MooreStateMachine,Sql> implements MooreStateMachine {

    public static final String KEY_LETTERS = "SM_MOORE";
    public static final MooreStateMachine EMPTY_MOORESTATEMACHINE = new EmptyMooreStateMachine();

    private Sql context;

    // constructors
    private MooreStateMachineImpl( Sql context ) {
        this.context = context;
        ref_SM_ID = UniqueId.random();
        R510_is_a_SM_SM_inst = SM_SMImpl.EMPTY_SM_SM;
        R511_MooreActionHome_set = new MooreActionHomeSetImpl();
    }

    private MooreStateMachineImpl( Sql context, UniqueId instanceId, UniqueId ref_SM_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_SM_ID = ref_SM_ID;
        R510_is_a_SM_SM_inst = SM_SMImpl.EMPTY_SM_SM;
        R511_MooreActionHome_set = new MooreActionHomeSetImpl();
    }

    public static MooreStateMachine create( Sql context ) throws XtumlException {
        MooreStateMachine newMooreStateMachine = new MooreStateMachineImpl( context );
        if ( context.addInstance( newMooreStateMachine ) ) {
            newMooreStateMachine.getRunContext().addChange(new InstanceCreatedDelta(newMooreStateMachine, KEY_LETTERS));
            return newMooreStateMachine;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static MooreStateMachine create( Sql context, UniqueId instanceId, UniqueId ref_SM_ID ) throws XtumlException {
        MooreStateMachine newMooreStateMachine = new MooreStateMachineImpl( context, instanceId, ref_SM_ID );
        if ( context.addInstance( newMooreStateMachine ) ) {
            return newMooreStateMachine;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_SM_ID;
    @Override
    public UniqueId getSM_ID() throws XtumlException {
        checkLiving();
        return ref_SM_ID;
    }
    @Override
    public void setSM_ID(UniqueId ref_SM_ID) throws XtumlException {
        checkLiving();
        if (ref_SM_ID.inequality( this.ref_SM_ID)) {
            final UniqueId oldValue = this.ref_SM_ID;
            this.ref_SM_ID = ref_SM_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SM_ID", oldValue, this.ref_SM_ID));
            if ( !R511_MooreActionHome().isEmpty() ) R511_MooreActionHome().setSM_ID( ref_SM_ID );
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSM_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private SM_SM R510_is_a_SM_SM_inst;
    @Override
    public void setR510_is_a_SM_SM( SM_SM inst ) {
        R510_is_a_SM_SM_inst = inst;
    }
    @Override
    public SM_SM R510_is_a_SM_SM() throws XtumlException {
        return R510_is_a_SM_SM_inst;
    }
    private MooreActionHomeSet R511_MooreActionHome_set;
    @Override
    public void addR511_MooreActionHome( MooreActionHome inst ) {
        R511_MooreActionHome_set.add(inst);
    }
    @Override
    public void removeR511_MooreActionHome( MooreActionHome inst ) {
        R511_MooreActionHome_set.remove(inst);
    }
    @Override
    public MooreActionHomeSet R511_MooreActionHome() throws XtumlException {
        return R511_MooreActionHome_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public MooreStateMachine self() {
        return this;
    }

    @Override
    public MooreStateMachine oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_MOORESTATEMACHINE;
    }

}

class EmptyMooreStateMachine extends ModelInstance<MooreStateMachine,Sql> implements MooreStateMachine {

    // attributes
    public UniqueId getSM_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public SM_SM R510_is_a_SM_SM() {
        return SM_SMImpl.EMPTY_SM_SM;
    }
    @Override
    public MooreActionHomeSet R511_MooreActionHome() {
        return (new MooreActionHomeSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return MooreStateMachineImpl.KEY_LETTERS;
    }

    @Override
    public MooreStateMachine self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public MooreStateMachine oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return MooreStateMachineImpl.EMPTY_MOORESTATEMACHINE;
    }

}
