package io.ciera.tool.sql.ooaofooa.statemachine.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.statemachine.CreationTransition;
import io.ciera.tool.sql.ooaofooa.statemachine.LocalEvent;
import io.ciera.tool.sql.ooaofooa.statemachine.SEMEvent;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.CreationTransitionImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.SEMEventImpl;


public class LocalEventImpl extends ModelInstance<LocalEvent,Sql> implements LocalEvent {

    public static final String KEY_LETTERS = "SM_LEVT";
    public static final LocalEvent EMPTY_LOCALEVENT = new EmptyLocalEvent();

    private Sql context;

    // constructors
    private LocalEventImpl( Sql context ) {
        this.context = context;
        ref_SMevt_ID = UniqueId.random();
        ref_SM_ID = UniqueId.random();
        m_SMspd_IDdeprecated = UniqueId.random();
        R509_has_assigned_to_it_CreationTransition_inst = CreationTransitionImpl.EMPTY_CREATIONTRANSITION;
        R526_is_a_SEMEvent_inst = SEMEventImpl.EMPTY_SEMEVENT;
    }

    private LocalEventImpl( Sql context, UniqueId instanceId, UniqueId ref_SMevt_ID, UniqueId ref_SM_ID, UniqueId m_SMspd_IDdeprecated ) {
        super(instanceId);
        this.context = context;
        this.ref_SMevt_ID = ref_SMevt_ID;
        this.ref_SM_ID = ref_SM_ID;
        this.m_SMspd_IDdeprecated = m_SMspd_IDdeprecated;
        R509_has_assigned_to_it_CreationTransition_inst = CreationTransitionImpl.EMPTY_CREATIONTRANSITION;
        R526_is_a_SEMEvent_inst = SEMEventImpl.EMPTY_SEMEVENT;
    }

    public static LocalEvent create( Sql context ) throws XtumlException {
        LocalEvent newLocalEvent = new LocalEventImpl( context );
        if ( context.addInstance( newLocalEvent ) ) {
            newLocalEvent.getRunContext().addChange(new InstanceCreatedDelta(newLocalEvent, KEY_LETTERS));
            return newLocalEvent;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static LocalEvent create( Sql context, UniqueId instanceId, UniqueId ref_SMevt_ID, UniqueId ref_SM_ID, UniqueId m_SMspd_IDdeprecated ) throws XtumlException {
        LocalEvent newLocalEvent = new LocalEventImpl( context, instanceId, ref_SMevt_ID, ref_SM_ID, m_SMspd_IDdeprecated );
        if ( context.addInstance( newLocalEvent ) ) {
            return newLocalEvent;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_SMevt_ID;
    @Override
    public UniqueId getSMevt_ID() throws XtumlException {
        checkLiving();
        return ref_SMevt_ID;
    }
    @Override
    public void setSMevt_ID(UniqueId ref_SMevt_ID) throws XtumlException {
        checkLiving();
        if (ref_SMevt_ID.inequality( this.ref_SMevt_ID)) {
            final UniqueId oldValue = this.ref_SMevt_ID;
            this.ref_SMevt_ID = ref_SMevt_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SMevt_ID", oldValue, this.ref_SMevt_ID));
            if ( !R509_has_assigned_to_it_CreationTransition().isEmpty() ) R509_has_assigned_to_it_CreationTransition().setSMevt_ID( ref_SMevt_ID );
        }
    }
    private UniqueId ref_SM_ID;
    @Override
    public UniqueId getSM_ID() throws XtumlException {
        checkLiving();
        return ref_SM_ID;
    }
    @Override
    public void setSM_ID(UniqueId ref_SM_ID) throws XtumlException {
        checkLiving();
        if (ref_SM_ID.inequality( this.ref_SM_ID)) {
            final UniqueId oldValue = this.ref_SM_ID;
            this.ref_SM_ID = ref_SM_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SM_ID", oldValue, this.ref_SM_ID));
            if ( !R509_has_assigned_to_it_CreationTransition().isEmpty() ) R509_has_assigned_to_it_CreationTransition().setSM_ID( ref_SM_ID );
        }
    }
    private UniqueId m_SMspd_IDdeprecated;
    @Override
    public void setSMspd_IDdeprecated(UniqueId m_SMspd_IDdeprecated) throws XtumlException {
        checkLiving();
        if (m_SMspd_IDdeprecated.inequality( this.m_SMspd_IDdeprecated)) {
            final UniqueId oldValue = this.m_SMspd_IDdeprecated;
            this.m_SMspd_IDdeprecated = m_SMspd_IDdeprecated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_SMspd_IDdeprecated", oldValue, this.m_SMspd_IDdeprecated));
        }
    }
    @Override
    public UniqueId getSMspd_IDdeprecated() throws XtumlException {
        checkLiving();
        return m_SMspd_IDdeprecated;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSMevt_ID(), getSM_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private CreationTransition R509_has_assigned_to_it_CreationTransition_inst;
    @Override
    public void setR509_has_assigned_to_it_CreationTransition( CreationTransition inst ) {
        R509_has_assigned_to_it_CreationTransition_inst = inst;
    }
    @Override
    public CreationTransition R509_has_assigned_to_it_CreationTransition() throws XtumlException {
        return R509_has_assigned_to_it_CreationTransition_inst;
    }
    private SEMEvent R526_is_a_SEMEvent_inst;
    @Override
    public void setR526_is_a_SEMEvent( SEMEvent inst ) {
        R526_is_a_SEMEvent_inst = inst;
    }
    @Override
    public SEMEvent R526_is_a_SEMEvent() throws XtumlException {
        return R526_is_a_SEMEvent_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public LocalEvent self() {
        return this;
    }

    @Override
    public LocalEvent oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_LOCALEVENT;
    }

}

class EmptyLocalEvent extends ModelInstance<LocalEvent,Sql> implements LocalEvent {

    // attributes
    public UniqueId getSMevt_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSMevt_ID( UniqueId ref_SMevt_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSM_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSMspd_IDdeprecated( UniqueId m_SMspd_IDdeprecated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSMspd_IDdeprecated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public CreationTransition R509_has_assigned_to_it_CreationTransition() {
        return CreationTransitionImpl.EMPTY_CREATIONTRANSITION;
    }
    @Override
    public SEMEvent R526_is_a_SEMEvent() {
        return SEMEventImpl.EMPTY_SEMEVENT;
    }


    @Override
    public String getKeyLetters() {
        return LocalEventImpl.KEY_LETTERS;
    }

    @Override
    public LocalEvent self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public LocalEvent oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return LocalEventImpl.EMPTY_LOCALEVENT;
    }

}
