package io.ciera.tool.sql.ooaofooa.statemachine.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.statemachine.Action;
import io.ciera.tool.sql.ooaofooa.statemachine.ActionHome;
import io.ciera.tool.sql.ooaofooa.statemachine.MealyActionHome;
import io.ciera.tool.sql.ooaofooa.statemachine.MooreActionHome;
import io.ciera.tool.sql.ooaofooa.statemachine.TransitionActionHome;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.ActionImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.MealyActionHomeImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.MooreActionHomeImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.TransitionActionHomeImpl;


public class ActionHomeImpl extends ModelInstance<ActionHome,Sql> implements ActionHome {

    public static final String KEY_LETTERS = "SM_AH";
    public static final ActionHome EMPTY_ACTIONHOME = new EmptyActionHome();

    private Sql context;

    // constructors
    private ActionHomeImpl( Sql context ) {
        this.context = context;
        ref_Act_ID = UniqueId.random();
        ref_SM_ID = UniqueId.random();
        R513_is_a_MealyActionHome_inst = MealyActionHomeImpl.EMPTY_MEALYACTIONHOME;
        R513_is_a_MooreActionHome_inst = MooreActionHomeImpl.EMPTY_MOOREACTIONHOME;
        R513_is_a_TransitionActionHome_inst = TransitionActionHomeImpl.EMPTY_TRANSITIONACTIONHOME;
        R514_houses_Action_inst = ActionImpl.EMPTY_ACTION;
    }

    private ActionHomeImpl( Sql context, UniqueId instanceId, UniqueId ref_Act_ID, UniqueId ref_SM_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Act_ID = ref_Act_ID;
        this.ref_SM_ID = ref_SM_ID;
        R513_is_a_MealyActionHome_inst = MealyActionHomeImpl.EMPTY_MEALYACTIONHOME;
        R513_is_a_MooreActionHome_inst = MooreActionHomeImpl.EMPTY_MOOREACTIONHOME;
        R513_is_a_TransitionActionHome_inst = TransitionActionHomeImpl.EMPTY_TRANSITIONACTIONHOME;
        R514_houses_Action_inst = ActionImpl.EMPTY_ACTION;
    }

    public static ActionHome create( Sql context ) throws XtumlException {
        ActionHome newActionHome = new ActionHomeImpl( context );
        if ( context.addInstance( newActionHome ) ) {
            newActionHome.getRunContext().addChange(new InstanceCreatedDelta(newActionHome, KEY_LETTERS));
            return newActionHome;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ActionHome create( Sql context, UniqueId instanceId, UniqueId ref_Act_ID, UniqueId ref_SM_ID ) throws XtumlException {
        ActionHome newActionHome = new ActionHomeImpl( context, instanceId, ref_Act_ID, ref_SM_ID );
        if ( context.addInstance( newActionHome ) ) {
            return newActionHome;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Act_ID;
    @Override
    public UniqueId getAct_ID() throws XtumlException {
        checkLiving();
        return ref_Act_ID;
    }
    @Override
    public void setAct_ID(UniqueId ref_Act_ID) throws XtumlException {
        checkLiving();
        if (ref_Act_ID.inequality( this.ref_Act_ID)) {
            final UniqueId oldValue = this.ref_Act_ID;
            this.ref_Act_ID = ref_Act_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Act_ID", oldValue, this.ref_Act_ID));
            if ( !R513_is_a_MooreActionHome().isEmpty() ) R513_is_a_MooreActionHome().setAct_ID( ref_Act_ID );
            if ( !R513_is_a_TransitionActionHome().isEmpty() ) R513_is_a_TransitionActionHome().setAct_ID( ref_Act_ID );
            if ( !R513_is_a_MealyActionHome().isEmpty() ) R513_is_a_MealyActionHome().setAct_ID( ref_Act_ID );
        }
    }
    private UniqueId ref_SM_ID;
    @Override
    public UniqueId getSM_ID() throws XtumlException {
        checkLiving();
        return ref_SM_ID;
    }
    @Override
    public void setSM_ID(UniqueId ref_SM_ID) throws XtumlException {
        checkLiving();
        if (ref_SM_ID.inequality( this.ref_SM_ID)) {
            final UniqueId oldValue = this.ref_SM_ID;
            this.ref_SM_ID = ref_SM_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SM_ID", oldValue, this.ref_SM_ID));
            if ( !R513_is_a_TransitionActionHome().isEmpty() ) R513_is_a_TransitionActionHome().setSM_ID( ref_SM_ID );
            if ( !R513_is_a_MooreActionHome().isEmpty() ) R513_is_a_MooreActionHome().setSM_ID( ref_SM_ID );
            if ( !R513_is_a_MealyActionHome().isEmpty() ) R513_is_a_MealyActionHome().setSM_ID( ref_SM_ID );
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getAct_ID(), getSM_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private MealyActionHome R513_is_a_MealyActionHome_inst;
    @Override
    public void setR513_is_a_MealyActionHome( MealyActionHome inst ) {
        R513_is_a_MealyActionHome_inst = inst;
    }
    @Override
    public MealyActionHome R513_is_a_MealyActionHome() throws XtumlException {
        return R513_is_a_MealyActionHome_inst;
    }
    private MooreActionHome R513_is_a_MooreActionHome_inst;
    @Override
    public void setR513_is_a_MooreActionHome( MooreActionHome inst ) {
        R513_is_a_MooreActionHome_inst = inst;
    }
    @Override
    public MooreActionHome R513_is_a_MooreActionHome() throws XtumlException {
        return R513_is_a_MooreActionHome_inst;
    }
    private TransitionActionHome R513_is_a_TransitionActionHome_inst;
    @Override
    public void setR513_is_a_TransitionActionHome( TransitionActionHome inst ) {
        R513_is_a_TransitionActionHome_inst = inst;
    }
    @Override
    public TransitionActionHome R513_is_a_TransitionActionHome() throws XtumlException {
        return R513_is_a_TransitionActionHome_inst;
    }
    private Action R514_houses_Action_inst;
    @Override
    public void setR514_houses_Action( Action inst ) {
        R514_houses_Action_inst = inst;
    }
    @Override
    public Action R514_houses_Action() throws XtumlException {
        return R514_houses_Action_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ActionHome self() {
        return this;
    }

    @Override
    public ActionHome oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_ACTIONHOME;
    }

}

class EmptyActionHome extends ModelInstance<ActionHome,Sql> implements ActionHome {

    // attributes
    public UniqueId getAct_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAct_ID( UniqueId ref_Act_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSM_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public MealyActionHome R513_is_a_MealyActionHome() {
        return MealyActionHomeImpl.EMPTY_MEALYACTIONHOME;
    }
    @Override
    public MooreActionHome R513_is_a_MooreActionHome() {
        return MooreActionHomeImpl.EMPTY_MOOREACTIONHOME;
    }
    @Override
    public TransitionActionHome R513_is_a_TransitionActionHome() {
        return TransitionActionHomeImpl.EMPTY_TRANSITIONACTIONHOME;
    }
    @Override
    public Action R514_houses_Action() {
        return ActionImpl.EMPTY_ACTION;
    }


    @Override
    public String getKeyLetters() {
        return ActionHomeImpl.KEY_LETTERS;
    }

    @Override
    public ActionHome self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ActionHome oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ActionHomeImpl.EMPTY_ACTIONHOME;
    }

}
