package io.ciera.tool.sql.ooaofooa.packageableelement.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.elementpackaging.EP_PKG;
import io.ciera.tool.sql.ooaofooa.elementpackaging.impl.EP_PKGImpl;
import io.ciera.tool.sql.ooaofooa.packageableelement.ElementVisibility;
import io.ciera.tool.sql.ooaofooa.packageableelement.ElementVisibilitySet;
import io.ciera.tool.sql.ooaofooa.packageableelement.SearchResultSet;
import io.ciera.tool.sql.ooaofooa.packageableelement.impl.ElementVisibilitySetImpl;

import ooaofooa.datatypes.ElementTypeConstants;


public class SearchResultSetImpl extends ModelInstance<SearchResultSet,Sql> implements SearchResultSet {

    public static final String KEY_LETTERS = "PE_SRS";
    public static final SearchResultSet EMPTY_SEARCHRESULTSET = new EmptySearchResultSet();

    private Sql context;

    // constructors
    private SearchResultSetImpl( Sql context ) {
        this.context = context;
        ref_Package_ID = UniqueId.random();
        m_Name = "";
        m_Type = ElementTypeConstants.UNINITIALIZED_ENUM;
        R8005_held_by_EP_PKG_inst = EP_PKGImpl.EMPTY_EP_PKG;
        R8006_ElementVisibility_set = new ElementVisibilitySetImpl();
    }

    private SearchResultSetImpl( Sql context, UniqueId instanceId, UniqueId ref_Package_ID, String m_Name, ElementTypeConstants m_Type ) {
        super(instanceId);
        this.context = context;
        this.ref_Package_ID = ref_Package_ID;
        this.m_Name = m_Name;
        this.m_Type = m_Type;
        R8005_held_by_EP_PKG_inst = EP_PKGImpl.EMPTY_EP_PKG;
        R8006_ElementVisibility_set = new ElementVisibilitySetImpl();
    }

    public static SearchResultSet create( Sql context ) throws XtumlException {
        SearchResultSet newSearchResultSet = new SearchResultSetImpl( context );
        if ( context.addInstance( newSearchResultSet ) ) {
            newSearchResultSet.getRunContext().addChange(new InstanceCreatedDelta(newSearchResultSet, KEY_LETTERS));
            return newSearchResultSet;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static SearchResultSet create( Sql context, UniqueId instanceId, UniqueId ref_Package_ID, String m_Name, ElementTypeConstants m_Type ) throws XtumlException {
        SearchResultSet newSearchResultSet = new SearchResultSetImpl( context, instanceId, ref_Package_ID, m_Name, m_Type );
        if ( context.addInstance( newSearchResultSet ) ) {
            return newSearchResultSet;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Package_ID;
    @Override
    public void setPackage_ID(UniqueId ref_Package_ID) throws XtumlException {
        checkLiving();
        if (ref_Package_ID.inequality( this.ref_Package_ID)) {
            final UniqueId oldValue = this.ref_Package_ID;
            this.ref_Package_ID = ref_Package_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Package_ID", oldValue, this.ref_Package_ID));
            if ( !R8006_ElementVisibility().isEmpty() ) R8006_ElementVisibility().setPackage_ID( ref_Package_ID );
        }
    }
    @Override
    public UniqueId getPackage_ID() throws XtumlException {
        checkLiving();
        return ref_Package_ID;
    }
    private String m_Name;
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
            if ( !R8006_ElementVisibility().isEmpty() ) R8006_ElementVisibility().setName( m_Name );
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    private ElementTypeConstants m_Type;
    @Override
    public ElementTypeConstants getType() throws XtumlException {
        checkLiving();
        return m_Type;
    }
    @Override
    public void setType(ElementTypeConstants m_Type) throws XtumlException {
        checkLiving();
        if (m_Type.inequality( this.m_Type)) {
            final ElementTypeConstants oldValue = this.m_Type;
            this.m_Type = m_Type;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Type", oldValue, this.m_Type));
            if ( !R8006_ElementVisibility().isEmpty() ) R8006_ElementVisibility().setType( m_Type );
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getPackage_ID(), getName(), getType());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private EP_PKG R8005_held_by_EP_PKG_inst;
    @Override
    public void setR8005_held_by_EP_PKG( EP_PKG inst ) {
        R8005_held_by_EP_PKG_inst = inst;
    }
    @Override
    public EP_PKG R8005_held_by_EP_PKG() throws XtumlException {
        return R8005_held_by_EP_PKG_inst;
    }
    private ElementVisibilitySet R8006_ElementVisibility_set;
    @Override
    public void addR8006_ElementVisibility( ElementVisibility inst ) {
        R8006_ElementVisibility_set.add(inst);
    }
    @Override
    public void removeR8006_ElementVisibility( ElementVisibility inst ) {
        R8006_ElementVisibility_set.remove(inst);
    }
    @Override
    public ElementVisibilitySet R8006_ElementVisibility() throws XtumlException {
        return R8006_ElementVisibility_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public SearchResultSet self() {
        return this;
    }

    @Override
    public SearchResultSet oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_SEARCHRESULTSET;
    }

}

class EmptySearchResultSet extends ModelInstance<SearchResultSet,Sql> implements SearchResultSet {

    // attributes
    public void setPackage_ID( UniqueId ref_Package_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getPackage_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public ElementTypeConstants getType() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setType( ElementTypeConstants m_Type ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public EP_PKG R8005_held_by_EP_PKG() {
        return EP_PKGImpl.EMPTY_EP_PKG;
    }
    @Override
    public ElementVisibilitySet R8006_ElementVisibility() {
        return (new ElementVisibilitySetImpl());
    }


    @Override
    public String getKeyLetters() {
        return SearchResultSetImpl.KEY_LETTERS;
    }

    @Override
    public SearchResultSet self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public SearchResultSet oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return SearchResultSetImpl.EMPTY_SEARCHRESULTSET;
    }

}
