package io.ciera.tool.sql.ooaofooa.message.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.message.AsynchronousMessage;
import io.ciera.tool.sql.ooaofooa.message.EventMessage;
import io.ciera.tool.sql.ooaofooa.message.InformalAsynchronousMessage;
import io.ciera.tool.sql.ooaofooa.message.MSG_M;
import io.ciera.tool.sql.ooaofooa.message.SignalMessage;
import io.ciera.tool.sql.ooaofooa.message.impl.EventMessageImpl;
import io.ciera.tool.sql.ooaofooa.message.impl.InformalAsynchronousMessageImpl;
import io.ciera.tool.sql.ooaofooa.message.impl.MSG_MImpl;
import io.ciera.tool.sql.ooaofooa.message.impl.SignalMessageImpl;


public class AsynchronousMessageImpl extends ModelInstance<AsynchronousMessage,Sql> implements AsynchronousMessage {

    public static final String KEY_LETTERS = "MSG_AM";
    public static final AsynchronousMessage EMPTY_ASYNCHRONOUSMESSAGE = new EmptyAsynchronousMessage();

    private Sql context;

    // constructors
    private AsynchronousMessageImpl( Sql context ) {
        this.context = context;
        ref_Msg_ID = UniqueId.random();
        m_InformalName = "";
        m_Descrip = "";
        m_GuardCondition = "";
        m_DurationObservation = "";
        m_DurationConstraint = "";
        m_isFormal = false;
        m_Label = "";
        m_SequenceNumb = "";
        R1018_is_a_MSG_M_inst = MSG_MImpl.EMPTY_MSG_M;
        R1019_is_a_EventMessage_inst = EventMessageImpl.EMPTY_EVENTMESSAGE;
        R1019_is_a_InformalAsynchronousMessage_inst = InformalAsynchronousMessageImpl.EMPTY_INFORMALASYNCHRONOUSMESSAGE;
        R1019_is_a_SignalMessage_inst = SignalMessageImpl.EMPTY_SIGNALMESSAGE;
    }

    private AsynchronousMessageImpl( Sql context, UniqueId instanceId, UniqueId ref_Msg_ID, String m_InformalName, String m_Descrip, String m_GuardCondition, String m_DurationObservation, String m_DurationConstraint, boolean m_isFormal, String m_Label, String m_SequenceNumb ) {
        super(instanceId);
        this.context = context;
        this.ref_Msg_ID = ref_Msg_ID;
        this.m_InformalName = m_InformalName;
        this.m_Descrip = m_Descrip;
        this.m_GuardCondition = m_GuardCondition;
        this.m_DurationObservation = m_DurationObservation;
        this.m_DurationConstraint = m_DurationConstraint;
        this.m_isFormal = m_isFormal;
        this.m_Label = m_Label;
        this.m_SequenceNumb = m_SequenceNumb;
        R1018_is_a_MSG_M_inst = MSG_MImpl.EMPTY_MSG_M;
        R1019_is_a_EventMessage_inst = EventMessageImpl.EMPTY_EVENTMESSAGE;
        R1019_is_a_InformalAsynchronousMessage_inst = InformalAsynchronousMessageImpl.EMPTY_INFORMALASYNCHRONOUSMESSAGE;
        R1019_is_a_SignalMessage_inst = SignalMessageImpl.EMPTY_SIGNALMESSAGE;
    }

    public static AsynchronousMessage create( Sql context ) throws XtumlException {
        AsynchronousMessage newAsynchronousMessage = new AsynchronousMessageImpl( context );
        if ( context.addInstance( newAsynchronousMessage ) ) {
            newAsynchronousMessage.getRunContext().addChange(new InstanceCreatedDelta(newAsynchronousMessage, KEY_LETTERS));
            return newAsynchronousMessage;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static AsynchronousMessage create( Sql context, UniqueId instanceId, UniqueId ref_Msg_ID, String m_InformalName, String m_Descrip, String m_GuardCondition, String m_DurationObservation, String m_DurationConstraint, boolean m_isFormal, String m_Label, String m_SequenceNumb ) throws XtumlException {
        AsynchronousMessage newAsynchronousMessage = new AsynchronousMessageImpl( context, instanceId, ref_Msg_ID, m_InformalName, m_Descrip, m_GuardCondition, m_DurationObservation, m_DurationConstraint, m_isFormal, m_Label, m_SequenceNumb );
        if ( context.addInstance( newAsynchronousMessage ) ) {
            return newAsynchronousMessage;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Msg_ID;
    @Override
    public UniqueId getMsg_ID() throws XtumlException {
        checkLiving();
        return ref_Msg_ID;
    }
    @Override
    public void setMsg_ID(UniqueId ref_Msg_ID) throws XtumlException {
        checkLiving();
        if (ref_Msg_ID.inequality( this.ref_Msg_ID)) {
            final UniqueId oldValue = this.ref_Msg_ID;
            this.ref_Msg_ID = ref_Msg_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Msg_ID", oldValue, this.ref_Msg_ID));
            if ( !R1019_is_a_InformalAsynchronousMessage().isEmpty() ) R1019_is_a_InformalAsynchronousMessage().setMsg_ID( ref_Msg_ID );
            if ( !R1019_is_a_EventMessage().isEmpty() ) R1019_is_a_EventMessage().setMsg_ID( ref_Msg_ID );
            if ( !R1019_is_a_SignalMessage().isEmpty() ) R1019_is_a_SignalMessage().setMsg_ID( ref_Msg_ID );
        }
    }
    private String m_InformalName;
    @Override
    public String getInformalName() throws XtumlException {
        checkLiving();
        return m_InformalName;
    }
    @Override
    public void setInformalName(String m_InformalName) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_InformalName, this.m_InformalName)) {
            final String oldValue = this.m_InformalName;
            this.m_InformalName = m_InformalName;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_InformalName", oldValue, this.m_InformalName));
        }
    }
    private String m_Descrip;
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    private String m_GuardCondition;
    @Override
    public void setGuardCondition(String m_GuardCondition) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_GuardCondition, this.m_GuardCondition)) {
            final String oldValue = this.m_GuardCondition;
            this.m_GuardCondition = m_GuardCondition;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_GuardCondition", oldValue, this.m_GuardCondition));
        }
    }
    @Override
    public String getGuardCondition() throws XtumlException {
        checkLiving();
        return m_GuardCondition;
    }
    private String m_DurationObservation;
    @Override
    public String getDurationObservation() throws XtumlException {
        checkLiving();
        return m_DurationObservation;
    }
    @Override
    public void setDurationObservation(String m_DurationObservation) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_DurationObservation, this.m_DurationObservation)) {
            final String oldValue = this.m_DurationObservation;
            this.m_DurationObservation = m_DurationObservation;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_DurationObservation", oldValue, this.m_DurationObservation));
        }
    }
    private String m_DurationConstraint;
    @Override
    public String getDurationConstraint() throws XtumlException {
        checkLiving();
        return m_DurationConstraint;
    }
    @Override
    public void setDurationConstraint(String m_DurationConstraint) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_DurationConstraint, this.m_DurationConstraint)) {
            final String oldValue = this.m_DurationConstraint;
            this.m_DurationConstraint = m_DurationConstraint;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_DurationConstraint", oldValue, this.m_DurationConstraint));
        }
    }
    private boolean m_isFormal;
    @Override
    public boolean getIsFormal() throws XtumlException {
        checkLiving();
        return m_isFormal;
    }
    @Override
    public void setIsFormal(boolean m_isFormal) throws XtumlException {
        checkLiving();
        if (m_isFormal != this.m_isFormal) {
            final boolean oldValue = this.m_isFormal;
            this.m_isFormal = m_isFormal;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_isFormal", oldValue, this.m_isFormal));
        }
    }
    private String m_Label;
    @Override
    public String getLabel() throws XtumlException {
        checkLiving();
        return m_Label;
    }
    @Override
    public void setLabel(String m_Label) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Label, this.m_Label)) {
            final String oldValue = this.m_Label;
            this.m_Label = m_Label;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Label", oldValue, this.m_Label));
        }
    }
    private String m_SequenceNumb;
    @Override
    public void setSequenceNumb(String m_SequenceNumb) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_SequenceNumb, this.m_SequenceNumb)) {
            final String oldValue = this.m_SequenceNumb;
            this.m_SequenceNumb = m_SequenceNumb;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_SequenceNumb", oldValue, this.m_SequenceNumb));
        }
    }
    @Override
    public String getSequenceNumb() throws XtumlException {
        checkLiving();
        return m_SequenceNumb;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getMsg_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private MSG_M R1018_is_a_MSG_M_inst;
    @Override
    public void setR1018_is_a_MSG_M( MSG_M inst ) {
        R1018_is_a_MSG_M_inst = inst;
    }
    @Override
    public MSG_M R1018_is_a_MSG_M() throws XtumlException {
        return R1018_is_a_MSG_M_inst;
    }
    private EventMessage R1019_is_a_EventMessage_inst;
    @Override
    public void setR1019_is_a_EventMessage( EventMessage inst ) {
        R1019_is_a_EventMessage_inst = inst;
    }
    @Override
    public EventMessage R1019_is_a_EventMessage() throws XtumlException {
        return R1019_is_a_EventMessage_inst;
    }
    private InformalAsynchronousMessage R1019_is_a_InformalAsynchronousMessage_inst;
    @Override
    public void setR1019_is_a_InformalAsynchronousMessage( InformalAsynchronousMessage inst ) {
        R1019_is_a_InformalAsynchronousMessage_inst = inst;
    }
    @Override
    public InformalAsynchronousMessage R1019_is_a_InformalAsynchronousMessage() throws XtumlException {
        return R1019_is_a_InformalAsynchronousMessage_inst;
    }
    private SignalMessage R1019_is_a_SignalMessage_inst;
    @Override
    public void setR1019_is_a_SignalMessage( SignalMessage inst ) {
        R1019_is_a_SignalMessage_inst = inst;
    }
    @Override
    public SignalMessage R1019_is_a_SignalMessage() throws XtumlException {
        return R1019_is_a_SignalMessage_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public AsynchronousMessage self() {
        return this;
    }

    @Override
    public AsynchronousMessage oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_ASYNCHRONOUSMESSAGE;
    }

}

class EmptyAsynchronousMessage extends ModelInstance<AsynchronousMessage,Sql> implements AsynchronousMessage {

    // attributes
    public UniqueId getMsg_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setMsg_ID( UniqueId ref_Msg_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getInformalName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setInformalName( String m_InformalName ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setGuardCondition( String m_GuardCondition ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getGuardCondition() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getDurationObservation() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDurationObservation( String m_DurationObservation ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDurationConstraint() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDurationConstraint( String m_DurationConstraint ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getIsFormal() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIsFormal( boolean m_isFormal ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLabel() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLabel( String m_Label ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSequenceNumb( String m_SequenceNumb ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getSequenceNumb() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public MSG_M R1018_is_a_MSG_M() {
        return MSG_MImpl.EMPTY_MSG_M;
    }
    @Override
    public EventMessage R1019_is_a_EventMessage() {
        return EventMessageImpl.EMPTY_EVENTMESSAGE;
    }
    @Override
    public InformalAsynchronousMessage R1019_is_a_InformalAsynchronousMessage() {
        return InformalAsynchronousMessageImpl.EMPTY_INFORMALASYNCHRONOUSMESSAGE;
    }
    @Override
    public SignalMessage R1019_is_a_SignalMessage() {
        return SignalMessageImpl.EMPTY_SIGNALMESSAGE;
    }


    @Override
    public String getKeyLetters() {
        return AsynchronousMessageImpl.KEY_LETTERS;
    }

    @Override
    public AsynchronousMessage self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public AsynchronousMessage oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return AsynchronousMessageImpl.EMPTY_ASYNCHRONOUSMESSAGE;
    }

}
