package io.ciera.tool.sql.ooaofooa.interaction.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.interaction.InformalAttributeValue;
import io.ciera.tool.sql.ooaofooa.interaction.InstanceAttributeValue;
import io.ciera.tool.sql.ooaofooa.interaction.impl.InstanceAttributeValueImpl;


public class InformalAttributeValueImpl extends ModelInstance<InformalAttributeValue,Sql> implements InformalAttributeValue {

    public static final String KEY_LETTERS = "SQ_IAV";
    public static final InformalAttributeValue EMPTY_INFORMALATTRIBUTEVALUE = new EmptyInformalAttributeValue();

    private Sql context;

    // constructors
    private InformalAttributeValueImpl( Sql context ) {
        this.context = context;
        ref_Av_ID = UniqueId.random();
        R948_is_a_InstanceAttributeValue_inst = InstanceAttributeValueImpl.EMPTY_INSTANCEATTRIBUTEVALUE;
    }

    private InformalAttributeValueImpl( Sql context, UniqueId instanceId, UniqueId ref_Av_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Av_ID = ref_Av_ID;
        R948_is_a_InstanceAttributeValue_inst = InstanceAttributeValueImpl.EMPTY_INSTANCEATTRIBUTEVALUE;
    }

    public static InformalAttributeValue create( Sql context ) throws XtumlException {
        InformalAttributeValue newInformalAttributeValue = new InformalAttributeValueImpl( context );
        if ( context.addInstance( newInformalAttributeValue ) ) {
            newInformalAttributeValue.getRunContext().addChange(new InstanceCreatedDelta(newInformalAttributeValue, KEY_LETTERS));
            return newInformalAttributeValue;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static InformalAttributeValue create( Sql context, UniqueId instanceId, UniqueId ref_Av_ID ) throws XtumlException {
        InformalAttributeValue newInformalAttributeValue = new InformalAttributeValueImpl( context, instanceId, ref_Av_ID );
        if ( context.addInstance( newInformalAttributeValue ) ) {
            return newInformalAttributeValue;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Av_ID;
    @Override
    public UniqueId getAv_ID() throws XtumlException {
        checkLiving();
        return ref_Av_ID;
    }
    @Override
    public void setAv_ID(UniqueId ref_Av_ID) throws XtumlException {
        checkLiving();
        if (ref_Av_ID.inequality( this.ref_Av_ID)) {
            final UniqueId oldValue = this.ref_Av_ID;
            this.ref_Av_ID = ref_Av_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Av_ID", oldValue, this.ref_Av_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getAv_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private InstanceAttributeValue R948_is_a_InstanceAttributeValue_inst;
    @Override
    public void setR948_is_a_InstanceAttributeValue( InstanceAttributeValue inst ) {
        R948_is_a_InstanceAttributeValue_inst = inst;
    }
    @Override
    public InstanceAttributeValue R948_is_a_InstanceAttributeValue() throws XtumlException {
        return R948_is_a_InstanceAttributeValue_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public InformalAttributeValue self() {
        return this;
    }

    @Override
    public InformalAttributeValue oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_INFORMALATTRIBUTEVALUE;
    }

}

class EmptyInformalAttributeValue extends ModelInstance<InformalAttributeValue,Sql> implements InformalAttributeValue {

    // attributes
    public UniqueId getAv_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAv_ID( UniqueId ref_Av_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public InstanceAttributeValue R948_is_a_InstanceAttributeValue() {
        return InstanceAttributeValueImpl.EMPTY_INSTANCEATTRIBUTEVALUE;
    }


    @Override
    public String getKeyLetters() {
        return InformalAttributeValueImpl.KEY_LETTERS;
    }

    @Override
    public InformalAttributeValue self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public InformalAttributeValue oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return InformalAttributeValueImpl.EMPTY_INFORMALATTRIBUTEVALUE;
    }

}
