package io.ciera.tool.sql.ooaofooa.interaction.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.interaction.ClassParticipant;
import io.ciera.tool.sql.ooaofooa.interaction.ClassParticipantAttribute;
import io.ciera.tool.sql.ooaofooa.interaction.ClassParticipantAttributeSet;
import io.ciera.tool.sql.ooaofooa.interaction.InteractionParticipant;
import io.ciera.tool.sql.ooaofooa.interaction.impl.ClassParticipantAttributeSetImpl;
import io.ciera.tool.sql.ooaofooa.interaction.impl.InteractionParticipantImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.ModelClass;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.ModelClassImpl;


public class ClassParticipantImpl extends ModelInstance<ClassParticipant,Sql> implements ClassParticipant {

    public static final String KEY_LETTERS = "SQ_CP";
    public static final ClassParticipant EMPTY_CLASSPARTICIPANT = new EmptyClassParticipant();

    private Sql context;

    // constructors
    private ClassParticipantImpl( Sql context ) {
        this.context = context;
        ref_Part_ID = UniqueId.random();
        ref_Obj_ID = UniqueId.random();
        m_Label = "";
        m_InformalName = "";
        m_Descrip = "";
        m_isFormal = false;
        R930_is_a_InteractionParticipant_inst = InteractionParticipantImpl.EMPTY_INTERACTIONPARTICIPANT;
        R935_may_have_ClassParticipantAttribute_set = new ClassParticipantAttributeSetImpl();
        R939_represents_ModelClass_inst = ModelClassImpl.EMPTY_MODELCLASS;
    }

    private ClassParticipantImpl( Sql context, UniqueId instanceId, UniqueId ref_Part_ID, UniqueId ref_Obj_ID, String m_Label, String m_InformalName, String m_Descrip, boolean m_isFormal ) {
        super(instanceId);
        this.context = context;
        this.ref_Part_ID = ref_Part_ID;
        this.ref_Obj_ID = ref_Obj_ID;
        this.m_Label = m_Label;
        this.m_InformalName = m_InformalName;
        this.m_Descrip = m_Descrip;
        this.m_isFormal = m_isFormal;
        R930_is_a_InteractionParticipant_inst = InteractionParticipantImpl.EMPTY_INTERACTIONPARTICIPANT;
        R935_may_have_ClassParticipantAttribute_set = new ClassParticipantAttributeSetImpl();
        R939_represents_ModelClass_inst = ModelClassImpl.EMPTY_MODELCLASS;
    }

    public static ClassParticipant create( Sql context ) throws XtumlException {
        ClassParticipant newClassParticipant = new ClassParticipantImpl( context );
        if ( context.addInstance( newClassParticipant ) ) {
            newClassParticipant.getRunContext().addChange(new InstanceCreatedDelta(newClassParticipant, KEY_LETTERS));
            return newClassParticipant;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ClassParticipant create( Sql context, UniqueId instanceId, UniqueId ref_Part_ID, UniqueId ref_Obj_ID, String m_Label, String m_InformalName, String m_Descrip, boolean m_isFormal ) throws XtumlException {
        ClassParticipant newClassParticipant = new ClassParticipantImpl( context, instanceId, ref_Part_ID, ref_Obj_ID, m_Label, m_InformalName, m_Descrip, m_isFormal );
        if ( context.addInstance( newClassParticipant ) ) {
            return newClassParticipant;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Part_ID;
    @Override
    public UniqueId getPart_ID() throws XtumlException {
        checkLiving();
        return ref_Part_ID;
    }
    @Override
    public void setPart_ID(UniqueId ref_Part_ID) throws XtumlException {
        checkLiving();
        if (ref_Part_ID.inequality( this.ref_Part_ID)) {
            final UniqueId oldValue = this.ref_Part_ID;
            this.ref_Part_ID = ref_Part_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Part_ID", oldValue, this.ref_Part_ID));
            if ( !R935_may_have_ClassParticipantAttribute().isEmpty() ) R935_may_have_ClassParticipantAttribute().setPart_ID( ref_Part_ID );
        }
    }
    private UniqueId ref_Obj_ID;
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
        return ref_Obj_ID;
    }
    @Override
    public void setObj_ID(UniqueId ref_Obj_ID) throws XtumlException {
        checkLiving();
        if (ref_Obj_ID.inequality( this.ref_Obj_ID)) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
        }
    }
    private String m_Label;
    @Override
    public void setLabel(String m_Label) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Label, this.m_Label)) {
            final String oldValue = this.m_Label;
            this.m_Label = m_Label;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Label", oldValue, this.m_Label));
        }
    }
    @Override
    public String getLabel() throws XtumlException {
        checkLiving();
        return m_Label;
    }
    private String m_InformalName;
    @Override
    public void setInformalName(String m_InformalName) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_InformalName, this.m_InformalName)) {
            final String oldValue = this.m_InformalName;
            this.m_InformalName = m_InformalName;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_InformalName", oldValue, this.m_InformalName));
        }
    }
    @Override
    public String getInformalName() throws XtumlException {
        checkLiving();
        return m_InformalName;
    }
    private String m_Descrip;
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    private boolean m_isFormal;
    @Override
    public void setIsFormal(boolean m_isFormal) throws XtumlException {
        checkLiving();
        if (m_isFormal != this.m_isFormal) {
            final boolean oldValue = this.m_isFormal;
            this.m_isFormal = m_isFormal;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_isFormal", oldValue, this.m_isFormal));
        }
    }
    @Override
    public boolean getIsFormal() throws XtumlException {
        checkLiving();
        return m_isFormal;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getPart_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private InteractionParticipant R930_is_a_InteractionParticipant_inst;
    @Override
    public void setR930_is_a_InteractionParticipant( InteractionParticipant inst ) {
        R930_is_a_InteractionParticipant_inst = inst;
    }
    @Override
    public InteractionParticipant R930_is_a_InteractionParticipant() throws XtumlException {
        return R930_is_a_InteractionParticipant_inst;
    }
    private ClassParticipantAttributeSet R935_may_have_ClassParticipantAttribute_set;
    @Override
    public void addR935_may_have_ClassParticipantAttribute( ClassParticipantAttribute inst ) {
        R935_may_have_ClassParticipantAttribute_set.add(inst);
    }
    @Override
    public void removeR935_may_have_ClassParticipantAttribute( ClassParticipantAttribute inst ) {
        R935_may_have_ClassParticipantAttribute_set.remove(inst);
    }
    @Override
    public ClassParticipantAttributeSet R935_may_have_ClassParticipantAttribute() throws XtumlException {
        return R935_may_have_ClassParticipantAttribute_set;
    }
    private ModelClass R939_represents_ModelClass_inst;
    @Override
    public void setR939_represents_ModelClass( ModelClass inst ) {
        R939_represents_ModelClass_inst = inst;
    }
    @Override
    public ModelClass R939_represents_ModelClass() throws XtumlException {
        return R939_represents_ModelClass_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ClassParticipant self() {
        return this;
    }

    @Override
    public ClassParticipant oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_CLASSPARTICIPANT;
    }

}

class EmptyClassParticipant extends ModelInstance<ClassParticipant,Sql> implements ClassParticipant {

    // attributes
    public UniqueId getPart_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPart_ID( UniqueId ref_Part_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setLabel( String m_Label ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLabel() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setInformalName( String m_InformalName ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getInformalName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setIsFormal( boolean m_isFormal ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getIsFormal() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public InteractionParticipant R930_is_a_InteractionParticipant() {
        return InteractionParticipantImpl.EMPTY_INTERACTIONPARTICIPANT;
    }
    @Override
    public ClassParticipantAttributeSet R935_may_have_ClassParticipantAttribute() {
        return (new ClassParticipantAttributeSetImpl());
    }
    @Override
    public ModelClass R939_represents_ModelClass() {
        return ModelClassImpl.EMPTY_MODELCLASS;
    }


    @Override
    public String getKeyLetters() {
        return ClassParticipantImpl.KEY_LETTERS;
    }

    @Override
    public ClassParticipant self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ClassParticipant oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ClassParticipantImpl.EMPTY_CLASSPARTICIPANT;
    }

}
