package io.ciera.tool.sql.ooaofooa.instance.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.instance.ComponentInstance;
import io.ciera.tool.sql.ooaofooa.instance.IntercomponentQueueEntry;
import io.ciera.tool.sql.ooaofooa.instance.Stack;
import io.ciera.tool.sql.ooaofooa.instance.StackFrame;
import io.ciera.tool.sql.ooaofooa.instance.impl.ComponentInstanceImpl;
import io.ciera.tool.sql.ooaofooa.instance.impl.StackFrameImpl;
import io.ciera.tool.sql.ooaofooa.instance.impl.StackImpl;


public class IntercomponentQueueEntryImpl extends ModelInstance<IntercomponentQueueEntry,Sql> implements IntercomponentQueueEntry {

    public static final String KEY_LETTERS = "I_ICQE";
    public static final IntercomponentQueueEntry EMPTY_INTERCOMPONENTQUEUEENTRY = new EmptyIntercomponentQueueEntry();

    private Sql context;

    // constructors
    private IntercomponentQueueEntryImpl( Sql context ) {
        this.context = context;
        ref_Stack_ID = UniqueId.random();
        ref_Stack_Frame_ID = UniqueId.random();
        ref_Execution_Engine_ID = UniqueId.random();
        R2966_has_queued_StackFrame_inst = StackFrameImpl.EMPTY_STACKFRAME;
        R2966_is_enqueued_with_Stack_inst = StackImpl.EMPTY_STACK;
        R2977_enqueued_by_ComponentInstance_inst = ComponentInstanceImpl.EMPTY_COMPONENTINSTANCE;
    }

    private IntercomponentQueueEntryImpl( Sql context, UniqueId instanceId, UniqueId ref_Stack_ID, UniqueId ref_Stack_Frame_ID, UniqueId ref_Execution_Engine_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Stack_ID = ref_Stack_ID;
        this.ref_Stack_Frame_ID = ref_Stack_Frame_ID;
        this.ref_Execution_Engine_ID = ref_Execution_Engine_ID;
        R2966_has_queued_StackFrame_inst = StackFrameImpl.EMPTY_STACKFRAME;
        R2966_is_enqueued_with_Stack_inst = StackImpl.EMPTY_STACK;
        R2977_enqueued_by_ComponentInstance_inst = ComponentInstanceImpl.EMPTY_COMPONENTINSTANCE;
    }

    public static IntercomponentQueueEntry create( Sql context ) throws XtumlException {
        IntercomponentQueueEntry newIntercomponentQueueEntry = new IntercomponentQueueEntryImpl( context );
        if ( context.addInstance( newIntercomponentQueueEntry ) ) {
            newIntercomponentQueueEntry.getRunContext().addChange(new InstanceCreatedDelta(newIntercomponentQueueEntry, KEY_LETTERS));
            return newIntercomponentQueueEntry;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static IntercomponentQueueEntry create( Sql context, UniqueId instanceId, UniqueId ref_Stack_ID, UniqueId ref_Stack_Frame_ID, UniqueId ref_Execution_Engine_ID ) throws XtumlException {
        IntercomponentQueueEntry newIntercomponentQueueEntry = new IntercomponentQueueEntryImpl( context, instanceId, ref_Stack_ID, ref_Stack_Frame_ID, ref_Execution_Engine_ID );
        if ( context.addInstance( newIntercomponentQueueEntry ) ) {
            return newIntercomponentQueueEntry;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Stack_ID;
    @Override
    public void setStack_ID(UniqueId ref_Stack_ID) throws XtumlException {
        checkLiving();
        if (ref_Stack_ID.inequality( this.ref_Stack_ID)) {
            final UniqueId oldValue = this.ref_Stack_ID;
            this.ref_Stack_ID = ref_Stack_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Stack_ID", oldValue, this.ref_Stack_ID));
        }
    }
    @Override
    public UniqueId getStack_ID() throws XtumlException {
        checkLiving();
        return ref_Stack_ID;
    }
    private UniqueId ref_Stack_Frame_ID;
    @Override
    public void setStack_Frame_ID(UniqueId ref_Stack_Frame_ID) throws XtumlException {
        checkLiving();
        if (ref_Stack_Frame_ID.inequality( this.ref_Stack_Frame_ID)) {
            final UniqueId oldValue = this.ref_Stack_Frame_ID;
            this.ref_Stack_Frame_ID = ref_Stack_Frame_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Stack_Frame_ID", oldValue, this.ref_Stack_Frame_ID));
        }
    }
    @Override
    public UniqueId getStack_Frame_ID() throws XtumlException {
        checkLiving();
        return ref_Stack_Frame_ID;
    }
    private UniqueId ref_Execution_Engine_ID;
    @Override
    public void setExecution_Engine_ID(UniqueId ref_Execution_Engine_ID) throws XtumlException {
        checkLiving();
        if (ref_Execution_Engine_ID.inequality( this.ref_Execution_Engine_ID)) {
            final UniqueId oldValue = this.ref_Execution_Engine_ID;
            this.ref_Execution_Engine_ID = ref_Execution_Engine_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Execution_Engine_ID", oldValue, this.ref_Execution_Engine_ID));
        }
    }
    @Override
    public UniqueId getExecution_Engine_ID() throws XtumlException {
        checkLiving();
        return ref_Execution_Engine_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStack_ID(), getStack_Frame_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private StackFrame R2966_has_queued_StackFrame_inst;
    @Override
    public void setR2966_has_queued_StackFrame( StackFrame inst ) {
        R2966_has_queued_StackFrame_inst = inst;
    }
    @Override
    public StackFrame R2966_has_queued_StackFrame() throws XtumlException {
        return R2966_has_queued_StackFrame_inst;
    }
    private Stack R2966_is_enqueued_with_Stack_inst;
    @Override
    public void setR2966_is_enqueued_with_Stack( Stack inst ) {
        R2966_is_enqueued_with_Stack_inst = inst;
    }
    @Override
    public Stack R2966_is_enqueued_with_Stack() throws XtumlException {
        return R2966_is_enqueued_with_Stack_inst;
    }
    private ComponentInstance R2977_enqueued_by_ComponentInstance_inst;
    @Override
    public void setR2977_enqueued_by_ComponentInstance( ComponentInstance inst ) {
        R2977_enqueued_by_ComponentInstance_inst = inst;
    }
    @Override
    public ComponentInstance R2977_enqueued_by_ComponentInstance() throws XtumlException {
        return R2977_enqueued_by_ComponentInstance_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public IntercomponentQueueEntry self() {
        return this;
    }

    @Override
    public IntercomponentQueueEntry oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_INTERCOMPONENTQUEUEENTRY;
    }

}

class EmptyIntercomponentQueueEntry extends ModelInstance<IntercomponentQueueEntry,Sql> implements IntercomponentQueueEntry {

    // attributes
    public void setStack_ID( UniqueId ref_Stack_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getStack_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStack_Frame_ID( UniqueId ref_Stack_Frame_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getStack_Frame_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setExecution_Engine_ID( UniqueId ref_Execution_Engine_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getExecution_Engine_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public StackFrame R2966_has_queued_StackFrame() {
        return StackFrameImpl.EMPTY_STACKFRAME;
    }
    @Override
    public Stack R2966_is_enqueued_with_Stack() {
        return StackImpl.EMPTY_STACK;
    }
    @Override
    public ComponentInstance R2977_enqueued_by_ComponentInstance() {
        return ComponentInstanceImpl.EMPTY_COMPONENTINSTANCE;
    }


    @Override
    public String getKeyLetters() {
        return IntercomponentQueueEntryImpl.KEY_LETTERS;
    }

    @Override
    public IntercomponentQueueEntry self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public IntercomponentQueueEntry oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return IntercomponentQueueEntryImpl.EMPTY_INTERCOMPONENTQUEUEENTRY;
    }

}
