package io.ciera.tool.sql.ooaofooa.instance.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.ACT_SMT;
import io.ciera.tool.sql.ooaofooa.body.Block;
import io.ciera.tool.sql.ooaofooa.body.impl.ACT_SMTImpl;
import io.ciera.tool.sql.ooaofooa.body.impl.BlockImpl;
import io.ciera.tool.sql.ooaofooa.instance.BlockInStackFrame;
import io.ciera.tool.sql.ooaofooa.instance.StackFrame;
import io.ciera.tool.sql.ooaofooa.instance.impl.StackFrameImpl;


public class BlockInStackFrameImpl extends ModelInstance<BlockInStackFrame,Sql> implements BlockInStackFrame {

    public static final String KEY_LETTERS = "I_BSF";
    public static final BlockInStackFrame EMPTY_BLOCKINSTACKFRAME = new EmptyBlockInStackFrame();

    private Sql context;

    // constructors
    private BlockInStackFrameImpl( Sql context ) {
        this.context = context;
        ref_Block_ID = UniqueId.random();
        ref_Stack_Frame_ID = UniqueId.random();
        ref_Statement_ID = UniqueId.random();
        m_isExecuting = false;
        R2923_is_executed_within_the_context_of_StackFrame_inst = StackFrameImpl.EMPTY_STACKFRAME;
        R2923_supplies_context_for_Block_inst = BlockImpl.EMPTY_BLOCK;
        R2941_is_currently_visiting_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
    }

    private BlockInStackFrameImpl( Sql context, UniqueId instanceId, UniqueId ref_Block_ID, UniqueId ref_Stack_Frame_ID, UniqueId ref_Statement_ID, boolean m_isExecuting ) {
        super(instanceId);
        this.context = context;
        this.ref_Block_ID = ref_Block_ID;
        this.ref_Stack_Frame_ID = ref_Stack_Frame_ID;
        this.ref_Statement_ID = ref_Statement_ID;
        this.m_isExecuting = m_isExecuting;
        R2923_is_executed_within_the_context_of_StackFrame_inst = StackFrameImpl.EMPTY_STACKFRAME;
        R2923_supplies_context_for_Block_inst = BlockImpl.EMPTY_BLOCK;
        R2941_is_currently_visiting_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
    }

    public static BlockInStackFrame create( Sql context ) throws XtumlException {
        BlockInStackFrame newBlockInStackFrame = new BlockInStackFrameImpl( context );
        if ( context.addInstance( newBlockInStackFrame ) ) {
            newBlockInStackFrame.getRunContext().addChange(new InstanceCreatedDelta(newBlockInStackFrame, KEY_LETTERS));
            return newBlockInStackFrame;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static BlockInStackFrame create( Sql context, UniqueId instanceId, UniqueId ref_Block_ID, UniqueId ref_Stack_Frame_ID, UniqueId ref_Statement_ID, boolean m_isExecuting ) throws XtumlException {
        BlockInStackFrame newBlockInStackFrame = new BlockInStackFrameImpl( context, instanceId, ref_Block_ID, ref_Stack_Frame_ID, ref_Statement_ID, m_isExecuting );
        if ( context.addInstance( newBlockInStackFrame ) ) {
            return newBlockInStackFrame;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Block_ID;
    @Override
    public UniqueId getBlock_ID() throws XtumlException {
        checkLiving();
        return ref_Block_ID;
    }
    @Override
    public void setBlock_ID(UniqueId ref_Block_ID) throws XtumlException {
        checkLiving();
        if (ref_Block_ID.inequality( this.ref_Block_ID)) {
            final UniqueId oldValue = this.ref_Block_ID;
            this.ref_Block_ID = ref_Block_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Block_ID", oldValue, this.ref_Block_ID));
        }
    }
    private UniqueId ref_Stack_Frame_ID;
    @Override
    public UniqueId getStack_Frame_ID() throws XtumlException {
        checkLiving();
        return ref_Stack_Frame_ID;
    }
    @Override
    public void setStack_Frame_ID(UniqueId ref_Stack_Frame_ID) throws XtumlException {
        checkLiving();
        if (ref_Stack_Frame_ID.inequality( this.ref_Stack_Frame_ID)) {
            final UniqueId oldValue = this.ref_Stack_Frame_ID;
            this.ref_Stack_Frame_ID = ref_Stack_Frame_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Stack_Frame_ID", oldValue, this.ref_Stack_Frame_ID));
        }
    }
    private UniqueId ref_Statement_ID;
    @Override
    public void setStatement_ID(UniqueId ref_Statement_ID) throws XtumlException {
        checkLiving();
        if (ref_Statement_ID.inequality( this.ref_Statement_ID)) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
        }
    }
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
        return ref_Statement_ID;
    }
    private boolean m_isExecuting;
    @Override
    public boolean getIsExecuting() throws XtumlException {
        checkLiving();
        return m_isExecuting;
    }
    @Override
    public void setIsExecuting(boolean m_isExecuting) throws XtumlException {
        checkLiving();
        if (m_isExecuting != this.m_isExecuting) {
            final boolean oldValue = this.m_isExecuting;
            this.m_isExecuting = m_isExecuting;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_isExecuting", oldValue, this.m_isExecuting));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getBlock_ID(), getStack_Frame_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private StackFrame R2923_is_executed_within_the_context_of_StackFrame_inst;
    @Override
    public void setR2923_is_executed_within_the_context_of_StackFrame( StackFrame inst ) {
        R2923_is_executed_within_the_context_of_StackFrame_inst = inst;
    }
    @Override
    public StackFrame R2923_is_executed_within_the_context_of_StackFrame() throws XtumlException {
        return R2923_is_executed_within_the_context_of_StackFrame_inst;
    }
    private Block R2923_supplies_context_for_Block_inst;
    @Override
    public void setR2923_supplies_context_for_Block( Block inst ) {
        R2923_supplies_context_for_Block_inst = inst;
    }
    @Override
    public Block R2923_supplies_context_for_Block() throws XtumlException {
        return R2923_supplies_context_for_Block_inst;
    }
    private ACT_SMT R2941_is_currently_visiting_ACT_SMT_inst;
    @Override
    public void setR2941_is_currently_visiting_ACT_SMT( ACT_SMT inst ) {
        R2941_is_currently_visiting_ACT_SMT_inst = inst;
    }
    @Override
    public ACT_SMT R2941_is_currently_visiting_ACT_SMT() throws XtumlException {
        return R2941_is_currently_visiting_ACT_SMT_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public BlockInStackFrame self() {
        return this;
    }

    @Override
    public BlockInStackFrame oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_BLOCKINSTACKFRAME;
    }

}

class EmptyBlockInStackFrame extends ModelInstance<BlockInStackFrame,Sql> implements BlockInStackFrame {

    // attributes
    public UniqueId getBlock_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBlock_ID( UniqueId ref_Block_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getStack_Frame_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStack_Frame_ID( UniqueId ref_Stack_Frame_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public boolean getIsExecuting() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIsExecuting( boolean m_isExecuting ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public StackFrame R2923_is_executed_within_the_context_of_StackFrame() {
        return StackFrameImpl.EMPTY_STACKFRAME;
    }
    @Override
    public Block R2923_supplies_context_for_Block() {
        return BlockImpl.EMPTY_BLOCK;
    }
    @Override
    public ACT_SMT R2941_is_currently_visiting_ACT_SMT() {
        return ACT_SMTImpl.EMPTY_ACT_SMT;
    }


    @Override
    public String getKeyLetters() {
        return BlockInStackFrameImpl.KEY_LETTERS;
    }

    @Override
    public BlockInStackFrame self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public BlockInStackFrame oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return BlockInStackFrameImpl.EMPTY_BLOCKINSTACKFRAME;
    }

}
