package io.ciera.tool.sql.ooaofooa.event.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.event.CreateEventToInstance;
import io.ciera.tool.sql.ooaofooa.event.CreateSMEventStatement;
import io.ciera.tool.sql.ooaofooa.event.impl.CreateSMEventStatementImpl;
import io.ciera.tool.sql.ooaofooa.value.V_VAR;
import io.ciera.tool.sql.ooaofooa.value.impl.V_VARImpl;


public class CreateEventToInstanceImpl extends ModelInstance<CreateEventToInstance,Sql> implements CreateEventToInstance {

    public static final String KEY_LETTERS = "E_CEI";
    public static final CreateEventToInstance EMPTY_CREATEEVENTTOINSTANCE = new EmptyCreateEventToInstance();

    private Sql context;

    // constructors
    private CreateEventToInstanceImpl( Sql context ) {
        this.context = context;
        ref_Statement_ID = UniqueId.random();
        ref_Var_ID = UniqueId.random();
        R704_is_a_CreateSMEventStatement_inst = CreateSMEventStatementImpl.EMPTY_CREATESMEVENTSTATEMENT;
        R711_has_recipient_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
    }

    private CreateEventToInstanceImpl( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Var_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Statement_ID = ref_Statement_ID;
        this.ref_Var_ID = ref_Var_ID;
        R704_is_a_CreateSMEventStatement_inst = CreateSMEventStatementImpl.EMPTY_CREATESMEVENTSTATEMENT;
        R711_has_recipient_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
    }

    public static CreateEventToInstance create( Sql context ) throws XtumlException {
        CreateEventToInstance newCreateEventToInstance = new CreateEventToInstanceImpl( context );
        if ( context.addInstance( newCreateEventToInstance ) ) {
            newCreateEventToInstance.getRunContext().addChange(new InstanceCreatedDelta(newCreateEventToInstance, KEY_LETTERS));
            return newCreateEventToInstance;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static CreateEventToInstance create( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Var_ID ) throws XtumlException {
        CreateEventToInstance newCreateEventToInstance = new CreateEventToInstanceImpl( context, instanceId, ref_Statement_ID, ref_Var_ID );
        if ( context.addInstance( newCreateEventToInstance ) ) {
            return newCreateEventToInstance;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Statement_ID;
    @Override
    public void setStatement_ID(UniqueId ref_Statement_ID) throws XtumlException {
        checkLiving();
        if (ref_Statement_ID.inequality( this.ref_Statement_ID)) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
        }
    }
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
        return ref_Statement_ID;
    }
    private UniqueId ref_Var_ID;
    @Override
    public UniqueId getVar_ID() throws XtumlException {
        checkLiving();
        return ref_Var_ID;
    }
    @Override
    public void setVar_ID(UniqueId ref_Var_ID) throws XtumlException {
        checkLiving();
        if (ref_Var_ID.inequality( this.ref_Var_ID)) {
            final UniqueId oldValue = this.ref_Var_ID;
            this.ref_Var_ID = ref_Var_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Var_ID", oldValue, this.ref_Var_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStatement_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private CreateSMEventStatement R704_is_a_CreateSMEventStatement_inst;
    @Override
    public void setR704_is_a_CreateSMEventStatement( CreateSMEventStatement inst ) {
        R704_is_a_CreateSMEventStatement_inst = inst;
    }
    @Override
    public CreateSMEventStatement R704_is_a_CreateSMEventStatement() throws XtumlException {
        return R704_is_a_CreateSMEventStatement_inst;
    }
    private V_VAR R711_has_recipient_V_VAR_inst;
    @Override
    public void setR711_has_recipient_V_VAR( V_VAR inst ) {
        R711_has_recipient_V_VAR_inst = inst;
    }
    @Override
    public V_VAR R711_has_recipient_V_VAR() throws XtumlException {
        return R711_has_recipient_V_VAR_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public CreateEventToInstance self() {
        return this;
    }

    @Override
    public CreateEventToInstance oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_CREATEEVENTTOINSTANCE;
    }

}

class EmptyCreateEventToInstance extends ModelInstance<CreateEventToInstance,Sql> implements CreateEventToInstance {

    // attributes
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getVar_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setVar_ID( UniqueId ref_Var_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public CreateSMEventStatement R704_is_a_CreateSMEventStatement() {
        return CreateSMEventStatementImpl.EMPTY_CREATESMEVENTSTATEMENT;
    }
    @Override
    public V_VAR R711_has_recipient_V_VAR() {
        return V_VARImpl.EMPTY_V_VAR;
    }


    @Override
    public String getKeyLetters() {
        return CreateEventToInstanceImpl.KEY_LETTERS;
    }

    @Override
    public CreateEventToInstance self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public CreateEventToInstance oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return CreateEventToInstanceImpl.EMPTY_CREATEEVENTTOINSTANCE;
    }

}
