package io.ciera.tool.sql.ooaofooa.domain.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.domain.DataType;
import io.ciera.tool.sql.ooaofooa.domain.StructureMember;
import io.ciera.tool.sql.ooaofooa.domain.StructureMemberSet;
import io.ciera.tool.sql.ooaofooa.domain.StructuredDataType;
import io.ciera.tool.sql.ooaofooa.domain.impl.DataTypeImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.StructureMemberSetImpl;


public class StructuredDataTypeImpl extends ModelInstance<StructuredDataType,Sql> implements StructuredDataType {

    public static final String KEY_LETTERS = "S_SDT";
    public static final StructuredDataType EMPTY_STRUCTUREDDATATYPE = new EmptyStructuredDataType();

    private Sql context;

    // constructors
    private StructuredDataTypeImpl( Sql context ) {
        this.context = context;
        ref_DT_ID = UniqueId.random();
        R17_is_a_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R44_has_member_StructureMember_set = new StructureMemberSetImpl();
    }

    private StructuredDataTypeImpl( Sql context, UniqueId instanceId, UniqueId ref_DT_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_DT_ID = ref_DT_ID;
        R17_is_a_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R44_has_member_StructureMember_set = new StructureMemberSetImpl();
    }

    public static StructuredDataType create( Sql context ) throws XtumlException {
        StructuredDataType newStructuredDataType = new StructuredDataTypeImpl( context );
        if ( context.addInstance( newStructuredDataType ) ) {
            newStructuredDataType.getRunContext().addChange(new InstanceCreatedDelta(newStructuredDataType, KEY_LETTERS));
            return newStructuredDataType;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static StructuredDataType create( Sql context, UniqueId instanceId, UniqueId ref_DT_ID ) throws XtumlException {
        StructuredDataType newStructuredDataType = new StructuredDataTypeImpl( context, instanceId, ref_DT_ID );
        if ( context.addInstance( newStructuredDataType ) ) {
            return newStructuredDataType;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_DT_ID;
    @Override
    public void setDT_ID(UniqueId ref_DT_ID) throws XtumlException {
        checkLiving();
        if (ref_DT_ID.inequality( this.ref_DT_ID)) {
            final UniqueId oldValue = this.ref_DT_ID;
            this.ref_DT_ID = ref_DT_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_DT_ID", oldValue, this.ref_DT_ID));
            if ( !R44_has_member_StructureMember().isEmpty() ) R44_has_member_StructureMember().setParent_DT_DT_ID( ref_DT_ID );
        }
    }
    @Override
    public UniqueId getDT_ID() throws XtumlException {
        checkLiving();
        return ref_DT_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getDT_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private DataType R17_is_a_DataType_inst;
    @Override
    public void setR17_is_a_DataType( DataType inst ) {
        R17_is_a_DataType_inst = inst;
    }
    @Override
    public DataType R17_is_a_DataType() throws XtumlException {
        return R17_is_a_DataType_inst;
    }
    private StructureMemberSet R44_has_member_StructureMember_set;
    @Override
    public void addR44_has_member_StructureMember( StructureMember inst ) {
        R44_has_member_StructureMember_set.add(inst);
    }
    @Override
    public void removeR44_has_member_StructureMember( StructureMember inst ) {
        R44_has_member_StructureMember_set.remove(inst);
    }
    @Override
    public StructureMemberSet R44_has_member_StructureMember() throws XtumlException {
        return R44_has_member_StructureMember_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public StructuredDataType self() {
        return this;
    }

    @Override
    public StructuredDataType oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_STRUCTUREDDATATYPE;
    }

}

class EmptyStructuredDataType extends ModelInstance<StructuredDataType,Sql> implements StructuredDataType {

    // attributes
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getDT_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public DataType R17_is_a_DataType() {
        return DataTypeImpl.EMPTY_DATATYPE;
    }
    @Override
    public StructureMemberSet R44_has_member_StructureMember() {
        return (new StructureMemberSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return StructuredDataTypeImpl.KEY_LETTERS;
    }

    @Override
    public StructuredDataType self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public StructuredDataType oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return StructuredDataTypeImpl.EMPTY_STRUCTUREDDATATYPE;
    }

}
