package io.ciera.tool.sql.ooaofooa.domain.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.domain.Range;
import io.ciera.tool.sql.ooaofooa.domain.UserDataType;
import io.ciera.tool.sql.ooaofooa.domain.impl.UserDataTypeImpl;


public class RangeImpl extends ModelInstance<Range,Sql> implements Range {

    public static final String KEY_LETTERS = "S_RANGE";
    public static final Range EMPTY_RANGE = new EmptyRange();

    private Sql context;

    // constructors
    private RangeImpl( Sql context ) {
        this.context = context;
        ref_DT_ID = UniqueId.random();
        m_Min = "";
        m_Max = "";
        R57_spans_UserDataType_inst = UserDataTypeImpl.EMPTY_USERDATATYPE;
    }

    private RangeImpl( Sql context, UniqueId instanceId, UniqueId ref_DT_ID, String m_Min, String m_Max ) {
        super(instanceId);
        this.context = context;
        this.ref_DT_ID = ref_DT_ID;
        this.m_Min = m_Min;
        this.m_Max = m_Max;
        R57_spans_UserDataType_inst = UserDataTypeImpl.EMPTY_USERDATATYPE;
    }

    public static Range create( Sql context ) throws XtumlException {
        Range newRange = new RangeImpl( context );
        if ( context.addInstance( newRange ) ) {
            newRange.getRunContext().addChange(new InstanceCreatedDelta(newRange, KEY_LETTERS));
            return newRange;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Range create( Sql context, UniqueId instanceId, UniqueId ref_DT_ID, String m_Min, String m_Max ) throws XtumlException {
        Range newRange = new RangeImpl( context, instanceId, ref_DT_ID, m_Min, m_Max );
        if ( context.addInstance( newRange ) ) {
            return newRange;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_DT_ID;
    @Override
    public void setDT_ID(UniqueId ref_DT_ID) throws XtumlException {
        checkLiving();
        if (ref_DT_ID.inequality( this.ref_DT_ID)) {
            final UniqueId oldValue = this.ref_DT_ID;
            this.ref_DT_ID = ref_DT_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_DT_ID", oldValue, this.ref_DT_ID));
        }
    }
    @Override
    public UniqueId getDT_ID() throws XtumlException {
        checkLiving();
        return ref_DT_ID;
    }
    private String m_Min;
    @Override
    public String getMin() throws XtumlException {
        checkLiving();
        return m_Min;
    }
    @Override
    public void setMin(String m_Min) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Min, this.m_Min)) {
            final String oldValue = this.m_Min;
            this.m_Min = m_Min;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Min", oldValue, this.m_Min));
        }
    }
    private String m_Max;
    @Override
    public String getMax() throws XtumlException {
        checkLiving();
        return m_Max;
    }
    @Override
    public void setMax(String m_Max) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Max, this.m_Max)) {
            final String oldValue = this.m_Max;
            this.m_Max = m_Max;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Max", oldValue, this.m_Max));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getDT_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private UserDataType R57_spans_UserDataType_inst;
    @Override
    public void setR57_spans_UserDataType( UserDataType inst ) {
        R57_spans_UserDataType_inst = inst;
    }
    @Override
    public UserDataType R57_spans_UserDataType() throws XtumlException {
        return R57_spans_UserDataType_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Range self() {
        return this;
    }

    @Override
    public Range oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_RANGE;
    }

}

class EmptyRange extends ModelInstance<Range,Sql> implements Range {

    // attributes
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getDT_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getMin() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setMin( String m_Min ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getMax() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setMax( String m_Max ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public UserDataType R57_spans_UserDataType() {
        return UserDataTypeImpl.EMPTY_USERDATATYPE;
    }


    @Override
    public String getKeyLetters() {
        return RangeImpl.KEY_LETTERS;
    }

    @Override
    public Range self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Range oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return RangeImpl.EMPTY_RANGE;
    }

}
