package io.ciera.tool.sql.ooaofooa.constants.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.ooaofooa.constants.ConstantSpecificationSet;
import io.ciera.tool.sql.ooaofooa.constants.LeafSymbolicConstantSet;
import io.ciera.tool.sql.ooaofooa.constants.SymbolicConstant;
import io.ciera.tool.sql.ooaofooa.constants.SymbolicConstantSet;
import io.ciera.tool.sql.ooaofooa.constants.impl.ConstantSpecificationSetImpl;
import io.ciera.tool.sql.ooaofooa.constants.impl.LeafSymbolicConstantSetImpl;
import io.ciera.tool.sql.ooaofooa.constants.impl.SymbolicConstantSetImpl;
import io.ciera.tool.sql.ooaofooa.domain.DataTypeSet;
import io.ciera.tool.sql.ooaofooa.domain.impl.DataTypeSetImpl;
import io.ciera.tool.sql.ooaofooa.value.SymbolicConstantValueSet;
import io.ciera.tool.sql.ooaofooa.value.impl.SymbolicConstantValueSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class SymbolicConstantSetImpl extends InstanceSet<SymbolicConstantSet,SymbolicConstant> implements SymbolicConstantSet {

    public SymbolicConstantSetImpl() {
    }

    public SymbolicConstantSetImpl(Comparator<? super SymbolicConstant> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setPrevious_Const_ID( UniqueId ref_Previous_Const_ID ) throws XtumlException {
        for ( SymbolicConstant symbolicconstant : this ) symbolicconstant.setPrevious_Const_ID( ref_Previous_Const_ID );
    }
    @Override
    public void setName( String m_Name ) throws XtumlException {
        for ( SymbolicConstant symbolicconstant : this ) symbolicconstant.setName( m_Name );
    }
    @Override
    public void setConst_ID( UniqueId m_Const_ID ) throws XtumlException {
        for ( SymbolicConstant symbolicconstant : this ) symbolicconstant.setConst_ID( m_Const_ID );
    }
    @Override
    public void setPrevious_DT_DT_ID_Deprecated( UniqueId m_Previous_DT_DT_ID_Deprecated ) throws XtumlException {
        for ( SymbolicConstant symbolicconstant : this ) symbolicconstant.setPrevious_DT_DT_ID_Deprecated( m_Previous_DT_DT_ID_Deprecated );
    }
    @Override
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        for ( SymbolicConstant symbolicconstant : this ) symbolicconstant.setDT_ID( ref_DT_ID );
    }
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        for ( SymbolicConstant symbolicconstant : this ) symbolicconstant.setDescrip( m_Descrip );
    }
    @Override
    public void setConstant_Spec_ID( UniqueId ref_Constant_Spec_ID ) throws XtumlException {
        for ( SymbolicConstant symbolicconstant : this ) symbolicconstant.setConstant_Spec_ID( ref_Constant_Spec_ID );
    }


    // selections
    @Override
    public DataTypeSet R1500_is_defined_by_DataType() throws XtumlException {
        DataTypeSet datatypeset = new DataTypeSetImpl();
        for ( SymbolicConstant symbolicconstant : this ) datatypeset.add( symbolicconstant.R1500_is_defined_by_DataType() );
        return datatypeset;
    }
    @Override
    public LeafSymbolicConstantSet R1502_is_a_LeafSymbolicConstant() throws XtumlException {
        LeafSymbolicConstantSet leafsymbolicconstantset = new LeafSymbolicConstantSetImpl();
        for ( SymbolicConstant symbolicconstant : this ) leafsymbolicconstantset.add( symbolicconstant.R1502_is_a_LeafSymbolicConstant() );
        return leafsymbolicconstantset;
    }
    @Override
    public ConstantSpecificationSet R1504_is_contained_by_ConstantSpecification() throws XtumlException {
        ConstantSpecificationSet constantspecificationset = new ConstantSpecificationSetImpl();
        for ( SymbolicConstant symbolicconstant : this ) constantspecificationset.add( symbolicconstant.R1504_is_contained_by_ConstantSpecification() );
        return constantspecificationset;
    }
    @Override
    public SymbolicConstantSet R1505_precedes_SymbolicConstant() throws XtumlException {
        SymbolicConstantSet symbolicconstantset = new SymbolicConstantSetImpl();
        for ( SymbolicConstant symbolicconstant : this ) symbolicconstantset.add( symbolicconstant.R1505_precedes_SymbolicConstant() );
        return symbolicconstantset;
    }
    @Override
    public SymbolicConstantSet R1505_succeeds_SymbolicConstant() throws XtumlException {
        SymbolicConstantSet symbolicconstantset = new SymbolicConstantSetImpl();
        for ( SymbolicConstant symbolicconstant : this ) symbolicconstantset.add( symbolicconstant.R1505_succeeds_SymbolicConstant() );
        return symbolicconstantset;
    }
    @Override
    public SymbolicConstantValueSet R850_SymbolicConstantValue() throws XtumlException {
        SymbolicConstantValueSet symbolicconstantvalueset = new SymbolicConstantValueSetImpl();
        for ( SymbolicConstant symbolicconstant : this ) symbolicconstantvalueset.addAll( symbolicconstant.R850_SymbolicConstantValue() );
        return symbolicconstantvalueset;
    }


    @Override
    public SymbolicConstant nullElement() {
        return SymbolicConstantImpl.EMPTY_SYMBOLICCONSTANT;
    }

    @Override
    public SymbolicConstantSet emptySet() {
      return new SymbolicConstantSetImpl();
    }

    @Override
    public SymbolicConstantSet emptySet(Comparator<? super SymbolicConstant> comp) {
      return new SymbolicConstantSetImpl(comp);
    }

    @Override
    public List<SymbolicConstant> elements() {
        SymbolicConstant[] elements = toArray(new SymbolicConstant[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
