package io.ciera.tool.sql.ooaofooa.constants.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.constants.LeafSymbolicConstant;
import io.ciera.tool.sql.ooaofooa.constants.LiteralSymbolicConstant;
import io.ciera.tool.sql.ooaofooa.constants.SymbolicConstant;
import io.ciera.tool.sql.ooaofooa.constants.impl.LiteralSymbolicConstantImpl;
import io.ciera.tool.sql.ooaofooa.constants.impl.SymbolicConstantImpl;


public class LeafSymbolicConstantImpl extends ModelInstance<LeafSymbolicConstant,Sql> implements LeafSymbolicConstant {

    public static final String KEY_LETTERS = "CNST_LFSC";
    public static final LeafSymbolicConstant EMPTY_LEAFSYMBOLICCONSTANT = new EmptyLeafSymbolicConstant();

    private Sql context;

    // constructors
    private LeafSymbolicConstantImpl( Sql context ) {
        this.context = context;
        ref_Const_ID = UniqueId.random();
        m_DT_ID_Deprecated = UniqueId.random();
        R1502_is_a_SymbolicConstant_inst = SymbolicConstantImpl.EMPTY_SYMBOLICCONSTANT;
        R1503_is_a_LiteralSymbolicConstant_inst = LiteralSymbolicConstantImpl.EMPTY_LITERALSYMBOLICCONSTANT;
    }

    private LeafSymbolicConstantImpl( Sql context, UniqueId instanceId, UniqueId ref_Const_ID, UniqueId m_DT_ID_Deprecated ) {
        super(instanceId);
        this.context = context;
        this.ref_Const_ID = ref_Const_ID;
        this.m_DT_ID_Deprecated = m_DT_ID_Deprecated;
        R1502_is_a_SymbolicConstant_inst = SymbolicConstantImpl.EMPTY_SYMBOLICCONSTANT;
        R1503_is_a_LiteralSymbolicConstant_inst = LiteralSymbolicConstantImpl.EMPTY_LITERALSYMBOLICCONSTANT;
    }

    public static LeafSymbolicConstant create( Sql context ) throws XtumlException {
        LeafSymbolicConstant newLeafSymbolicConstant = new LeafSymbolicConstantImpl( context );
        if ( context.addInstance( newLeafSymbolicConstant ) ) {
            newLeafSymbolicConstant.getRunContext().addChange(new InstanceCreatedDelta(newLeafSymbolicConstant, KEY_LETTERS));
            return newLeafSymbolicConstant;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static LeafSymbolicConstant create( Sql context, UniqueId instanceId, UniqueId ref_Const_ID, UniqueId m_DT_ID_Deprecated ) throws XtumlException {
        LeafSymbolicConstant newLeafSymbolicConstant = new LeafSymbolicConstantImpl( context, instanceId, ref_Const_ID, m_DT_ID_Deprecated );
        if ( context.addInstance( newLeafSymbolicConstant ) ) {
            return newLeafSymbolicConstant;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Const_ID;
    @Override
    public void setConst_ID(UniqueId ref_Const_ID) throws XtumlException {
        checkLiving();
        if (ref_Const_ID.inequality( this.ref_Const_ID)) {
            final UniqueId oldValue = this.ref_Const_ID;
            this.ref_Const_ID = ref_Const_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Const_ID", oldValue, this.ref_Const_ID));
            if ( !R1503_is_a_LiteralSymbolicConstant().isEmpty() ) R1503_is_a_LiteralSymbolicConstant().setConst_ID( ref_Const_ID );
        }
    }
    @Override
    public UniqueId getConst_ID() throws XtumlException {
        checkLiving();
        return ref_Const_ID;
    }
    private UniqueId m_DT_ID_Deprecated;
    @Override
    public UniqueId getDT_ID_Deprecated() throws XtumlException {
        checkLiving();
        return m_DT_ID_Deprecated;
    }
    @Override
    public void setDT_ID_Deprecated(UniqueId m_DT_ID_Deprecated) throws XtumlException {
        checkLiving();
        if (m_DT_ID_Deprecated.inequality( this.m_DT_ID_Deprecated)) {
            final UniqueId oldValue = this.m_DT_ID_Deprecated;
            this.m_DT_ID_Deprecated = m_DT_ID_Deprecated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_DT_ID_Deprecated", oldValue, this.m_DT_ID_Deprecated));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getConst_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private SymbolicConstant R1502_is_a_SymbolicConstant_inst;
    @Override
    public void setR1502_is_a_SymbolicConstant( SymbolicConstant inst ) {
        R1502_is_a_SymbolicConstant_inst = inst;
    }
    @Override
    public SymbolicConstant R1502_is_a_SymbolicConstant() throws XtumlException {
        return R1502_is_a_SymbolicConstant_inst;
    }
    private LiteralSymbolicConstant R1503_is_a_LiteralSymbolicConstant_inst;
    @Override
    public void setR1503_is_a_LiteralSymbolicConstant( LiteralSymbolicConstant inst ) {
        R1503_is_a_LiteralSymbolicConstant_inst = inst;
    }
    @Override
    public LiteralSymbolicConstant R1503_is_a_LiteralSymbolicConstant() throws XtumlException {
        return R1503_is_a_LiteralSymbolicConstant_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public LeafSymbolicConstant self() {
        return this;
    }

    @Override
    public LeafSymbolicConstant oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_LEAFSYMBOLICCONSTANT;
    }

}

class EmptyLeafSymbolicConstant extends ModelInstance<LeafSymbolicConstant,Sql> implements LeafSymbolicConstant {

    // attributes
    public void setConst_ID( UniqueId ref_Const_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getConst_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getDT_ID_Deprecated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDT_ID_Deprecated( UniqueId m_DT_ID_Deprecated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public SymbolicConstant R1502_is_a_SymbolicConstant() {
        return SymbolicConstantImpl.EMPTY_SYMBOLICCONSTANT;
    }
    @Override
    public LiteralSymbolicConstant R1503_is_a_LiteralSymbolicConstant() {
        return LiteralSymbolicConstantImpl.EMPTY_LITERALSYMBOLICCONSTANT;
    }


    @Override
    public String getKeyLetters() {
        return LeafSymbolicConstantImpl.KEY_LETTERS;
    }

    @Override
    public LeafSymbolicConstant self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public LeafSymbolicConstant oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return LeafSymbolicConstantImpl.EMPTY_LEAFSYMBOLICCONSTANT;
    }

}
