package io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.ProvidedOperationBody;
import io.ciera.tool.sql.ooaofooa.body.impl.ProvidedOperationBodyImpl;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.ProvidedExecutableProperty;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.ProvidedOperation;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.impl.ProvidedExecutablePropertyImpl;
import io.ciera.tool.sql.ooaofooa.invocation.InterfaceOperationInvocation;
import io.ciera.tool.sql.ooaofooa.invocation.InterfaceOperationInvocationSet;
import io.ciera.tool.sql.ooaofooa.invocation.impl.InterfaceOperationInvocationSetImpl;

import ooaofooa.datatypes.ActionDialect;
import ooaofooa.datatypes.ParseStatus;


public class ProvidedOperationImpl extends ModelInstance<ProvidedOperation,Sql> implements ProvidedOperation {

    public static final String KEY_LETTERS = "SPR_PO";
    public static final ProvidedOperation EMPTY_PROVIDEDOPERATION = new EmptyProvidedOperation();

    private Sql context;

    // constructors
    private ProvidedOperationImpl( Sql context ) {
        this.context = context;
        ref_Id = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        m_Action_Semantics = "";
        m_Action_Semantics_internal = "";
        m_Suc_Pars = ParseStatus.UNINITIALIZED_ENUM;
        m_Dialect = ActionDialect.UNINITIALIZED_ENUM;
        R4503_is_a_ProvidedExecutableProperty_inst = ProvidedExecutablePropertyImpl.EMPTY_PROVIDEDEXECUTABLEPROPERTY;
        R680_InterfaceOperationInvocation_set = new InterfaceOperationInvocationSetImpl();
        R687_ProvidedOperationBody_inst = ProvidedOperationBodyImpl.EMPTY_PROVIDEDOPERATIONBODY;
    }

    private ProvidedOperationImpl( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Name, String m_Descrip, String m_Action_Semantics, String m_Action_Semantics_internal, ParseStatus m_Suc_Pars, ActionDialect m_Dialect ) {
        super(instanceId);
        this.context = context;
        this.ref_Id = ref_Id;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        this.m_Action_Semantics = m_Action_Semantics;
        this.m_Action_Semantics_internal = m_Action_Semantics_internal;
        this.m_Suc_Pars = m_Suc_Pars;
        this.m_Dialect = m_Dialect;
        R4503_is_a_ProvidedExecutableProperty_inst = ProvidedExecutablePropertyImpl.EMPTY_PROVIDEDEXECUTABLEPROPERTY;
        R680_InterfaceOperationInvocation_set = new InterfaceOperationInvocationSetImpl();
        R687_ProvidedOperationBody_inst = ProvidedOperationBodyImpl.EMPTY_PROVIDEDOPERATIONBODY;
    }

    public static ProvidedOperation create( Sql context ) throws XtumlException {
        ProvidedOperation newProvidedOperation = new ProvidedOperationImpl( context );
        if ( context.addInstance( newProvidedOperation ) ) {
            newProvidedOperation.getRunContext().addChange(new InstanceCreatedDelta(newProvidedOperation, KEY_LETTERS));
            return newProvidedOperation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ProvidedOperation create( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Name, String m_Descrip, String m_Action_Semantics, String m_Action_Semantics_internal, ParseStatus m_Suc_Pars, ActionDialect m_Dialect ) throws XtumlException {
        ProvidedOperation newProvidedOperation = new ProvidedOperationImpl( context, instanceId, ref_Id, m_Name, m_Descrip, m_Action_Semantics, m_Action_Semantics_internal, m_Suc_Pars, m_Dialect );
        if ( context.addInstance( newProvidedOperation ) ) {
            return newProvidedOperation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Id;
    @Override
    public void setId(UniqueId ref_Id) throws XtumlException {
        checkLiving();
        if (ref_Id.inequality( this.ref_Id)) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
            if ( !R687_ProvidedOperationBody().isEmpty() ) R687_ProvidedOperationBody().setId( ref_Id );
            if ( !R680_InterfaceOperationInvocation().isEmpty() ) R680_InterfaceOperationInvocation().setProvidedOp_Id( ref_Id );
        }
    }
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
        return ref_Id;
    }
    private String m_Name;
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    private String m_Descrip;
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    private String m_Action_Semantics;
    @Override
    public void setAction_Semantics(String m_Action_Semantics) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Action_Semantics, this.m_Action_Semantics)) {
            final String oldValue = this.m_Action_Semantics;
            this.m_Action_Semantics = m_Action_Semantics;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Action_Semantics", oldValue, this.m_Action_Semantics));
        }
    }
    @Override
    public String getAction_Semantics() throws XtumlException {
        checkLiving();
        return m_Action_Semantics;
    }
    private String m_Action_Semantics_internal;
    @Override
    public void setAction_Semantics_internal(String m_Action_Semantics_internal) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Action_Semantics_internal, this.m_Action_Semantics_internal)) {
            final String oldValue = this.m_Action_Semantics_internal;
            this.m_Action_Semantics_internal = m_Action_Semantics_internal;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Action_Semantics_internal", oldValue, this.m_Action_Semantics_internal));
        }
    }
    @Override
    public String getAction_Semantics_internal() throws XtumlException {
        checkLiving();
        return m_Action_Semantics_internal;
    }
    private ParseStatus m_Suc_Pars;
    @Override
    public ParseStatus getSuc_Pars() throws XtumlException {
        checkLiving();
        return m_Suc_Pars;
    }
    @Override
    public void setSuc_Pars(ParseStatus m_Suc_Pars) throws XtumlException {
        checkLiving();
        if (m_Suc_Pars.inequality( this.m_Suc_Pars)) {
            final ParseStatus oldValue = this.m_Suc_Pars;
            this.m_Suc_Pars = m_Suc_Pars;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Suc_Pars", oldValue, this.m_Suc_Pars));
        }
    }
    private ActionDialect m_Dialect;
    @Override
    public ActionDialect getDialect() throws XtumlException {
        checkLiving();
        return m_Dialect;
    }
    @Override
    public void setDialect(ActionDialect m_Dialect) throws XtumlException {
        checkLiving();
        if (m_Dialect.inequality( this.m_Dialect)) {
            final ActionDialect oldValue = this.m_Dialect;
            this.m_Dialect = m_Dialect;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Dialect", oldValue, this.m_Dialect));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ProvidedExecutableProperty R4503_is_a_ProvidedExecutableProperty_inst;
    @Override
    public void setR4503_is_a_ProvidedExecutableProperty( ProvidedExecutableProperty inst ) {
        R4503_is_a_ProvidedExecutableProperty_inst = inst;
    }
    @Override
    public ProvidedExecutableProperty R4503_is_a_ProvidedExecutableProperty() throws XtumlException {
        return R4503_is_a_ProvidedExecutableProperty_inst;
    }
    private InterfaceOperationInvocationSet R680_InterfaceOperationInvocation_set;
    @Override
    public void addR680_InterfaceOperationInvocation( InterfaceOperationInvocation inst ) {
        R680_InterfaceOperationInvocation_set.add(inst);
    }
    @Override
    public void removeR680_InterfaceOperationInvocation( InterfaceOperationInvocation inst ) {
        R680_InterfaceOperationInvocation_set.remove(inst);
    }
    @Override
    public InterfaceOperationInvocationSet R680_InterfaceOperationInvocation() throws XtumlException {
        return R680_InterfaceOperationInvocation_set;
    }
    private ProvidedOperationBody R687_ProvidedOperationBody_inst;
    @Override
    public void setR687_ProvidedOperationBody( ProvidedOperationBody inst ) {
        R687_ProvidedOperationBody_inst = inst;
    }
    @Override
    public ProvidedOperationBody R687_ProvidedOperationBody() throws XtumlException {
        return R687_ProvidedOperationBody_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ProvidedOperation self() {
        return this;
    }

    @Override
    public ProvidedOperation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_PROVIDEDOPERATION;
    }

}

class EmptyProvidedOperation extends ModelInstance<ProvidedOperation,Sql> implements ProvidedOperation {

    // attributes
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setAction_Semantics( String m_Action_Semantics ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getAction_Semantics() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAction_Semantics_internal( String m_Action_Semantics_internal ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getAction_Semantics_internal() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public ParseStatus getSuc_Pars() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSuc_Pars( ParseStatus m_Suc_Pars ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public ActionDialect getDialect() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDialect( ActionDialect m_Dialect ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ProvidedExecutableProperty R4503_is_a_ProvidedExecutableProperty() {
        return ProvidedExecutablePropertyImpl.EMPTY_PROVIDEDEXECUTABLEPROPERTY;
    }
    @Override
    public InterfaceOperationInvocationSet R680_InterfaceOperationInvocation() {
        return (new InterfaceOperationInvocationSetImpl());
    }
    @Override
    public ProvidedOperationBody R687_ProvidedOperationBody() {
        return ProvidedOperationBodyImpl.EMPTY_PROVIDEDOPERATIONBODY;
    }


    @Override
    public String getKeyLetters() {
        return ProvidedOperationImpl.KEY_LETTERS;
    }

    @Override
    public ProvidedOperation self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ProvidedOperation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ProvidedOperationImpl.EMPTY_PROVIDEDOPERATION;
    }

}
