package io.ciera.tool.sql.ooaofooa.component.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.ooaofooa.component.InterfaceReferenceSet;
import io.ciera.tool.sql.ooaofooa.component.Requirement;
import io.ciera.tool.sql.ooaofooa.component.RequirementSet;
import io.ciera.tool.sql.ooaofooa.component.SatisfactionSet;
import io.ciera.tool.sql.ooaofooa.component.impl.InterfaceReferenceSetImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.SatisfactionSetImpl;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.RequiredExecutablePropertySet;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.impl.RequiredExecutablePropertySetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class RequirementSetImpl extends InstanceSet<RequirementSet,Requirement> implements RequirementSet {

    public RequirementSetImpl() {
    }

    public RequirementSetImpl(Comparator<? super Requirement> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setReversePathFromComponent( String m_reversePathFromComponent ) throws XtumlException {
        for ( Requirement requirement : this ) requirement.setReversePathFromComponent( m_reversePathFromComponent );
    }
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        for ( Requirement requirement : this ) requirement.setDescrip( m_Descrip );
    }
    @Override
    public void setInformalName( String m_InformalName ) throws XtumlException {
        for ( Requirement requirement : this ) requirement.setInformalName( m_InformalName );
    }
    @Override
    public void setRequirement_Id( UniqueId ref_Requirement_Id ) throws XtumlException {
        for ( Requirement requirement : this ) requirement.setRequirement_Id( ref_Requirement_Id );
    }
    @Override
    public void setName( String m_Name ) throws XtumlException {
        for ( Requirement requirement : this ) requirement.setName( m_Name );
    }


    // selections
    @Override
    public SatisfactionSet R4002_satisfies_Satisfaction() throws XtumlException {
        SatisfactionSet satisfactionset = new SatisfactionSetImpl();
        for ( Requirement requirement : this ) satisfactionset.addAll( requirement.R4002_satisfies_Satisfaction() );
        return satisfactionset;
    }
    @Override
    public InterfaceReferenceSet R4009_is_a_InterfaceReference() throws XtumlException {
        InterfaceReferenceSet interfacereferenceset = new InterfaceReferenceSetImpl();
        for ( Requirement requirement : this ) interfacereferenceset.add( requirement.R4009_is_a_InterfaceReference() );
        return interfacereferenceset;
    }
    @Override
    public RequiredExecutablePropertySet R4500_implements_RequiredExecutableProperty() throws XtumlException {
        RequiredExecutablePropertySet requiredexecutablepropertyset = new RequiredExecutablePropertySetImpl();
        for ( Requirement requirement : this ) requiredexecutablepropertyset.addAll( requirement.R4500_implements_RequiredExecutableProperty() );
        return requiredexecutablepropertyset;
    }


    @Override
    public Requirement nullElement() {
        return RequirementImpl.EMPTY_REQUIREMENT;
    }

    @Override
    public RequirementSet emptySet() {
      return new RequirementSetImpl();
    }

    @Override
    public RequirementSet emptySet(Comparator<? super Requirement> comp) {
      return new RequirementSetImpl(comp);
    }

    @Override
    public List<Requirement> elements() {
        Requirement[] elements = toArray(new Requirement[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
