package io.ciera.tool.sql.ooaofooa.component.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.C_I;
import io.ciera.tool.sql.ooaofooa.component.ExecutableProperty;
import io.ciera.tool.sql.ooaofooa.component.InterfaceOperation;
import io.ciera.tool.sql.ooaofooa.component.InterfaceSignal;
import io.ciera.tool.sql.ooaofooa.component.PropertyParameter;
import io.ciera.tool.sql.ooaofooa.component.PropertyParameterSet;
import io.ciera.tool.sql.ooaofooa.component.impl.C_IImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.InterfaceOperationImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.InterfaceSignalImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.PropertyParameterSetImpl;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.ProvidedExecutableProperty;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.ProvidedExecutablePropertySet;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.RequiredExecutableProperty;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.RequiredExecutablePropertySet;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.impl.ProvidedExecutablePropertySetImpl;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.impl.RequiredExecutablePropertySetImpl;

import ooaofooa.datatypes.IFDirectionType;


public class ExecutablePropertyImpl extends ModelInstance<ExecutableProperty,Sql> implements ExecutableProperty {

    public static final String KEY_LETTERS = "C_EP";
    public static final ExecutableProperty EMPTY_EXECUTABLEPROPERTY = new EmptyExecutableProperty();

    private Sql context;

    // constructors
    private ExecutablePropertyImpl( Sql context ) {
        this.context = context;
        m_Id = UniqueId.random();
        ref_Interface_Id = UniqueId.random();
        m_Direction = IFDirectionType.UNINITIALIZED_ENUM;
        m_Name = "";
        m_Descrip = "";
        R4003_provides_signature_of_C_I_inst = C_IImpl.EMPTY_C_I;
        R4004_is_a_InterfaceOperation_inst = InterfaceOperationImpl.EMPTY_INTERFACEOPERATION;
        R4004_is_a_InterfaceSignal_inst = InterfaceSignalImpl.EMPTY_INTERFACESIGNAL;
        R4006_is_parameter_to_PropertyParameter_set = new PropertyParameterSetImpl();
        R4500_is_implemented_by_RequiredExecutableProperty_set = new RequiredExecutablePropertySetImpl();
        R4501_is_implemented_by_ProvidedExecutableProperty_set = new ProvidedExecutablePropertySetImpl();
    }

    private ExecutablePropertyImpl( Sql context, UniqueId instanceId, UniqueId m_Id, UniqueId ref_Interface_Id, IFDirectionType m_Direction, String m_Name, String m_Descrip ) {
        super(instanceId);
        this.context = context;
        this.m_Id = m_Id;
        this.ref_Interface_Id = ref_Interface_Id;
        this.m_Direction = m_Direction;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        R4003_provides_signature_of_C_I_inst = C_IImpl.EMPTY_C_I;
        R4004_is_a_InterfaceOperation_inst = InterfaceOperationImpl.EMPTY_INTERFACEOPERATION;
        R4004_is_a_InterfaceSignal_inst = InterfaceSignalImpl.EMPTY_INTERFACESIGNAL;
        R4006_is_parameter_to_PropertyParameter_set = new PropertyParameterSetImpl();
        R4500_is_implemented_by_RequiredExecutableProperty_set = new RequiredExecutablePropertySetImpl();
        R4501_is_implemented_by_ProvidedExecutableProperty_set = new ProvidedExecutablePropertySetImpl();
    }

    public static ExecutableProperty create( Sql context ) throws XtumlException {
        ExecutableProperty newExecutableProperty = new ExecutablePropertyImpl( context );
        if ( context.addInstance( newExecutableProperty ) ) {
            newExecutableProperty.getRunContext().addChange(new InstanceCreatedDelta(newExecutableProperty, KEY_LETTERS));
            return newExecutableProperty;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ExecutableProperty create( Sql context, UniqueId instanceId, UniqueId m_Id, UniqueId ref_Interface_Id, IFDirectionType m_Direction, String m_Name, String m_Descrip ) throws XtumlException {
        ExecutableProperty newExecutableProperty = new ExecutablePropertyImpl( context, instanceId, m_Id, ref_Interface_Id, m_Direction, m_Name, m_Descrip );
        if ( context.addInstance( newExecutableProperty ) ) {
            return newExecutableProperty;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Id;
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
        return m_Id;
    }
    @Override
    public void setId(UniqueId m_Id) throws XtumlException {
        checkLiving();
        if (m_Id.inequality( this.m_Id)) {
            final UniqueId oldValue = this.m_Id;
            this.m_Id = m_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Id", oldValue, this.m_Id));
            if ( !R4501_is_implemented_by_ProvidedExecutableProperty().isEmpty() ) R4501_is_implemented_by_ProvidedExecutableProperty().setExecutableProperty_Id( m_Id );
            if ( !R4004_is_a_InterfaceSignal().isEmpty() ) R4004_is_a_InterfaceSignal().setId( m_Id );
            if ( !R4004_is_a_InterfaceOperation().isEmpty() ) R4004_is_a_InterfaceOperation().setId( m_Id );
            if ( !R4500_is_implemented_by_RequiredExecutableProperty().isEmpty() ) R4500_is_implemented_by_RequiredExecutableProperty().setExecutableProperty_Id( m_Id );
            if ( !R4006_is_parameter_to_PropertyParameter().isEmpty() ) R4006_is_parameter_to_PropertyParameter().setSignal_Id( m_Id );
        }
    }
    private UniqueId ref_Interface_Id;
    @Override
    public void setInterface_Id(UniqueId ref_Interface_Id) throws XtumlException {
        checkLiving();
        if (ref_Interface_Id.inequality( this.ref_Interface_Id)) {
            final UniqueId oldValue = this.ref_Interface_Id;
            this.ref_Interface_Id = ref_Interface_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Interface_Id", oldValue, this.ref_Interface_Id));
        }
    }
    @Override
    public UniqueId getInterface_Id() throws XtumlException {
        checkLiving();
        return ref_Interface_Id;
    }
    private IFDirectionType m_Direction;
    @Override
    public void setDirection(IFDirectionType m_Direction) throws XtumlException {
        checkLiving();
        if (m_Direction.inequality( this.m_Direction)) {
            final IFDirectionType oldValue = this.m_Direction;
            this.m_Direction = m_Direction;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Direction", oldValue, this.m_Direction));
        }
    }
    @Override
    public IFDirectionType getDirection() throws XtumlException {
        checkLiving();
        return m_Direction;
    }
    private String m_Name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    private String m_Descrip;
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private C_I R4003_provides_signature_of_C_I_inst;
    @Override
    public void setR4003_provides_signature_of_C_I( C_I inst ) {
        R4003_provides_signature_of_C_I_inst = inst;
    }
    @Override
    public C_I R4003_provides_signature_of_C_I() throws XtumlException {
        return R4003_provides_signature_of_C_I_inst;
    }
    private InterfaceOperation R4004_is_a_InterfaceOperation_inst;
    @Override
    public void setR4004_is_a_InterfaceOperation( InterfaceOperation inst ) {
        R4004_is_a_InterfaceOperation_inst = inst;
    }
    @Override
    public InterfaceOperation R4004_is_a_InterfaceOperation() throws XtumlException {
        return R4004_is_a_InterfaceOperation_inst;
    }
    private InterfaceSignal R4004_is_a_InterfaceSignal_inst;
    @Override
    public void setR4004_is_a_InterfaceSignal( InterfaceSignal inst ) {
        R4004_is_a_InterfaceSignal_inst = inst;
    }
    @Override
    public InterfaceSignal R4004_is_a_InterfaceSignal() throws XtumlException {
        return R4004_is_a_InterfaceSignal_inst;
    }
    private PropertyParameterSet R4006_is_parameter_to_PropertyParameter_set;
    @Override
    public void addR4006_is_parameter_to_PropertyParameter( PropertyParameter inst ) {
        R4006_is_parameter_to_PropertyParameter_set.add(inst);
    }
    @Override
    public void removeR4006_is_parameter_to_PropertyParameter( PropertyParameter inst ) {
        R4006_is_parameter_to_PropertyParameter_set.remove(inst);
    }
    @Override
    public PropertyParameterSet R4006_is_parameter_to_PropertyParameter() throws XtumlException {
        return R4006_is_parameter_to_PropertyParameter_set;
    }
    private RequiredExecutablePropertySet R4500_is_implemented_by_RequiredExecutableProperty_set;
    @Override
    public void addR4500_is_implemented_by_RequiredExecutableProperty( RequiredExecutableProperty inst ) {
        R4500_is_implemented_by_RequiredExecutableProperty_set.add(inst);
    }
    @Override
    public void removeR4500_is_implemented_by_RequiredExecutableProperty( RequiredExecutableProperty inst ) {
        R4500_is_implemented_by_RequiredExecutableProperty_set.remove(inst);
    }
    @Override
    public RequiredExecutablePropertySet R4500_is_implemented_by_RequiredExecutableProperty() throws XtumlException {
        return R4500_is_implemented_by_RequiredExecutableProperty_set;
    }
    private ProvidedExecutablePropertySet R4501_is_implemented_by_ProvidedExecutableProperty_set;
    @Override
    public void addR4501_is_implemented_by_ProvidedExecutableProperty( ProvidedExecutableProperty inst ) {
        R4501_is_implemented_by_ProvidedExecutableProperty_set.add(inst);
    }
    @Override
    public void removeR4501_is_implemented_by_ProvidedExecutableProperty( ProvidedExecutableProperty inst ) {
        R4501_is_implemented_by_ProvidedExecutableProperty_set.remove(inst);
    }
    @Override
    public ProvidedExecutablePropertySet R4501_is_implemented_by_ProvidedExecutableProperty() throws XtumlException {
        return R4501_is_implemented_by_ProvidedExecutableProperty_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ExecutableProperty self() {
        return this;
    }

    @Override
    public ExecutableProperty oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_EXECUTABLEPROPERTY;
    }

}

class EmptyExecutableProperty extends ModelInstance<ExecutableProperty,Sql> implements ExecutableProperty {

    // attributes
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setId( UniqueId m_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setInterface_Id( UniqueId ref_Interface_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getInterface_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDirection( IFDirectionType m_Direction ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public IFDirectionType getDirection() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public C_I R4003_provides_signature_of_C_I() {
        return C_IImpl.EMPTY_C_I;
    }
    @Override
    public InterfaceOperation R4004_is_a_InterfaceOperation() {
        return InterfaceOperationImpl.EMPTY_INTERFACEOPERATION;
    }
    @Override
    public InterfaceSignal R4004_is_a_InterfaceSignal() {
        return InterfaceSignalImpl.EMPTY_INTERFACESIGNAL;
    }
    @Override
    public PropertyParameterSet R4006_is_parameter_to_PropertyParameter() {
        return (new PropertyParameterSetImpl());
    }
    @Override
    public RequiredExecutablePropertySet R4500_is_implemented_by_RequiredExecutableProperty() {
        return (new RequiredExecutablePropertySetImpl());
    }
    @Override
    public ProvidedExecutablePropertySet R4501_is_implemented_by_ProvidedExecutableProperty() {
        return (new ProvidedExecutablePropertySetImpl());
    }


    @Override
    public String getKeyLetters() {
        return ExecutablePropertyImpl.KEY_LETTERS;
    }

    @Override
    public ExecutableProperty self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ExecutableProperty oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ExecutablePropertyImpl.EMPTY_EXECUTABLEPROPERTY;
    }

}
