package io.ciera.tool.sql.ooaofooa.association.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.association.Association;
import io.ciera.tool.sql.ooaofooa.association.ClassAsSimpleFormalizer;
import io.ciera.tool.sql.ooaofooa.association.ClassAsSimpleParticipant;
import io.ciera.tool.sql.ooaofooa.association.ClassAsSimpleParticipantSet;
import io.ciera.tool.sql.ooaofooa.association.SimpleAssociation;
import io.ciera.tool.sql.ooaofooa.association.impl.AssociationImpl;
import io.ciera.tool.sql.ooaofooa.association.impl.ClassAsSimpleFormalizerImpl;
import io.ciera.tool.sql.ooaofooa.association.impl.ClassAsSimpleParticipantSetImpl;


public class SimpleAssociationImpl extends ModelInstance<SimpleAssociation,Sql> implements SimpleAssociation {

    public static final String KEY_LETTERS = "R_SIMP";
    public static final SimpleAssociation EMPTY_SIMPLEASSOCIATION = new EmptySimpleAssociation();

    private Sql context;

    // constructors
    private SimpleAssociationImpl( Sql context ) {
        this.context = context;
        ref_Rel_ID = UniqueId.random();
        R206_is_a_Association_inst = AssociationImpl.EMPTY_ASSOCIATION;
        R207_relates_ClassAsSimpleParticipant_set = new ClassAsSimpleParticipantSetImpl();
        R208_relates_ClassAsSimpleFormalizer_inst = ClassAsSimpleFormalizerImpl.EMPTY_CLASSASSIMPLEFORMALIZER;
    }

    private SimpleAssociationImpl( Sql context, UniqueId instanceId, UniqueId ref_Rel_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Rel_ID = ref_Rel_ID;
        R206_is_a_Association_inst = AssociationImpl.EMPTY_ASSOCIATION;
        R207_relates_ClassAsSimpleParticipant_set = new ClassAsSimpleParticipantSetImpl();
        R208_relates_ClassAsSimpleFormalizer_inst = ClassAsSimpleFormalizerImpl.EMPTY_CLASSASSIMPLEFORMALIZER;
    }

    public static SimpleAssociation create( Sql context ) throws XtumlException {
        SimpleAssociation newSimpleAssociation = new SimpleAssociationImpl( context );
        if ( context.addInstance( newSimpleAssociation ) ) {
            newSimpleAssociation.getRunContext().addChange(new InstanceCreatedDelta(newSimpleAssociation, KEY_LETTERS));
            return newSimpleAssociation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static SimpleAssociation create( Sql context, UniqueId instanceId, UniqueId ref_Rel_ID ) throws XtumlException {
        SimpleAssociation newSimpleAssociation = new SimpleAssociationImpl( context, instanceId, ref_Rel_ID );
        if ( context.addInstance( newSimpleAssociation ) ) {
            return newSimpleAssociation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Rel_ID;
    @Override
    public void setRel_ID(UniqueId ref_Rel_ID) throws XtumlException {
        checkLiving();
        if (ref_Rel_ID.inequality( this.ref_Rel_ID)) {
            final UniqueId oldValue = this.ref_Rel_ID;
            this.ref_Rel_ID = ref_Rel_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Rel_ID", oldValue, this.ref_Rel_ID));
            if ( !R207_relates_ClassAsSimpleParticipant().isEmpty() ) R207_relates_ClassAsSimpleParticipant().setRel_ID( ref_Rel_ID );
            if ( !R208_relates_ClassAsSimpleFormalizer().isEmpty() ) R208_relates_ClassAsSimpleFormalizer().setRel_ID( ref_Rel_ID );
        }
    }
    @Override
    public UniqueId getRel_ID() throws XtumlException {
        checkLiving();
        return ref_Rel_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getRel_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Association R206_is_a_Association_inst;
    @Override
    public void setR206_is_a_Association( Association inst ) {
        R206_is_a_Association_inst = inst;
    }
    @Override
    public Association R206_is_a_Association() throws XtumlException {
        return R206_is_a_Association_inst;
    }
    private ClassAsSimpleParticipantSet R207_relates_ClassAsSimpleParticipant_set;
    @Override
    public void addR207_relates_ClassAsSimpleParticipant( ClassAsSimpleParticipant inst ) {
        R207_relates_ClassAsSimpleParticipant_set.add(inst);
    }
    @Override
    public void removeR207_relates_ClassAsSimpleParticipant( ClassAsSimpleParticipant inst ) {
        R207_relates_ClassAsSimpleParticipant_set.remove(inst);
    }
    @Override
    public ClassAsSimpleParticipantSet R207_relates_ClassAsSimpleParticipant() throws XtumlException {
        return R207_relates_ClassAsSimpleParticipant_set;
    }
    private ClassAsSimpleFormalizer R208_relates_ClassAsSimpleFormalizer_inst;
    @Override
    public void setR208_relates_ClassAsSimpleFormalizer( ClassAsSimpleFormalizer inst ) {
        R208_relates_ClassAsSimpleFormalizer_inst = inst;
    }
    @Override
    public ClassAsSimpleFormalizer R208_relates_ClassAsSimpleFormalizer() throws XtumlException {
        return R208_relates_ClassAsSimpleFormalizer_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public SimpleAssociation self() {
        return this;
    }

    @Override
    public SimpleAssociation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_SIMPLEASSOCIATION;
    }

}

class EmptySimpleAssociation extends ModelInstance<SimpleAssociation,Sql> implements SimpleAssociation {

    // attributes
    public void setRel_ID( UniqueId ref_Rel_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getRel_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Association R206_is_a_Association() {
        return AssociationImpl.EMPTY_ASSOCIATION;
    }
    @Override
    public ClassAsSimpleParticipantSet R207_relates_ClassAsSimpleParticipant() {
        return (new ClassAsSimpleParticipantSetImpl());
    }
    @Override
    public ClassAsSimpleFormalizer R208_relates_ClassAsSimpleFormalizer() {
        return ClassAsSimpleFormalizerImpl.EMPTY_CLASSASSIMPLEFORMALIZER;
    }


    @Override
    public String getKeyLetters() {
        return SimpleAssociationImpl.KEY_LETTERS;
    }

    @Override
    public SimpleAssociation self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public SimpleAssociation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return SimpleAssociationImpl.EMPTY_SIMPLEASSOCIATION;
    }

}
