package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.loader.InstanceLoaderSet;
import io.ciera.tool.sql.loader.TimerInstanceLoader;
import io.ciera.tool.sql.loader.TimerInstanceLoaderSet;
import io.ciera.tool.sql.loader.impl.InstanceLoaderSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class TimerInstanceLoaderSetImpl extends InstanceSet<TimerInstanceLoaderSet,TimerInstanceLoader> implements TimerInstanceLoaderSet {

    public TimerInstanceLoaderSetImpl() {
    }

    public TimerInstanceLoaderSetImpl(Comparator<? super TimerInstanceLoader> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        for ( TimerInstanceLoader timerinstanceloader : this ) timerinstanceloader.setLoader_package( ref_loader_package );
    }
    @Override
    public void setClass_name( String ref_class_name ) throws XtumlException {
        for ( TimerInstanceLoader timerinstanceloader : this ) timerinstanceloader.setClass_name( ref_class_name );
    }
    @Override
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        for ( TimerInstanceLoader timerinstanceloader : this ) timerinstanceloader.setLoader_name( ref_loader_name );
    }


    // selections
    @Override
    public InstanceLoaderSet R3016_is_a_InstanceLoader() throws XtumlException {
        InstanceLoaderSet instanceloaderset = new InstanceLoaderSetImpl();
        for ( TimerInstanceLoader timerinstanceloader : this ) instanceloaderset.add( timerinstanceloader.R3016_is_a_InstanceLoader() );
        return instanceloaderset;
    }


    @Override
    public TimerInstanceLoader nullElement() {
        return TimerInstanceLoaderImpl.EMPTY_TIMERINSTANCELOADER;
    }

    @Override
    public TimerInstanceLoaderSet emptySet() {
      return new TimerInstanceLoaderSetImpl();
    }

    @Override
    public TimerInstanceLoaderSet emptySet(Comparator<? super TimerInstanceLoader> comp) {
      return new TimerInstanceLoaderSetImpl(comp);
    }

    @Override
    public List<TimerInstanceLoader> elements() {
        return Arrays.asList(toArray(new TimerInstanceLoader[0]));
    }

}
