package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.file.GeneralFileSet;
import io.ciera.tool.sql.architecture.file.impl.GeneralFileSetImpl;
import io.ciera.tool.sql.loader.BatchRelatorSet;
import io.ciera.tool.sql.loader.InstanceLoaderSet;
import io.ciera.tool.sql.loader.InstanceSerializerSet;
import io.ciera.tool.sql.loader.PopulationLoader;
import io.ciera.tool.sql.loader.PopulationLoaderSet;
import io.ciera.tool.sql.loader.impl.BatchRelatorSetImpl;
import io.ciera.tool.sql.loader.impl.InstanceLoaderSetImpl;
import io.ciera.tool.sql.loader.impl.InstanceSerializerSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class PopulationLoaderSetImpl extends InstanceSet<PopulationLoaderSet,PopulationLoader> implements PopulationLoaderSet {

    public PopulationLoaderSetImpl() {
    }

    public PopulationLoaderSetImpl(Comparator<? super PopulationLoader> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setPackage( String ref_package ) throws XtumlException {
        for ( PopulationLoader populationloader : this ) populationloader.setPackage( ref_package );
    }
    @Override
    public void setComp_name( String m_comp_name ) throws XtumlException {
        for ( PopulationLoader populationloader : this ) populationloader.setComp_name( m_comp_name );
    }
    @Override
    public void setName( String ref_name ) throws XtumlException {
        for ( PopulationLoader populationloader : this ) populationloader.setName( ref_name );
    }


    // selections
    @Override
    public InstanceSerializerSet R3001_serializes_population_using_InstanceSerializer() throws XtumlException {
        InstanceSerializerSet instanceserializerset = new InstanceSerializerSetImpl();
        for ( PopulationLoader populationloader : this ) instanceserializerset.addAll( populationloader.R3001_serializes_population_using_InstanceSerializer() );
        return instanceserializerset;
    }
    @Override
    public InstanceLoaderSet R3005_loads_population_using_InstanceLoader() throws XtumlException {
        InstanceLoaderSet instanceloaderset = new InstanceLoaderSetImpl();
        for ( PopulationLoader populationloader : this ) instanceloaderset.addAll( populationloader.R3005_loads_population_using_InstanceLoader() );
        return instanceloaderset;
    }
    @Override
    public GeneralFileSet R3009_is_a_GeneralFile() throws XtumlException {
        GeneralFileSet generalfileset = new GeneralFileSetImpl();
        for ( PopulationLoader populationloader : this ) generalfileset.add( populationloader.R3009_is_a_GeneralFile() );
        return generalfileset;
    }
    @Override
    public BatchRelatorSet R3011_relates_instances_using_BatchRelator() throws XtumlException {
        BatchRelatorSet batchrelatorset = new BatchRelatorSetImpl();
        for ( PopulationLoader populationloader : this ) batchrelatorset.addAll( populationloader.R3011_relates_instances_using_BatchRelator() );
        return batchrelatorset;
    }


    @Override
    public PopulationLoader nullElement() {
        return PopulationLoaderImpl.EMPTY_POPULATIONLOADER;
    }

    @Override
    public PopulationLoaderSet emptySet() {
      return new PopulationLoaderSetImpl();
    }

    @Override
    public PopulationLoaderSet emptySet(Comparator<? super PopulationLoader> comp) {
      return new PopulationLoaderSetImpl(comp);
    }

    @Override
    public List<PopulationLoader> elements() {
        PopulationLoader[] elements = toArray(new PopulationLoader[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
