package io.ciera.tool.sql.architecture.type.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.type.TypeSet;
import io.ciera.tool.sql.architecture.type.UnresolvedType;
import io.ciera.tool.sql.architecture.type.UnresolvedTypeSet;
import io.ciera.tool.sql.architecture.type.impl.TypeSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class UnresolvedTypeSetImpl extends InstanceSet<UnresolvedTypeSet,UnresolvedType> implements UnresolvedTypeSet {

    public UnresolvedTypeSetImpl() {
    }

    public UnresolvedTypeSetImpl(Comparator<? super UnresolvedType> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setNum( int m_num ) throws XtumlException {
        for ( UnresolvedType unresolvedtype : this ) unresolvedtype.setNum( m_num );
    }
    @Override
    public void setName( String ref_name ) throws XtumlException {
        for ( UnresolvedType unresolvedtype : this ) unresolvedtype.setName( ref_name );
    }
    @Override
    public void setPackage( String ref_package ) throws XtumlException {
        for ( UnresolvedType unresolvedtype : this ) unresolvedtype.setPackage( ref_package );
    }


    // selections
    @Override
    public TypeSet R407_is_a_Type() throws XtumlException {
        TypeSet typeset = new TypeSetImpl();
        for ( UnresolvedType unresolvedtype : this ) typeset.add( unresolvedtype.R407_is_a_Type() );
        return typeset;
    }


    @Override
    public UnresolvedType nullElement() {
        return UnresolvedTypeImpl.EMPTY_UNRESOLVEDTYPE;
    }

    @Override
    public UnresolvedTypeSet emptySet() {
      return new UnresolvedTypeSetImpl();
    }

    @Override
    public UnresolvedTypeSet emptySet(Comparator<? super UnresolvedType> comp) {
      return new UnresolvedTypeSetImpl(comp);
    }

    @Override
    public List<UnresolvedType> elements() {
        UnresolvedType[] elements = toArray(new UnresolvedType[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
