package io.ciera.tool.sql.architecture.type.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.file.FileSet;
import io.ciera.tool.sql.architecture.file.impl.FileSetImpl;
import io.ciera.tool.sql.architecture.type.EnumeratedType;
import io.ciera.tool.sql.architecture.type.EnumeratedTypeSet;
import io.ciera.tool.sql.architecture.type.EnumeratorSet;
import io.ciera.tool.sql.architecture.type.TypeSet;
import io.ciera.tool.sql.architecture.type.impl.EnumeratorSetImpl;
import io.ciera.tool.sql.architecture.type.impl.TypeSetImpl;
import io.ciera.tool.sql.loader.EnumeratorLoaderSet;
import io.ciera.tool.sql.loader.impl.EnumeratorLoaderSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class EnumeratedTypeSetImpl extends InstanceSet<EnumeratedTypeSet,EnumeratedType> implements EnumeratedTypeSet {

    public EnumeratedTypeSetImpl() {
    }

    public EnumeratedTypeSetImpl(Comparator<? super EnumeratedType> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setName( String ref_name ) throws XtumlException {
        for ( EnumeratedType enumeratedtype : this ) enumeratedtype.setName( ref_name );
    }
    @Override
    public void setPackage( String ref_package ) throws XtumlException {
        for ( EnumeratedType enumeratedtype : this ) enumeratedtype.setPackage( ref_package );
    }


    // selections
    @Override
    public EnumeratorLoaderSet R3010_EnumeratorLoader() throws XtumlException {
        EnumeratorLoaderSet enumeratorloaderset = new EnumeratorLoaderSetImpl();
        for ( EnumeratedType enumeratedtype : this ) enumeratorloaderset.addAll( enumeratedtype.R3010_EnumeratorLoader() );
        return enumeratorloaderset;
    }
    @Override
    public FileSet R401_is_a_File() throws XtumlException {
        FileSet fileset = new FileSetImpl();
        for ( EnumeratedType enumeratedtype : this ) fileset.add( enumeratedtype.R401_is_a_File() );
        return fileset;
    }
    @Override
    public TypeSet R407_is_a_Type() throws XtumlException {
        TypeSet typeset = new TypeSetImpl();
        for ( EnumeratedType enumeratedtype : this ) typeset.add( enumeratedtype.R407_is_a_Type() );
        return typeset;
    }
    @Override
    public EnumeratorSet R415_declares_Enumerator() throws XtumlException {
        EnumeratorSet enumeratorset = new EnumeratorSetImpl();
        for ( EnumeratedType enumeratedtype : this ) enumeratorset.addAll( enumeratedtype.R415_declares_Enumerator() );
        return enumeratorset;
    }


    @Override
    public EnumeratedType nullElement() {
        return EnumeratedTypeImpl.EMPTY_ENUMERATEDTYPE;
    }

    @Override
    public EnumeratedTypeSet emptySet() {
      return new EnumeratedTypeSetImpl();
    }

    @Override
    public EnumeratedTypeSet emptySet(Comparator<? super EnumeratedType> comp) {
      return new EnumeratedTypeSetImpl(comp);
    }

    @Override
    public List<EnumeratedType> elements() {
        EnumeratedType[] elements = toArray(new EnumeratedType[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
